LANG_LIBS = {
    "en": [
        "Question:",
        "Options:",
        "Answer: Let's think step by step.",
        'The following are multiple choice questions (with answers) about {subject}. Think step by step and then finish your answer with "{ans_suffix}" where X is the correct letter choice.',
        "A: Let's think step by step.",
        "the answer is ({})",
    ],
    "ja": [
        "質問：",
        "選択肢：",
        "回答：一歩一歩考えていきましょう。",
        "以下は{subject}に関する選択問題（解答付き）です。段階的に考え、最後に「{ans_suffix}」と回答を締めくくってください。Xは正解の選択肢を示す文字です。",
        "A: 一歩一歩考えていきましょう。",
        "答えは ({}) です",
    ],
    "zh": [
        "问题：",
        "选项：",
        "答案：让我们一步一步地思考。",
        '以下是关于{subject}的选择题（带有答案）。请逐步思考，然后以"{ans_suffix}"结束您的回答，其中X是正确的选项字母。',
        "A: 让我们一步一步地思考。",
        "答案是 ({})",
    ],
    "ko": [
        "질문：",
        "선택 사항：",
        "답변: 한 단계씩 생각해 봅시다.",
        '다음은 {subject}에 관한 객관식 문제(정답 포함)입니다. 단계적으로 생각한 다음 "{ans_suffix}"로 답변을 마무리하세요. 여기서 X는 올바른 선택지 문자입니다.',
        "A: 한 단계씩 생각해 봅시다.",
        "답은 ({})입니다",
    ],
    "fr": [
        "Question :",
        "Options :",
        "Réponse : Réfléchissons étape par étape.",
        'Voici des questions à choix multiples (avec réponses) sur {subject}. Réfléchissez étape par étape, puis terminez votre réponse par "{ans_suffix}" où X est la lettre correspondant au bon choix.',
        "A: Réfléchissons étape par étape.",
        "La réponse est ({})",
    ],
    "de": [
        "Frage:",
        "Optionen:",
        "Antwort: Denken wir Schritt für Schritt nach.",
        'Im Folgenden sind Multiple-Choice-Fragen (mit Antworten) zu {subject}. Denken Sie Schritt für Schritt nach und beenden Sie Ihre Antwort mit "{ans_suffix}", wobei X der richtige Buchstabe ist.',
        "A: Denken wir Schritt für Schritt nach.",
        "Die Antwort ist ({})",
    ],
    "es": [
        "Pregunta:",
        "Opciones:",
        "Respuesta: Pensemos paso a paso.",
        'Las siguientes son preguntas de opción múltiple (con respuestas) sobre {subject}. Piense paso a paso y luego termine su respuesta con "{ans_suffix}" donde X es la letra de la opción correcta.',
        "A: Pensemos paso a paso.",
        "La respuesta es ({})",
    ],
    "pt": [
        "Pergunta:",
        "Opções:",
        "Resposta: Vamos pensar passo a passo.",
        'A seguir estão perguntas de múltipla escolha (com respostas) sobre {subject}. Pense passo a passo e termine sua resposta com "{ans_suffix}" onde X é a letra da opção correta.',
        "A: Vamos pensar passo a passo.",
        "A resposta é ({})",
    ],
    "zu": [
        "Umbuzo:",
        "Izinketho:",
        "Impendulo: Asicabange isinyathelo ngesinyathelo.",
        'Okulandelayo yimibuzo ehlukahlukene (enezimpendulo) mayelana ne-{subject}. Cabanga isinyathelo ngesinyathelo bese uqeda impendulo yakho nge-"{ans_suffix}" lapho u-X eyinhlamvu eyisinqumo esifanele.',
        "A: Asicabange isinyathelo ngesinyathelo.",
        "Impendulo ithi ({})",
    ],
    "sw": [
        "Swali:",
        "Chaguo:",
        "Jibu: Hebu tufikiria hatua kwa hatua.",
        'Yafuatayo ni maswali ya chaguo-nyingi (yenye majibu) kuhusu {subject}. Fikiria hatua kwa hatua kisha malizia jibu lako kwa "{ans_suffix}" ambapo X ni herufi ya chaguo sahihi.',
        "A: Hebu tufikiria hatua kwa hatua.",
        "Jibu ni ({})",
    ],
    "wo": [
        "Laaj:",
        "Tànneef:",
        "Tontu: Nan xalaat ci dooley dooley.",
        'Li ci topp ay laaj yu am tànneef la (ak tontu) ci mbir mi ñuy wax {subject}. Xalaatal ci dooley dooley te nga jeexal sa tontu ak "{ans_suffix}" fu X di araf bi jëkk ci tontu bi.',
        "A: Nan xalaat ci dooley dooley.",
        "Tontu bi mooy ({})",
    ],
    "yo": [
        "Ìbéèrè:",
        "Àwọn àṣàyàn:",
        "Ìdáhùn: Ẹ jẹ́ ká ronú lọ́nà tíṣíṣe.",
        'Àwọn wọ̀nyí jẹ́ àwọn ìbéèrè ọ̀pọ̀ àṣàyàn (pẹ̀lú àwọn ìdáhùn) nípa {subject}. Rò ní ìṣẹ́sẹ́ kí o sì parí ìdáhùn rẹ pẹ̀lú "{ans_suffix}" níbi tí X jẹ́ lẹ́tà àṣàyàn tó tọ́.',
        "A: Ẹ jẹ́ ká ronú lọ́nà tíṣíṣe.",
        "Ìdáhùn náà ni ({})",
    ],
    "th": [
        "คำถาม:",
        "ตัวเลือก:",
        "คำตอบ: มาคิดทีละขั้นตอนกัน",
        'ต่อไปนี้เป็นคำถามปรนัย (พร้อมคำตอบ) เกี่ยวกับ {subject} คิดทีละขั้นตอนแล้วสรุปคำตอบด้วย "{ans_suffix}" โดยที่ X คือตัวอักษรที่เป็นตัวเลือกที่ถูกต้อง',
        "A: มาคิดทีละขั้นตอนกัน",
        "คำตอบคือ ({})",
    ],
    "ar": [
        "سؤال:",
        "الخيارات:",
        "الإجابة: دعنا نفكر خطوة بخطوة.",
        "فيما يلي أسئلة اختيار من متعدد (مع إجابات) حول {subject}. فكر خطوة بخطوة ثم أنهِ إجابتك بـ '{ans_suffix}' حيث X هو حرف الخيار الصحيح.",
        "أ: دعنا نفكر خطوة بخطوة.",
        "الإجابة هي ({})",
    ],
    "hi": [
        "प्रश्न:",
        "विकल्प:",
        "उत्तर: चलिए चरण-दर-चरण सोचते हैं।",
        'निम्नलिखित {subject} के बारे में बहुविकल्पीय प्रश्न (उत्तरों के साथ) हैं। चरण-दर-चरण सोचें और फिर अपने उत्तर को "{ans_suffix}" के साथ समाप्त करें जहां X सही विकल्प का अक्षर है।',
        "A: चलिए चरण-दर-चरण सोचते हैं।",
        "उत्तर है ({})",
    ],
    "bn": [
        "প্রশ্ন:",
        "বিকল্পগুলি:",
        "উত্তর: আসুন ধাপে ধাপে চিন্তা করি।",
        'নিম্নলিখিত {subject} সম্পর্কে বহুনির্বাচনী প্রশ্ন (উত্তরসহ)। ধাপে ধাপে চিন্তা করুন এবং তারপর আপনার উত্তর "{ans_suffix}" দিয়ে শেষ করুন যেখানে X হল সঠিক বিকল্পের অক্ষর।',
        "A: আসুন ধাপে ধাপে চিন্তা করি।",
        "উত্তর হল ({})",
    ],
    "mr": [
        "प्रश्न:",
        "पर्याय:",
        "उत्तर: चला पायरी पायरीने विचार करू.",
        'खाली {subject} विषयावरील बहुपर्यायी प्रश्न आहेत (उत्तरांसह). कृपया पायरी पायरीने विचार करा आणि आपले उत्तर "{ans_suffix}" असे संपवा, जिथे X हे योग्य पर्यायाचे अक्षर आहे.',
        "A: चला पायरी पायरीने विचार करू.",
        "उत्तर आहे ({})",
    ],
    "ne": [
        "प्रश्न:",
        "विकल्पहरू:",
        "उत्तर: चरणबद्ध रूपमा सोचौं।",
        'यहाँ {subject} सम्बन्धी बहुवैकल्पिक प्रश्नहरू छन् (उत्तरहरू सहित)। कृपया चरणबद्ध रूपमा सोच्नुहोस् र आफ्नो उत्तर "{ans_suffix}" बाट अन्त्य गर्नुहोस्, जहाँ X सही विकल्पको अक्षर हो।',
        "A: चरणबद्ध रूपमा सोचौं।",
        "उत्तर ({}) हो।",
    ],
    "af": [
        "Vraag:",
        "Opsies:",
        "Antwoord: Kom ons dink stap vir stap.",
        'Hier is \'n multikeusevraag oor {subject} (met antwoorde). Dink asseblief stap vir stap en eindig jou antwoord met "{ans_suffix}", waar X die letter van die korrekte opsie is.',
        "A: Kom ons dink stap vir stap.",
        "Die antwoord is ({})",
    ],
    "te": [
        "ప్రశ్న:",
        "ఎంపికలు:",
        "సమాధానం: దశలవారీగా ఆలోచిద్దాం.",
        'క్రింది {subject}కి సంబంధించిన బహుళఎంపిక ప్రశ్న (సమాధానాలతో). దయచేసి దశలవారీగా ఆలోచించి, మీ సమాధానాన్ని "{ans_suffix}"తో ముగించండి, ఇక్కడ X సరైన ఎంపిక అక్షరం.',
        "A: దశలవారీగా ఆలోచిద్దాం.",
        "సమాధానం ({})",
    ],
    "ur": [
        "سوال:",
        "آپشنز:",
        "جواب: آئیے قدم بہ قدم سوچتے ہیں۔",
        'درج ذیل {subject} کے متعلق ایک متعدد انتخابی سوال ہے (جوابات کے ساتھ)۔ براہ کرم قدم بہ قدم سوچیں، اور پھر اپنے جواب کو "{ans_suffix}" کے ساتھ ختم کریں، جہاں X درست آپشن کا حرف ہے۔',
        "A: آئیے قدم بہ قدم سوچتے ہیں۔",
        "جواب ({}) ہے",
    ],
    "ru": [
        "Вопрос:",
        "Варианты:",
        "Ответ: Давайте подумаем шаг за шагом.",
        'Ниже приведен вопрос с множественным выбором о {subject} (с ответами). Пожалуйста, размышляйте шаг за шагом, а затем завершите свой ответ с "{ans_suffix}", где X - это буква правильного варианта.',
        "A: Давайте подумаем шаг за шагом.",
        "Ответ - ({})",
    ],
    "id": [
        "Pertanyaan:",
        "Pilihan:",
        "Jawaban: Mari berpikir langkah demi langkah.",
        'Berikut adalah pertanyaan pilihan ganda tentang {subject} (dengan jawaban). Harap berpikir langkah demi langkah, lalu akhiri jawaban Anda dengan "{ans_suffix}", di mana X adalah huruf pilihan yang benar.',
        "A: Mari berpikir langkah demi langkah.",
        "Jawabannya adalah ({})",
    ],
    "vi": [
        "Câu hỏi:",
        "Lựa chọn:",
        "Trả lời: Hãy suy nghĩ từng bước một.",
        'Dưới đây là câu hỏi trắc nghiệm về {subject} (kèm đáp án). Vui lòng suy nghĩ từng bước, sau đó kết thúc câu trả lời của bạn bằng "{ans_suffix}", trong đó X là chữ cái của lựa chọn đúng.',
        "A: Hãy suy nghĩ từng bước một.",
        "Câu trả lời là ({})",
    ],
    "cs": [
        "Otázka:",
        "Možnosti:",
        "Odpověď: Přemýšlejme krok za krokem.",
        'Zde je otázka s výběrem možností k tématu {subject} (s odpovědí). Přemýšlejte prosím krok za krokem a svou odpověď zakončete "{ans_suffix}", kde X je písmeno správné možnosti.',
        "A: Přemýšlejme krok za krokem.",
        "Odpověď je ({})",
    ],
    "hu": [
        "Kérdés:",
        "Opciók:",
        "Válasz: Gondolkodjunk lépésről lépésre.",
        'Itt van egy feleletválasztós kérdés a(z) {subject} témában (választ is tartalmazza). Kérjük, gondolkodjon lépésről lépésre, és a válaszát a(z) "{ans_suffix}" kifejezéssel fejezze be, ahol X a helyes válasz betűjele.',
        "A: Gondolkodjunk lépésről lépésre.",
        "A válasz ({})",
    ],
    "it": [
        "Domanda:",
        "Opzioni:",
        "Risposta: Ragioniamo passo dopo passo.",
        'Ecco una domanda a scelta multipla su {subject} (con risposta). Si prega di ragionare passo dopo passo e terminare la risposta con "{ans_suffix}", dove X è la lettera dell\'opzione corretta.',
        "A: Ragioniamo passo dopo passo.",
        "La risposta è ({})",
    ],
    "sr": [
        "Pitanje:",
        "Opcije:",
        "Odgovor: Razmislimo korak po korak.",
        'Evo pitanja sa višestrukim izborom o {subject} (sa odgovorom). Molimo vas da razmislite korak po korak i završite svoj odgovor sa "{ans_suffix}", gde je X slovo tačne opcije.',
        "A: Razmislimo korak po korak.",
        "Odgovor je ({})",
    ],
    "uk": [
        "Питання:",
        "Варіанти:",
        "Відповідь: Давайте подумаємо крок за кроком.",
        'Ось запитання з вибором відповідей на тему {subject} (з відповіддю). Будь ласка, подумайте крок за кроком і закінчіть свою відповідь "{ans_suffix}", де X – літера правильного варіанту.',
        "A: Давайте подумаємо крок за кроком.",
        "Відповідь: ({})",
    ],
}


LANG_SUBJECTS = {
    "en": {
        "biology": "biology",
        "business": "business",
        "chemistry": "chemistry",
        "computer_science": "computer_science",
        "economics": "economics",
        "engineering": "engineering",
        "health": "health",
        "history": "history",
        "law": "law",
        "math": "math",
        "other": "other",
        "philosophy": "philosophy",
        "physics": "physics",
        "psychology": "psychology",
    },
    "ja": {
        "biology": "生物学",
        "business": "ビジネス",
        "chemistry": "化学",
        "computer_science": "コンピュータサイエンス",
        "economics": "経済学",
        "engineering": "工学",
        "health": "健康科学",
        "history": "歴史",
        "law": "法律",
        "math": "数学",
        "other": "その他",
        "philosophy": "哲学",
        "physics": "物理学",
        "psychology": "心理学",
    },
    "zh": {
        "biology": "生物学",
        "business": "商业",
        "chemistry": "化学",
        "computer_science": "计算机科学",
        "economics": "经济学",
        "engineering": "工程学",
        "health": "健康",
        "history": "历史",
        "law": "法律",
        "math": "数学",
        "other": "其他",
        "philosophy": "哲学",
        "physics": "物理学",
        "psychology": "心理学",
    },
    "ko": {
        "biology": "생물학",
        "business": "경영학",
        "chemistry": "화학",
        "computer_science": "컴퓨터 과학",
        "economics": "경제학",
        "engineering": "공학",
        "health": "건강",
        "history": "역사",
        "law": "법률",
        "math": "수학",
        "other": "기타",
        "philosophy": "철학",
        "physics": "물리학",
        "psychology": "심리학",
    },
    "fr": {
        "biology": "biologie",
        "business": "commerce",
        "chemistry": "chimie",
        "computer_science": "informatique",
        "economics": "économie",
        "engineering": "ingénierie",
        "health": "santé",
        "history": "histoire",
        "law": "droit",
        "math": "mathématiques",
        "other": "autre",
        "philosophy": "philosophie",
        "physics": "physique",
        "psychology": "psychologie",
    },
    "de": {
        "biology": "Biologie",
        "business": "Wirtschaft",
        "chemistry": "Chemie",
        "computer_science": "Informatik",
        "economics": "Ökonomie",
        "engineering": "Ingenieurwesen",
        "health": "Gesundheit",
        "history": "Geschichte",
        "law": "Recht",
        "math": "Mathematik",
        "other": "Sonstiges",
        "philosophy": "Philosophie",
        "physics": "Physik",
        "psychology": "Psychologie",
    },
    "es": {
        "biology": "biología",
        "business": "negocios",
        "chemistry": "química",
        "computer_science": "informática",
        "economics": "economía",
        "engineering": "ingeniería",
        "health": "salud",
        "history": "historia",
        "law": "derecho",
        "math": "matemáticas",
        "other": "otro",
        "philosophy": "filosofía",
        "physics": "física",
        "psychology": "psicología",
    },
    "pt": {
        "biology": "biologia",
        "business": "negócios",
        "chemistry": "química",
        "computer_science": "ciência da computação",
        "economics": "economia",
        "engineering": "engenharia",
        "health": "saúde",
        "history": "história",
        "law": "direito",
        "math": "matemática",
        "other": "outro",
        "philosophy": "filosofia",
        "physics": "física",
        "psychology": "psicologia",
    },
    "zu": {
        "biology": "isayensi yezilwane",
        "business": "ibhizinisi",
        "chemistry": "i-chemistry",
        "computer_science": "isayensi yekhompyutha",
        "economics": "ezomnotho",
        "engineering": "ubunjiniyela",
        "health": "ezempilo",
        "history": "umlando",
        "law": "umthetho",
        "math": "izibalo",
        "other": "okunye",
        "philosophy": "ifilosofi",
        "physics": "ifiziksi",
        "psychology": "isayensi yengqondo",
    },
    "sw": {
        "biology": "biolojia",
        "business": "biashara",
        "chemistry": "kemia",
        "computer_science": "sayansi ya kompyuta",
        "economics": "uchumi",
        "engineering": "uhandisi",
        "health": "afya",
        "history": "historia",
        "law": "sheria",
        "math": "hisabati",
        "other": "nyingine",
        "philosophy": "falsafa",
        "physics": "fizikia",
        "psychology": "saikolojia",
    },
    "wo": {
        "biology": "biologi",
        "business": "njëriñ",
        "chemistry": "simi",
        "computer_science": "xam-xam ordinatëer",
        "economics": "ekonomi",
        "engineering": "injenyëer",
        "health": "wergui yaramu",
        "history": "taariix",
        "law": "yoon",
        "math": "matematig",
        "other": "yeneen",
        "philosophy": "filosofi",
        "physics": "fisik",
        "psychology": "sikoloji",
    },
    "yo": {
        "biology": "ìmọ̀ nípa ẹ̀dá ààyè",
        "business": "iṣẹ́ òwò",
        "chemistry": "kẹ́místrì",
        "computer_science": "ìmọ̀ kọ̀mpútà",
        "economics": "ọ̀rọ̀ ajé",
        "engineering": "ìmọ̀ ìṣeiṣẹ́",
        "health": "ìlera",
        "history": "ìtàn",
        "law": "òfin",
        "math": "ìṣirò",
        "other": "òmíràn",
        "philosophy": "ìmọ̀ ọgbọ́n",
        "physics": "físíksì",
        "psychology": "ìmọ̀ inú",
    },
    "th": {
        "biology": "ชีววิทยา",
        "business": "ธุรกิจ",
        "chemistry": "เคมี",
        "computer_science": "วิทยาการคอมพิวเตอร์",
        "economics": "เศรษฐศาสตร์",
        "engineering": "วิศวกรรมศาสตร์",
        "health": "สุขภาพ",
        "history": "ประวัติศาสตร์",
        "law": "กฎหมาย",
        "math": "คณิตศาสตร์",
        "other": "อื่นๆ",
        "philosophy": "ปรัชญา",
        "physics": "ฟิสิกส์",
        "psychology": "จิตวิทยา",
    },
    "ar": {
        "biology": "علم الأحياء",
        "business": "الأعمال",
        "chemistry": "الكيمياء",
        "computer_science": "علوم الكمبيوتر",
        "economics": "الاقتصاد",
        "engineering": "الهندسة",
        "health": "الصحة",
        "history": "التاريخ",
        "law": "القانون",
        "math": "الرياضيات",
        "other": "أخرى",
        "philosophy": "الفلسفة",
        "physics": "الفيزياء",
        "psychology": "علم النفس",
    },
    "hi": {
        "biology": "जीव विज्ञान",
        "business": "व्यापार",
        "chemistry": "रसायन विज्ञान",
        "computer_science": "कंप्यूटर विज्ञान",
        "economics": "अर्थशास्त्र",
        "engineering": "इंजीनियरिंग",
        "health": "स्वास्थ्य",
        "history": "इतिहास",
        "law": "कानून",
        "math": "गणित",
        "other": "अन्य",
        "philosophy": "दर्शनशास्त्र",
        "physics": "भौतिकी",
        "psychology": "मनोविज्ञान",
    },
    "bn": {
        "biology": "জীববিজ্ঞান",
        "business": "ব্যবসা",
        "chemistry": "রসায়ন",
        "computer_science": "কম্পিউটার বিজ্ঞান",
        "economics": "অর্থনীতি",
        "engineering": "প্রকৌশল",
        "health": "স্বাস্থ্য",
        "history": "ইতিহাস",
        "law": "আইন",
        "math": "গণিত",
        "other": "অন্যান্য",
        "philosophy": "দর্শন",
        "physics": "পদার্থবিজ্ঞান",
        "psychology": "মনোবিজ্ঞান",
    },
    "mr": {
        "biology": "जीवशास्त्र",
        "business": "व्यवसाय",
        "chemistry": "रसायनशास्त्र",
        "computer_science": "संगणकशास्त्र",
        "economics": "अर्थशास्त्र",
        "engineering": "अभियांत्रिकी",
        "health": "आरोग्य",
        "history": "इतिहास",
        "law": "कायदा",
        "math": "गणित",
        "other": "इतर",
        "philosophy": "तत्त्वज्ञान",
        "physics": "भौतिकशास्त्र",
        "psychology": "मानसशास्त्र",
    },
    "ne": {
        "biology": "जीवविज्ञान",
        "business": "व्यापार",
        "chemistry": "रसायनशास्त्र",
        "computer_science": "कम्प्युटर विज्ञान",
        "economics": "अर्थशास्त्र",
        "engineering": "इन्जिनियरिङ",
        "health": "स्वास्थ्य",
        "history": "इतिहास",
        "law": "कानून",
        "math": "गणित",
        "other": "अन्य",
        "philosophy": "दर्शनशास्त्र",
        "physics": "भौतिकशास्त्र",
        "psychology": "मनोविज्ञान",
    },
    "af": {
        "biology": "Biologie",
        "business": "Besigheid",
        "chemistry": "Chemie",
        "computer_science": "Rekenaarwetenskap",
        "economics": "Ekonomie",
        "engineering": "Ingenieurswese",
        "health": "Gesondheid",
        "history": "Geskiedenis",
        "law": "Regte",
        "math": "Wiskunde",
        "other": "Ander",
        "philosophy": "Filosofie",
        "physics": "Fisika",
        "psychology": "Sielkunde",
    },
    "te": {
        "biology": "జీవశాస్త్రం",
        "business": "వ్యాపారం",
        "chemistry": "రసాయన శాస్త్రం",
        "computer_science": "కంప్యూటర్ సైన్స్",
        "economics": "ఆర్థిక శాస్త్రం",
        "engineering": "ఇంజనీరింగ్",
        "health": "ఆరోగ్యం",
        "history": "చరిత్ర",
        "law": "న్యాయశాస్త్రం",
        "math": "గణితం",
        "other": "ఇతరమైన",
        "philosophy": "తత్వవేత్త",
        "physics": "భౌతిక శాస్త్రం",
        "psychology": "మనోవిజ్ఞానశాస్త్రం",
    },
    "ur": {
        "biology": "حیاتیات",
        "business": "کاروبار",
        "chemistry": "کیمیا",
        "computer_science": "کمپیوٹر سائنس",
        "economics": "معاشیات",
        "engineering": "انجینئرنگ",
        "health": "صحت",
        "history": "تاریخ",
        "law": "قانون",
        "math": "ریاضی",
        "other": "دیگر",
        "philosophy": "فلسفہ",
        "physics": "طبیعیات",
        "psychology": "نفسیات",
    },
    "ru": {
        "biology": "Биология",
        "business": "Бизнес",
        "chemistry": "Химия",
        "computer_science": "Информатика",
        "economics": "Экономика",
        "engineering": "Инженерия",
        "health": "Здравоохранение",
        "history": "История",
        "law": "Право",
        "math": "Математика",
        "other": "Другое",
        "philosophy": "Философия",
        "physics": "Физика",
        "psychology": "Психология",
    },
    "id": {
        "biology": "Biologi",
        "business": "Bisnis",
        "chemistry": "Kimia",
        "computer_science": "Ilmu Komputer",
        "economics": "Ekonomi",
        "engineering": "Teknik",
        "health": "Kesehatan",
        "history": "Sejarah",
        "law": "Hukum",
        "math": "Matematika",
        "other": "Lainnya",
        "philosophy": "Filsafat",
        "physics": "Fisika",
        "psychology": "Psikologi",
    },
    "vi": {
        "biology": "Sinh học",
        "business": "Kinh doanh",
        "chemistry": "Hóa học",
        "computer_science": "Khoa học máy tính",
        "economics": "Kinh tế học",
        "engineering": "Kỹ thuật",
        "health": "Sức khỏe",
        "history": "Lịch sử",
        "law": "Luật pháp",
        "math": "Toán học",
        "other": "Khác",
        "philosophy": "Triết học",
        "physics": "Vật lý học",
        "psychology": "Tâm lý học",
    },
    "cs": {
        "biology": "biologie",
        "business": "obchod",
        "chemistry": "chemie",
        "computer_science": "informatika",
        "economics": "ekonomie",
        "engineering": "inženýrství",
        "health": "zdraví",
        "history": "historie",
        "law": "právo",
        "math": "matematika",
        "other": "ostatní",
        "philosophy": "filozofie",
        "physics": "fyzika",
        "psychology": "psychologie",
    },
    "hu": {
        "biology": "biológia",
        "business": "üzlet",
        "chemistry": "kémia",
        "computer_science": "informatika",
        "economics": "közgazdaságtan",
        "engineering": "mérnöki tudományok",
        "health": "egészség",
        "history": "történelem",
        "law": "jog",
        "math": "matematika",
        "other": "egyéb",
        "philosophy": "filozófia",
        "physics": "fizika",
        "psychology": "pszichológia",
    },
    "it": {
        "biology": "biologia",
        "business": "affari",
        "chemistry": "chimica",
        "computer_science": "informatica",
        "economics": "economia",
        "engineering": "ingegneria",
        "health": "salute",
        "history": "storia",
        "law": "diritto",
        "math": "matematica",
        "other": "altro",
        "philosophy": "filosofia",
        "physics": "fisica",
        "psychology": "psicologia",
    },
    "sr": {
        "biology": "biologija",
        "business": "poslovanje",
        "chemistry": "hemija",
        "computer_science": "računarstvo",
        "economics": "ekonomija",
        "engineering": "inženjerstvo",
        "health": "zdravlje",
        "history": "istorija",
        "law": "pravo",
        "math": "matematika",
        "other": "ostalo",
        "philosophy": "filozofija",
        "physics": "fizika",
        "psychology": "psihologija",
    },
    "uk": {
        "biology": "біологія",
        "business": "бізнес",
        "chemistry": "хімія",
        "computer_science": "інформатика",
        "economics": "економіка",
        "engineering": "інженерія",
        "health": "здоров'я",
        "history": "історія",
        "law": "право",
        "math": "математика",
        "other": "інше",
        "philosophy": "філософія",
        "physics": "фізика",
        "psychology": "психологія",
    },
}
