# EgyHellaSwag

### Paper

Title: NileChat: Towards Linguistically Diverse and Culturally Aware LLMs for Local Communities

Abstract: [https://arxiv.org/abs/2505.18383](https://arxiv.org/abs/2505.18383)

**EgyHellaSwag** is a benchmark for evaluating commonsense reasoning in Egyptian Arabic. It is a translated version of the HellaSwag benchmark, consisting of multiple-choice sentence completion tasks. The dataset was translated using the `google/gemma-3-27b-it` model.


Homepage: [https://huggingface.co/datasets/UBC-NLP/EgyHellaSwag](https://huggingface.co/datasets/UBC-NLP/EgyHellaSwag)


### Citation

```
@article{mekki2025nilechatlinguisticallydiverseculturally,
  title={NileChat: Towards Linguistically Diverse and Culturally Aware LLMs for Local Communities},
  author={Abdellah El Mekki and Houdaifa Atou and Omer Nacar and Shady Shehata and Muhammad Abdul-Mageed},
  year={2025},
  eprint={2505.18383},
  archivePrefix={arXiv},
  primaryClass={cs.CL},
  url={https://arxiv.org/abs/2505.18383},
}
```

### Groups and Tasks

#### Groups

* Not part of a group.

#### Tags

* `egyhellaswag`

### Checklist

For adding novel benchmarks/datasets to the library:
* [x] Is the task an existing benchmark in the literature?
  * [x] Have you referenced the original paper that introduced the task?
  * [ ] If yes, does the original paper provide a reference implementation? If so, have you checked against the reference implementation and documented how to run such a test?


If other tasks on this dataset are already supported:
* [ ] Is the "Main" variant of this task clearly denoted?
* [ ] Have you provided a short sentence in a README on what each new variant adds / evaluates?
* [ ] Have you noted which, if any, published evaluation setups are matched by this variant?
