// SPDX-License-Identifier: MIT
// Copyright (c) 2018-2024, Advanced Micro Devices, Inc. All rights reserved.

#pragma once

#include "ck_tile/core.hpp"
#include "ck_tile/host/kernel_launch.hpp"
#include "ck_tile/ops/layernorm2d.hpp"
#include <string>

template <typename InType, typename OutType>
struct LayerNormTypeConfig;

template <typename OutType>
struct LayerNormTypeConfig<ck_tile::half_t, OutType>
{
    using XDataType       = ck_tile::half_t;
    using YDataType       = OutType;
    using GammaDataType   = ck_tile::half_t;
    using BetaDataType    = ck_tile::half_t;
    using MeanDataType    = ck_tile::half_t;
    using InvStdDataType  = ck_tile::half_t;
    using ComputeDataType = float;
};

template <typename OutType>
struct LayerNormTypeConfig<ck_tile::bf16_t, OutType>
{
    using XDataType       = ck_tile::bf16_t;
    using YDataType       = OutType;
    using GammaDataType   = ck_tile::bf16_t;
    using BetaDataType    = ck_tile::bf16_t;
    using MeanDataType    = ck_tile::bf16_t;
    using InvStdDataType  = ck_tile::bf16_t;
    using ComputeDataType = float;
};

// runtime args
struct layernorm2d_fwd_args : public ck_tile::Layernorm2dFwdHostArgs
{
};

template <typename Traits_>
float layernorm2d_fwd_(const ck_tile::stream_config& s, layernorm2d_fwd_args a);

// This is the public API, will be generated by script
struct layernorm2d_fwd_traits
{
    std::string prec_i;
    std::string prec_o;
    bool save_mean_var;
    int fused_add;   // 0:no-add, 1:pre-add, 2:post-add
    int fused_sweep; // 0:no-sweep,
};

float layernorm2d_fwd(layernorm2d_fwd_traits, layernorm2d_fwd_args, const ck_tile::stream_config&);
