#ifndef CK_TILE_FLATMM_UK_MFMA
#define CK_TILE_FLATMM_UK_MFMA CK_TILE_FLATMM_UK_MFMA_INT8
#endif

#if CK_TILE_FLATMM_UK_MFMA == CK_TILE_FLATMM_UK_MFMA_INT8
#   define _UK_MFMA_ "v_mfma_i32_16x16x32_i8"

#   define _UK_PK_CVT_(x0_, x1_, y_)                           \
    "  v_cmp_u_f32   s[36:37], " x0_ ", " x0_ "          \n"   \
    "  v_add3_u32    v50, " x0_ ", %[v_nan_lo], 1        \n"   \
    "  v_cndmask_b32  v54, v50, %[v_nan_hi], s[36:37]    \n"   \
    "  v_cmp_u_f32   s[36:37], " x1_ ", " x1_ "          \n"   \
    "  v_add3_u32    v50, " x1_ ", %[v_nan_lo], 1        \n"   \
    "  v_cndmask_b32  v55, v50, %[v_nan_hi], s[36:37]    \n"   \
    "  v_perm_b32    " y_ ", v55, v54, s52               \n"

#   define _UK_ATOMIC_ADD_ "global_atomic_pk_add_bf16"

#elif CK_TILE_FLATMM_UK_MFMA == CK_TILE_FLATMM_UK_MFMA_FP16
#define _UK_MFMA_ "v_mfma_f32_16x16x16_f16"

#   define _UK_PK_CVT_(x0_, x1_, y_)                \
    "  v_cvt_f16_f32  v54, " x0_ "  \n"             \
    "  v_cvt_f16_f32  v55, " x1_ "  \n"             \
    "  v_pack_b32_f16 " y_ ", v54, v55  \n"

#   define _UK_ATOMIC_ADD_ "global_atomic_pk_add_f16"

#endif
" s_mov_b32     s36, -1               \n"
"  s_mov_b32     s37, -1                 \n"
"  s_add_u32     s12, %[s_tile_os_b], s12                          \n"
"  s_addc_u32    s13, 0, s13                            \n"
"  s_add_u32     s16, %[s_tile_os_dq], s16                          \n"
"  s_addc_u32    s17, 0, s17                            \n"
"  s_mov_b32     s80, 0                                 \n"
"  s_waitcnt     0x0000                                 \n"
"  label_startgemm2:                   \n"
"  s_waitcnt     vmcnt(41)                              \n"
"  s_barrier                                            \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[0:1], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[2:3], v[130:131], v[192:195]  \n"
"  buffer_load_dwordx4  acc[128:131], %[v_os_b0], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[4:5], v[132:133], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[6:7], v[134:135], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[8:9], v[136:137], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[10:11], v[138:139], v[192:195]  \n"
"  buffer_load_dwordx4  acc[132:135], %[v_os_b0], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[12:13], v[140:141], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[14:15], v[142:143], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[0:1], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[2:3], v[162:163], v[196:199]  \n"
"  buffer_load_dwordx4  acc[136:139], %[v_os_b0], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[4:5], v[164:165], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[6:7], v[166:167], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[8:9], v[168:169], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[10:11], v[170:171], v[196:199]  \n"
"  buffer_load_dwordx4  acc[140:143], %[v_os_b0], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[12:13], v[172:173], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[14:15], v[174:175], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[16:17], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[18:19], v[130:131], v[200:203]  \n"
"  buffer_load_dwordx4  acc[144:147], %[v_os_b1], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[20:21], v[132:133], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[22:23], v[134:135], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[24:25], v[136:137], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[26:27], v[138:139], v[200:203]  \n"
"  buffer_load_dwordx4  acc[148:151], %[v_os_b1], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[28:29], v[140:141], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[30:31], v[142:143], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[16:17], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[18:19], v[162:163], v[204:207]  \n"
"  buffer_load_dwordx4  acc[152:155], %[v_os_b1], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[20:21], v[164:165], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[22:23], v[166:167], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[24:25], v[168:169], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[26:27], v[170:171], v[204:207]  \n"
"  buffer_load_dwordx4  acc[156:159], %[v_os_b1], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[28:29], v[172:173], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[30:31], v[174:175], v[204:207]  \n"
"  s_waitcnt     vmcnt(41)                              \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[32:33], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[34:35], v[130:131], v[208:211]  \n"
"  buffer_load_dwordx4  acc[160:163], %[v_os_b2], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[36:37], v[132:133], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[38:39], v[134:135], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[40:41], v[136:137], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[42:43], v[138:139], v[208:211]  \n"
"  buffer_load_dwordx4  acc[164:167], %[v_os_b2], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[44:45], v[140:141], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[46:47], v[142:143], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[32:33], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[34:35], v[162:163], v[212:215]  \n"
"  buffer_load_dwordx4  acc[168:171], %[v_os_b2], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[36:37], v[164:165], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[38:39], v[166:167], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[40:41], v[168:169], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[42:43], v[170:171], v[212:215]  \n"
"  buffer_load_dwordx4  acc[172:175], %[v_os_b2], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[44:45], v[172:173], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[46:47], v[174:175], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[48:49], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[50:51], v[130:131], v[216:219]  \n"
"  buffer_load_dwordx4  acc[176:179], %[v_os_b3], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[52:53], v[132:133], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[54:55], v[134:135], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[56:57], v[136:137], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[58:59], v[138:139], v[216:219]  \n"
"  buffer_load_dwordx4  acc[180:183], %[v_os_b3], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[60:61], v[140:141], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[62:63], v[142:143], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[48:49], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[50:51], v[162:163], v[220:223]  \n"
"  buffer_load_dwordx4  acc[184:187], %[v_os_b3], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[52:53], v[164:165], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[54:55], v[166:167], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[56:57], v[168:169], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[58:59], v[170:171], v[220:223]  \n"
"  buffer_load_dwordx4  acc[188:191], %[v_os_b3], s[12:15], 0 offen offset:3072  \n"
"  s_add_u32     s12, %[s_tile_os_b_half], s12                          \n"
"  s_addc_u32    s13, 0, s13                            \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[60:61], v[172:173], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[62:63], v[174:175], v[220:223]  \n"
"  s_waitcnt     vmcnt(41)                              \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[64:65], v[144:145], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[66:67], v[146:147], v[192:195]  \n"
"  buffer_load_dwordx4  acc[192:195], %[v_os_b0], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[68:69], v[148:149], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[70:71], v[150:151], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[72:73], v[152:153], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[74:75], v[154:155], v[192:195]  \n"
"  buffer_load_dwordx4  acc[196:199], %[v_os_b0], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[76:77], v[156:157], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[192:195], acc[78:79], v[158:159], v[192:195]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[64:65], v[176:177], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[66:67], v[178:179], v[196:199]  \n"
"  buffer_load_dwordx4  acc[200:203], %[v_os_b0], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[68:69], v[180:181], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[70:71], v[182:183], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[72:73], v[184:185], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[74:75], v[186:187], v[196:199]  \n"
"  buffer_load_dwordx4  acc[204:207], %[v_os_b0], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[76:77], v[188:189], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[196:199], acc[78:79], v[190:191], v[196:199]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[80:81], v[144:145], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[82:83], v[146:147], v[200:203]  \n"
"  buffer_load_dwordx4  acc[208:211], %[v_os_b1], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[84:85], v[148:149], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[86:87], v[150:151], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[88:89], v[152:153], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[90:91], v[154:155], v[200:203]  \n"
"  buffer_load_dwordx4  acc[212:215], %[v_os_b1], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[92:93], v[156:157], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[200:203], acc[94:95], v[158:159], v[200:203]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[80:81], v[176:177], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[82:83], v[178:179], v[204:207]  \n"
"  buffer_load_dwordx4  acc[216:219], %[v_os_b1], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[84:85], v[180:181], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[86:87], v[182:183], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[88:89], v[184:185], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[90:91], v[186:187], v[204:207]  \n"
"  buffer_load_dwordx4  acc[220:223], %[v_os_b1], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[92:93], v[188:189], v[204:207]  \n"
"  v_mfma_i32_16x16x32_i8  v[204:207], acc[94:95], v[190:191], v[204:207]  \n"
"  s_waitcnt     vmcnt(40)                              \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[96:97], v[144:145], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[98:99], v[146:147], v[208:211]  \n"
"  buffer_load_dwordx4  acc[224:227], %[v_os_b2], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[100:101], v[148:149], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[102:103], v[150:151], v[208:211]  \n"
"  buffer_load_dword  v13, %[v_os_dq], s[16:19], 0 offen        \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[104:105], v[152:153], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[106:107], v[154:155], v[208:211]  \n"
"  buffer_load_dwordx4  acc[228:231], %[v_os_b2], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[108:109], v[156:157], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[208:211], acc[110:111], v[158:159], v[208:211]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[96:97], v[176:177], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[98:99], v[178:179], v[212:215]  \n"
"  buffer_load_dwordx4  acc[232:235], %[v_os_b2], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[100:101], v[180:181], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[102:103], v[182:183], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[104:105], v[184:185], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[106:107], v[186:187], v[212:215]  \n"
"  buffer_load_dwordx4  acc[236:239], %[v_os_b2], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[108:109], v[188:189], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[212:215], acc[110:111], v[190:191], v[212:215]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[112:113], v[144:145], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[114:115], v[146:147], v[216:219]  \n"
"  buffer_load_dwordx4  acc[240:243], %[v_os_b3], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[116:117], v[148:149], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[118:119], v[150:151], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[120:121], v[152:153], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[122:123], v[154:155], v[216:219]  \n"
"  buffer_load_dwordx4  acc[244:247], %[v_os_b3], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[124:125], v[156:157], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[216:219], acc[126:127], v[158:159], v[216:219]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[112:113], v[176:177], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[114:115], v[178:179], v[220:223]  \n"
"  buffer_load_dwordx4  acc[248:251], %[v_os_b3], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[116:117], v[180:181], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[118:119], v[182:183], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[120:121], v[184:185], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[122:123], v[186:187], v[220:223]  \n"
"  buffer_load_dwordx4  acc[252:255], %[v_os_b3], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[124:125], v[188:189], v[220:223]  \n"
"  v_mfma_i32_16x16x32_i8  v[220:223], acc[126:127], v[190:191], v[220:223]  \n"
"  s_add_u32     s60, 0x00000200, s80                   \n"
"  s_cmp_lt_u32  s60, s81                               \n"
"  s_cselect_b32  %[s_tile_os_b], %[s_tile_os_b], 0                           \n"
"  s_cselect_b32  %[s_tile_os_b_half], %[s_tile_os_b_half], 0                           \n"
"  s_cselect_b32  %[s_tile_os_dq], %[s_tile_os_dq], 0                           \n"
"  s_add_u32     s12, %[s_tile_os_b], s12                          \n"
"  s_addc_u32    s13, 0, s13                            \n"
"  s_add_u32     s16, %[s_tile_os_dq], s16                          \n"
"  s_addc_u32    s17, 0, s17                            \n"
"  v_cvt_f32_i32  v192, v192                            \n"
"  v_cvt_f32_i32  v193, v193                            \n"
"  v_cvt_f32_i32  v194, v194                            \n"
"  v_cvt_f32_i32  v195, v195                            \n"
"  v_mul_f32     v192, v24, v192                        \n"
"  v_mul_f32     v193, v24, v193                        \n"
"  v_mul_f32     v194, v24, v194                        \n"
"  v_mul_f32     v195, v24, v195                        \n"
"  v_mul_f32     v192, v12, v192 row_newbcast:0         \n"
"  v_mul_f32     v193, v12, v193 row_newbcast:1         \n"
"  v_mul_f32     v194, v12, v194 row_newbcast:2         \n"
"  v_mul_f32     v195, v12, v195 row_newbcast:3         \n"
"  v_mul_f32     v192, %[scale_0], v192                        \n"
"  v_mul_f32     v193, %[scale_0], v193                        \n"
"  v_mul_f32     v194, %[scale_0], v194                        \n"
"  v_mul_f32     v195, %[scale_0], v195                        \n"
"  v_cvt_f32_i32  v196, v196                            \n"
"  v_cvt_f32_i32  v197, v197                            \n"
"  v_cvt_f32_i32  v198, v198                            \n"
"  v_cvt_f32_i32  v199, v199                            \n"
"  v_mul_f32     v196, v25, v196                        \n"
"  v_mul_f32     v197, v25, v197                        \n"
"  v_mul_f32     v198, v25, v198                        \n"
"  v_mul_f32     v199, v25, v199                        \n"
"  v_mul_f32     v196, v12, v196 row_newbcast:0         \n"
"  v_mul_f32     v197, v12, v197 row_newbcast:1         \n"
"  v_mul_f32     v198, v12, v198 row_newbcast:2         \n"
"  v_mul_f32     v199, v12, v199 row_newbcast:3         \n"
"  v_mul_f32     v196, %[scale_1], v196                        \n"
"  v_mul_f32     v197, %[scale_1], v197                        \n"
"  v_mul_f32     v198, %[scale_1], v198                        \n"
"  v_mul_f32     v199, %[scale_1], v199                        \n"
"  v_cvt_f32_i32  v200, v200                            \n"
"  v_cvt_f32_i32  v201, v201                            \n"
"  v_cvt_f32_i32  v202, v202                            \n"
"  v_cvt_f32_i32  v203, v203                            \n"
"  v_mul_f32     v200, v24, v200                        \n"
"  v_mul_f32     v201, v24, v201                        \n"
"  v_mul_f32     v202, v24, v202                        \n"
"  v_mul_f32     v203, v24, v203                        \n"
"  v_mul_f32     v200, v12, v200 row_newbcast:4         \n"
"  v_mul_f32     v201, v12, v201 row_newbcast:5         \n"
"  v_mul_f32     v202, v12, v202 row_newbcast:6         \n"
"  v_mul_f32     v203, v12, v203 row_newbcast:7         \n"
"  v_mul_f32     v200, %[scale_0], v200                        \n"
"  v_mul_f32     v201, %[scale_0], v201                        \n"
"  v_mul_f32     v202, %[scale_0], v202                        \n"
"  v_mul_f32     v203, %[scale_0], v203                        \n"
"  v_cvt_f32_i32  v204, v204                            \n"
"  v_cvt_f32_i32  v205, v205                            \n"
"  v_cvt_f32_i32  v206, v206                            \n"
"  v_cvt_f32_i32  v207, v207                            \n"
"  v_mul_f32     v204, v25, v204                        \n"
"  v_mul_f32     v205, v25, v205                        \n"
"  v_mul_f32     v206, v25, v206                        \n"
"  v_mul_f32     v207, v25, v207                        \n"
"  v_mul_f32     v204, v12, v204 row_newbcast:4         \n"
"  v_mul_f32     v205, v12, v205 row_newbcast:5         \n"
"  v_mul_f32     v206, v12, v206 row_newbcast:6         \n"
"  v_mul_f32     v207, v12, v207 row_newbcast:7         \n"
"  v_mul_f32     v204, %[scale_1], v204                        \n"
"  v_mul_f32     v205, %[scale_1], v205                        \n"
"  v_mul_f32     v206, %[scale_1], v206                        \n"
"  v_mul_f32     v207, %[scale_1], v207                        \n"
"  v_cvt_f32_i32  v208, v208                            \n"
"  v_cvt_f32_i32  v209, v209                            \n"
"  v_cvt_f32_i32  v210, v210                            \n"
"  v_cvt_f32_i32  v211, v211                            \n"
"  v_mul_f32     v208, v24, v208                        \n"
"  v_mul_f32     v209, v24, v209                        \n"
"  v_mul_f32     v210, v24, v210                        \n"
"  v_mul_f32     v211, v24, v211                        \n"
"  v_mul_f32     v208, v12, v208 row_newbcast:8         \n"
"  v_mul_f32     v209, v12, v209 row_newbcast:9         \n"
"  v_mul_f32     v210, v12, v210 row_newbcast:10        \n"
"  v_mul_f32     v211, v12, v211 row_newbcast:11        \n"
"  v_mul_f32     v208, %[scale_0], v208                        \n"
"  v_mul_f32     v209, %[scale_0], v209                        \n"
"  v_mul_f32     v210, %[scale_0], v210                        \n"
"  v_mul_f32     v211, %[scale_0], v211                        \n"
"  v_cvt_f32_i32  v212, v212                            \n"
"  v_cvt_f32_i32  v213, v213                            \n"
"  v_cvt_f32_i32  v214, v214                            \n"
"  v_cvt_f32_i32  v215, v215                            \n"
"  v_mul_f32     v212, v25, v212                        \n"
"  v_mul_f32     v213, v25, v213                        \n"
"  v_mul_f32     v214, v25, v214                        \n"
"  v_mul_f32     v215, v25, v215                        \n"
"  v_mul_f32     v212, v12, v212 row_newbcast:8         \n"
"  v_mul_f32     v213, v12, v213 row_newbcast:9         \n"
"  v_mul_f32     v214, v12, v214 row_newbcast:10        \n"
"  v_mul_f32     v215, v12, v215 row_newbcast:11        \n"
"  v_mul_f32     v212, %[scale_1], v212                        \n"
"  v_mul_f32     v213, %[scale_1], v213                        \n"
"  v_mul_f32     v214, %[scale_1], v214                        \n"
"  v_mul_f32     v215, %[scale_1], v215                        \n"
"  v_cvt_f32_i32  v216, v216                            \n"
"  v_cvt_f32_i32  v217, v217                            \n"
"  v_cvt_f32_i32  v218, v218                            \n"
"  v_cvt_f32_i32  v219, v219                            \n"
"  v_mul_f32     v216, v24, v216                        \n"
"  v_mul_f32     v217, v24, v217                        \n"
"  v_mul_f32     v218, v24, v218                        \n"
"  v_mul_f32     v219, v24, v219                        \n"
"  v_mul_f32     v216, v12, v216 row_newbcast:12        \n"
"  v_mul_f32     v217, v12, v217 row_newbcast:13        \n"
"  v_mul_f32     v218, v12, v218 row_newbcast:14        \n"
"  v_mul_f32     v219, v12, v219 row_newbcast:15        \n"
"  v_mul_f32     v216, %[scale_0], v216                        \n"
"  v_mul_f32     v217, %[scale_0], v217                        \n"
"  v_mul_f32     v218, %[scale_0], v218                        \n"
"  v_mul_f32     v219, %[scale_0], v219                        \n"
"  v_cvt_f32_i32  v220, v220                            \n"
"  v_cvt_f32_i32  v221, v221                            \n"
"  v_cvt_f32_i32  v222, v222                            \n"
"  v_cvt_f32_i32  v223, v223                            \n"
"  v_mul_f32     v220, v25, v220                        \n"
"  v_mul_f32     v221, v25, v221                        \n"
"  v_mul_f32     v222, v25, v222                        \n"
"  v_mul_f32     v223, v25, v223                        \n"
"  v_mul_f32     v220, v12, v220 row_newbcast:12        \n"
"  v_mul_f32     v221, v12, v221 row_newbcast:13        \n"
"  v_mul_f32     v222, v12, v222 row_newbcast:14        \n"
"  v_mul_f32     v223, v12, v223 row_newbcast:15        \n"
"  v_mul_f32     v220, %[scale_1], v220                        \n"
"  v_mul_f32     v221, %[scale_1], v221                        \n"
"  v_mul_f32     v222, %[scale_1], v222                        \n"
"  v_mul_f32     v223, %[scale_1], v223                        \n"
"  v_cmp_u_f32   s[48:49], v192, v192                   \n"
"  v_add3_u32    v50, v192, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v193, v193                   \n"
"  v_add3_u32    v50, v193, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v192, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v194, v194                   \n"
"  v_add3_u32    v50, v194, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v195, v195                   \n"
"  v_add3_u32    v50, v195, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v193, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v196, v196                   \n"
"  v_add3_u32    v50, v196, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v197, v197                   \n"
"  v_add3_u32    v50, v197, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v194, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v198, v198                   \n"
"  v_add3_u32    v50, v198, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v199, v199                   \n"
"  v_add3_u32    v50, v199, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v195, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v200, v200                   \n"
"  v_add3_u32    v50, v200, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v201, v201                   \n"
"  v_add3_u32    v50, v201, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v196, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v202, v202                   \n"
"  v_add3_u32    v50, v202, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v203, v203                   \n"
"  v_add3_u32    v50, v203, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v197, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v204, v204                   \n"
"  v_add3_u32    v50, v204, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v205, v205                   \n"
"  v_add3_u32    v50, v205, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v198, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v206, v206                   \n"
"  v_add3_u32    v50, v206, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v207, v207                   \n"
"  v_add3_u32    v50, v207, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v199, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v208, v208                   \n"
"  v_add3_u32    v50, v208, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v209, v209                   \n"
"  v_add3_u32    v50, v209, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v200, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v210, v210                   \n"
"  v_add3_u32    v50, v210, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v211, v211                   \n"
"  v_add3_u32    v50, v211, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v201, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v212, v212                   \n"
"  v_add3_u32    v50, v212, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v213, v213                   \n"
"  v_add3_u32    v50, v213, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v202, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v214, v214                   \n"
"  v_add3_u32    v50, v214, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v215, v215                   \n"
"  v_add3_u32    v50, v215, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v203, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v216, v216                   \n"
"  v_add3_u32    v50, v216, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v217, v217                   \n"
"  v_add3_u32    v50, v217, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v204, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v218, v218                   \n"
"  v_add3_u32    v50, v218, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v219, v219                   \n"
"  v_add3_u32    v50, v219, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v205, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v220, v220                   \n"
"  v_add3_u32    v50, v220, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v221, v221                   \n"
"  v_add3_u32    v50, v221, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v206, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v222, v222                   \n"
"  v_add3_u32    v50, v222, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v223, v223                   \n"
"  v_add3_u32    v50, v223, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v207, v55, v54, s52                    \n"
"  ds_write_b64  v3, v[192:193] offset:35072            \n"
"  ds_write_b64  v3, v[194:195] offset:43776            \n"
"  ds_write_b64  v3, v[196:197] offset:37248            \n"
"  ds_write_b64  v3, v[198:199] offset:45952            \n"
"  ds_write_b64  v3, v[200:201] offset:39424            \n"
"  ds_write_b64  v3, v[202:203] offset:48128            \n"
"  ds_write_b64  v3, v[204:205] offset:41600            \n"
"  ds_write_b64  v3, v[206:207] offset:50304            \n"
"  s_waitcnt     lgkmcnt(0)                             \n"
"  s_barrier                                            \n"
"  ds_read_b32   v64, v4 offset:35072                   \n"
"  ds_read_b32   v65, v4 offset:39424                   \n"
"  ds_read_b32   v66, v4 offset:35104                   \n"
"  ds_read_b32   v67, v4 offset:39456                   \n"
"  ds_read_b32   v68, v4 offset:35136                   \n"
"  ds_read_b32   v69, v4 offset:39488                   \n"
"  ds_read_b32   v70, v4 offset:35168                   \n"
"  ds_read_b32   v71, v4 offset:39520                   \n"
"  ds_read_b32   v72, v4 offset:43776                   \n"
"  ds_read_b32   v73, v4 offset:48128                   \n"
"  ds_read_b32   v74, v4 offset:43808                   \n"
"  ds_read_b32   v75, v4 offset:48160                   \n"
"  ds_read_b32   v76, v4 offset:43840                   \n"
"  ds_read_b32   v77, v4 offset:48192                   \n"
"  ds_read_b32   v78, v4 offset:43872                   \n"
"  ds_read_b32   v79, v4 offset:48224                   \n"
"  s_waitcnt     lgkmcnt(0)                             \n"
"  s_mov_b64     exec, %[s_execflag_0]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o0], v64, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_0]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o0], v65, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_1]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o1], v66, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_1]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o1], v67, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_2]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o2], v68, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_2]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o2], v69, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_3]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o3], v70, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_3]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o3], v71, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_4]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o4], v72, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_4]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o4], v73, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_5]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o5], v74, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_5]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o5], v75, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_6]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o6], v76, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_6]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o6], v77, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_7]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o7], v78, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_7]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o7], v79, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_add_u32     %[s_res_o0], s59, %[s_res_o0]                            \n"
"  s_addc_u32    %[s_res_o1], 0, %[s_res_o1]                              \n"
"  s_addk_i32    s80, 0x0100                            \n"
"  s_cmp_lt_i32  s80, s81                               \n"
"  s_cbranch_scc0  label_end_gemm2                           \n"
"  s_waitcnt     vmcnt(41)                              \n"
"  s_barrier                                            \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[128:129], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[130:131], v[130:131], v[224:227]  \n"
"  buffer_load_dwordx4  acc[0:3], %[v_os_b0], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[132:133], v[132:133], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[134:135], v[134:135], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[136:137], v[136:137], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[138:139], v[138:139], v[224:227]  \n"
"  buffer_load_dwordx4  acc[4:7], %[v_os_b0], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[140:141], v[140:141], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[142:143], v[142:143], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[128:129], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[130:131], v[162:163], v[228:231]  \n"
"  buffer_load_dwordx4  acc[8:11], %[v_os_b0], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[132:133], v[164:165], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[134:135], v[166:167], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[136:137], v[168:169], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[138:139], v[170:171], v[228:231]  \n"
"  buffer_load_dwordx4  acc[12:15], %[v_os_b0], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[140:141], v[172:173], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[142:143], v[174:175], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[144:145], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[146:147], v[130:131], v[232:235]  \n"
"  buffer_load_dwordx4  acc[16:19], %[v_os_b1], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[148:149], v[132:133], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[150:151], v[134:135], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[152:153], v[136:137], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[154:155], v[138:139], v[232:235]  \n"
"  buffer_load_dwordx4  acc[20:23], %[v_os_b1], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[156:157], v[140:141], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[158:159], v[142:143], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[144:145], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[146:147], v[162:163], v[236:239]  \n"
"  buffer_load_dwordx4  acc[24:27], %[v_os_b1], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[148:149], v[164:165], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[150:151], v[166:167], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[152:153], v[168:169], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[154:155], v[170:171], v[236:239]  \n"
"  buffer_load_dwordx4  acc[28:31], %[v_os_b1], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[156:157], v[172:173], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[158:159], v[174:175], v[236:239]  \n"
"  s_waitcnt     vmcnt(41)                              \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[160:161], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[162:163], v[130:131], v[240:243]  \n"
"  buffer_load_dwordx4  acc[32:35], %[v_os_b2], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[164:165], v[132:133], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[166:167], v[134:135], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[168:169], v[136:137], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[170:171], v[138:139], v[240:243]  \n"
"  buffer_load_dwordx4  acc[36:39], %[v_os_b2], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[172:173], v[140:141], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[174:175], v[142:143], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[160:161], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[162:163], v[162:163], v[244:247]  \n"
"  buffer_load_dwordx4  acc[40:43], %[v_os_b2], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[164:165], v[164:165], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[166:167], v[166:167], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[168:169], v[168:169], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[170:171], v[170:171], v[244:247]  \n"
"  buffer_load_dwordx4  acc[44:47], %[v_os_b2], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[172:173], v[172:173], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[174:175], v[174:175], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[176:177], v[128:129], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[178:179], v[130:131], v[248:251]  \n"
"  buffer_load_dwordx4  acc[48:51], %[v_os_b3], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[180:181], v[132:133], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[182:183], v[134:135], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[184:185], v[136:137], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[186:187], v[138:139], v[248:251]  \n"
"  buffer_load_dwordx4  acc[52:55], %[v_os_b3], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[188:189], v[140:141], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[190:191], v[142:143], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[176:177], v[160:161], 0  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[178:179], v[162:163], v[252:255]  \n"
"  buffer_load_dwordx4  acc[56:59], %[v_os_b3], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[180:181], v[164:165], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[182:183], v[166:167], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[184:185], v[168:169], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[186:187], v[170:171], v[252:255]  \n"
"  buffer_load_dwordx4  acc[60:63], %[v_os_b3], s[12:15], 0 offen offset:3072  \n"
"  s_add_u32     s12, %[s_tile_os_b_half], s12                          \n"
"  s_addc_u32    s13, 0, s13                            \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[188:189], v[172:173], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[190:191], v[174:175], v[252:255]  \n"
"  s_waitcnt     vmcnt(41)                              \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[192:193], v[144:145], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[194:195], v[146:147], v[224:227]  \n"
"  buffer_load_dwordx4  acc[64:67], %[v_os_b0], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[196:197], v[148:149], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[198:199], v[150:151], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[200:201], v[152:153], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[202:203], v[154:155], v[224:227]  \n"
"  buffer_load_dwordx4  acc[68:71], %[v_os_b0], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[204:205], v[156:157], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[224:227], acc[206:207], v[158:159], v[224:227]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[192:193], v[176:177], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[194:195], v[178:179], v[228:231]  \n"
"  buffer_load_dwordx4  acc[72:75], %[v_os_b0], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[196:197], v[180:181], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[198:199], v[182:183], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[200:201], v[184:185], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[202:203], v[186:187], v[228:231]  \n"
"  buffer_load_dwordx4  acc[76:79], %[v_os_b0], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[204:205], v[188:189], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[228:231], acc[206:207], v[190:191], v[228:231]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[208:209], v[144:145], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[210:211], v[146:147], v[232:235]  \n"
"  buffer_load_dwordx4  acc[80:83], %[v_os_b1], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[212:213], v[148:149], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[214:215], v[150:151], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[216:217], v[152:153], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[218:219], v[154:155], v[232:235]  \n"
"  buffer_load_dwordx4  acc[84:87], %[v_os_b1], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[220:221], v[156:157], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[232:235], acc[222:223], v[158:159], v[232:235]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[208:209], v[176:177], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[210:211], v[178:179], v[236:239]  \n"
"  buffer_load_dwordx4  acc[88:91], %[v_os_b1], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[212:213], v[180:181], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[214:215], v[182:183], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[216:217], v[184:185], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[218:219], v[186:187], v[236:239]  \n"
"  buffer_load_dwordx4  acc[92:95], %[v_os_b1], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[220:221], v[188:189], v[236:239]  \n"
"  v_mfma_i32_16x16x32_i8  v[236:239], acc[222:223], v[190:191], v[236:239]  \n"
"  s_waitcnt     vmcnt(40)                              \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[224:225], v[144:145], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[226:227], v[146:147], v[240:243]  \n"
"  buffer_load_dwordx4  acc[96:99], %[v_os_b2], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[228:229], v[148:149], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[230:231], v[150:151], v[240:243]  \n"
"  buffer_load_dword  v12, %[v_os_dq], s[16:19], 0 offen        \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[232:233], v[152:153], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[234:235], v[154:155], v[240:243]  \n"
"  buffer_load_dwordx4  acc[100:103], %[v_os_b2], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[236:237], v[156:157], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[240:243], acc[238:239], v[158:159], v[240:243]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[224:225], v[176:177], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[226:227], v[178:179], v[244:247]  \n"
"  buffer_load_dwordx4  acc[104:107], %[v_os_b2], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[228:229], v[180:181], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[230:231], v[182:183], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[232:233], v[184:185], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[234:235], v[186:187], v[244:247]  \n"
"  buffer_load_dwordx4  acc[108:111], %[v_os_b2], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[236:237], v[188:189], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[244:247], acc[238:239], v[190:191], v[244:247]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[240:241], v[144:145], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[242:243], v[146:147], v[248:251]  \n"
"  buffer_load_dwordx4  acc[112:115], %[v_os_b3], s[12:15], 0 offen  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[244:245], v[148:149], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[246:247], v[150:151], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[248:249], v[152:153], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[250:251], v[154:155], v[248:251]  \n"
"  buffer_load_dwordx4  acc[116:119], %[v_os_b3], s[12:15], 0 offen offset:1024  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[252:253], v[156:157], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[248:251], acc[254:255], v[158:159], v[248:251]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[240:241], v[176:177], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[242:243], v[178:179], v[252:255]  \n"
"  buffer_load_dwordx4  acc[120:123], %[v_os_b3], s[12:15], 0 offen offset:2048  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[244:245], v[180:181], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[246:247], v[182:183], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[248:249], v[184:185], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[250:251], v[186:187], v[252:255]  \n"
"  buffer_load_dwordx4  acc[124:127], %[v_os_b3], s[12:15], 0 offen offset:3072  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[252:253], v[188:189], v[252:255]  \n"
"  v_mfma_i32_16x16x32_i8  v[252:255], acc[254:255], v[190:191], v[252:255]  \n"
"  s_add_u32     s60, 0x00000200, s80                   \n"
"  s_cmp_lt_u32  s60, s81                               \n"
"  s_cselect_b32  %[s_tile_os_b], %[s_tile_os_b], 0                           \n"
"  s_cselect_b32  %[s_tile_os_b_half], %[s_tile_os_b_half], 0                           \n"
"  s_cselect_b32  %[s_tile_os_dq], %[s_tile_os_dq], 0                           \n"
"  s_add_u32     s12, %[s_tile_os_b], s12                          \n"
"  s_addc_u32    s13, 0, s13                            \n"
"  s_add_u32     s16, %[s_tile_os_dq], s16                          \n"
"  s_addc_u32    s17, 0, s17                            \n"
"  v_cvt_f32_i32  v224, v224                            \n"
"  v_cvt_f32_i32  v225, v225                            \n"
"  v_cvt_f32_i32  v226, v226                            \n"
"  v_cvt_f32_i32  v227, v227                            \n"
"  v_mul_f32     v224, v24, v224                        \n"
"  v_mul_f32     v225, v24, v225                        \n"
"  v_mul_f32     v226, v24, v226                        \n"
"  v_mul_f32     v227, v24, v227                        \n"
"  v_mul_f32     v224, v13, v224 row_newbcast:0         \n"
"  v_mul_f32     v225, v13, v225 row_newbcast:1         \n"
"  v_mul_f32     v226, v13, v226 row_newbcast:2         \n"
"  v_mul_f32     v227, v13, v227 row_newbcast:3         \n"
"  v_mul_f32     v224, %[scale_0], v224                        \n"
"  v_mul_f32     v225, %[scale_0], v225                        \n"
"  v_mul_f32     v226, %[scale_0], v226                        \n"
"  v_mul_f32     v227, %[scale_0], v227                        \n"
"  v_cvt_f32_i32  v228, v228                            \n"
"  v_cvt_f32_i32  v229, v229                            \n"
"  v_cvt_f32_i32  v230, v230                            \n"
"  v_cvt_f32_i32  v231, v231                            \n"
"  v_mul_f32     v228, v25, v228                        \n"
"  v_mul_f32     v229, v25, v229                        \n"
"  v_mul_f32     v230, v25, v230                        \n"
"  v_mul_f32     v231, v25, v231                        \n"
"  v_mul_f32     v228, v13, v228 row_newbcast:0         \n"
"  v_mul_f32     v229, v13, v229 row_newbcast:1         \n"
"  v_mul_f32     v230, v13, v230 row_newbcast:2         \n"
"  v_mul_f32     v231, v13, v231 row_newbcast:3         \n"
"  v_mul_f32     v228, %[scale_1], v228                        \n"
"  v_mul_f32     v229, %[scale_1], v229                        \n"
"  v_mul_f32     v230, %[scale_1], v230                        \n"
"  v_mul_f32     v231, %[scale_1], v231                        \n"
"  v_cvt_f32_i32  v232, v232                            \n"
"  v_cvt_f32_i32  v233, v233                            \n"
"  v_cvt_f32_i32  v234, v234                            \n"
"  v_cvt_f32_i32  v235, v235                            \n"
"  v_mul_f32     v232, v24, v232                        \n"
"  v_mul_f32     v233, v24, v233                        \n"
"  v_mul_f32     v234, v24, v234                        \n"
"  v_mul_f32     v235, v24, v235                        \n"
"  v_mul_f32     v232, v13, v232 row_newbcast:4         \n"
"  v_mul_f32     v233, v13, v233 row_newbcast:5         \n"
"  v_mul_f32     v234, v13, v234 row_newbcast:6         \n"
"  v_mul_f32     v235, v13, v235 row_newbcast:7         \n"
"  v_mul_f32     v232, %[scale_0], v232                        \n"
"  v_mul_f32     v233, %[scale_0], v233                        \n"
"  v_mul_f32     v234, %[scale_0], v234                        \n"
"  v_mul_f32     v235, %[scale_0], v235                        \n"
"  v_cvt_f32_i32  v236, v236                            \n"
"  v_cvt_f32_i32  v237, v237                            \n"
"  v_cvt_f32_i32  v238, v238                            \n"
"  v_cvt_f32_i32  v239, v239                            \n"
"  v_mul_f32     v236, v25, v236                        \n"
"  v_mul_f32     v237, v25, v237                        \n"
"  v_mul_f32     v238, v25, v238                        \n"
"  v_mul_f32     v239, v25, v239                        \n"
"  v_mul_f32     v236, v13, v236 row_newbcast:4         \n"
"  v_mul_f32     v237, v13, v237 row_newbcast:5         \n"
"  v_mul_f32     v238, v13, v238 row_newbcast:6         \n"
"  v_mul_f32     v239, v13, v239 row_newbcast:7         \n"
"  v_mul_f32     v236, %[scale_1], v236                        \n"
"  v_mul_f32     v237, %[scale_1], v237                        \n"
"  v_mul_f32     v238, %[scale_1], v238                        \n"
"  v_mul_f32     v239, %[scale_1], v239                        \n"
"  v_cvt_f32_i32  v240, v240                            \n"
"  v_cvt_f32_i32  v241, v241                            \n"
"  v_cvt_f32_i32  v242, v242                            \n"
"  v_cvt_f32_i32  v243, v243                            \n"
"  v_mul_f32     v240, v24, v240                        \n"
"  v_mul_f32     v241, v24, v241                        \n"
"  v_mul_f32     v242, v24, v242                        \n"
"  v_mul_f32     v243, v24, v243                        \n"
"  v_mul_f32     v240, v13, v240 row_newbcast:8         \n"
"  v_mul_f32     v241, v13, v241 row_newbcast:9         \n"
"  v_mul_f32     v242, v13, v242 row_newbcast:10        \n"
"  v_mul_f32     v243, v13, v243 row_newbcast:11        \n"
"  v_mul_f32     v240, %[scale_0], v240                        \n"
"  v_mul_f32     v241, %[scale_0], v241                        \n"
"  v_mul_f32     v242, %[scale_0], v242                        \n"
"  v_mul_f32     v243, %[scale_0], v243                        \n"
"  v_cvt_f32_i32  v244, v244                            \n"
"  v_cvt_f32_i32  v245, v245                            \n"
"  v_cvt_f32_i32  v246, v246                            \n"
"  v_cvt_f32_i32  v247, v247                            \n"
"  v_mul_f32     v244, v25, v244                        \n"
"  v_mul_f32     v245, v25, v245                        \n"
"  v_mul_f32     v246, v25, v246                        \n"
"  v_mul_f32     v247, v25, v247                        \n"
"  v_mul_f32     v244, v13, v244 row_newbcast:8         \n"
"  v_mul_f32     v245, v13, v245 row_newbcast:9         \n"
"  v_mul_f32     v246, v13, v246 row_newbcast:10        \n"
"  v_mul_f32     v247, v13, v247 row_newbcast:11        \n"
"  v_mul_f32     v244, %[scale_1], v244                        \n"
"  v_mul_f32     v245, %[scale_1], v245                        \n"
"  v_mul_f32     v246, %[scale_1], v246                        \n"
"  v_mul_f32     v247, %[scale_1], v247                        \n"
"  v_cvt_f32_i32  v248, v248                            \n"
"  v_cvt_f32_i32  v249, v249                            \n"
"  v_cvt_f32_i32  v250, v250                            \n"
"  v_cvt_f32_i32  v251, v251                            \n"
"  v_mul_f32     v248, v24, v248                        \n"
"  v_mul_f32     v249, v24, v249                        \n"
"  v_mul_f32     v250, v24, v250                        \n"
"  v_mul_f32     v251, v24, v251                        \n"
"  v_mul_f32     v248, v13, v248 row_newbcast:12        \n"
"  v_mul_f32     v249, v13, v249 row_newbcast:13        \n"
"  v_mul_f32     v250, v13, v250 row_newbcast:14        \n"
"  v_mul_f32     v251, v13, v251 row_newbcast:15        \n"
"  v_mul_f32     v248, %[scale_0], v248                        \n"
"  v_mul_f32     v249, %[scale_0], v249                        \n"
"  v_mul_f32     v250, %[scale_0], v250                        \n"
"  v_mul_f32     v251, %[scale_0], v251                        \n"
"  v_cvt_f32_i32  v252, v252                            \n"
"  v_cvt_f32_i32  v253, v253                            \n"
"  v_cvt_f32_i32  v254, v254                            \n"
"  v_cvt_f32_i32  v255, v255                            \n"
"  v_mul_f32     v252, v25, v252                        \n"
"  v_mul_f32     v253, v25, v253                        \n"
"  v_mul_f32     v254, v25, v254                        \n"
"  v_mul_f32     v255, v25, v255                        \n"
"  v_mul_f32     v252, v13, v252 row_newbcast:12        \n"
"  v_mul_f32     v253, v13, v253 row_newbcast:13        \n"
"  v_mul_f32     v254, v13, v254 row_newbcast:14        \n"
"  v_mul_f32     v255, v13, v255 row_newbcast:15        \n"
"  v_mul_f32     v252, %[scale_1], v252                        \n"
"  v_mul_f32     v253, %[scale_1], v253                        \n"
"  v_mul_f32     v254, %[scale_1], v254                        \n"
"  v_mul_f32     v255, %[scale_1], v255                        \n"
"  v_cmp_u_f32   s[48:49], v224, v224                   \n"
"  v_add3_u32    v50, v224, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v225, v225                   \n"
"  v_add3_u32    v50, v225, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v224, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v226, v226                   \n"
"  v_add3_u32    v50, v226, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v227, v227                   \n"
"  v_add3_u32    v50, v227, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v225, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v228, v228                   \n"
"  v_add3_u32    v50, v228, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v229, v229                   \n"
"  v_add3_u32    v50, v229, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v226, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v230, v230                   \n"
"  v_add3_u32    v50, v230, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v231, v231                   \n"
"  v_add3_u32    v50, v231, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v227, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v232, v232                   \n"
"  v_add3_u32    v50, v232, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v233, v233                   \n"
"  v_add3_u32    v50, v233, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v228, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v234, v234                   \n"
"  v_add3_u32    v50, v234, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v235, v235                   \n"
"  v_add3_u32    v50, v235, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v229, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v236, v236                   \n"
"  v_add3_u32    v50, v236, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v237, v237                   \n"
"  v_add3_u32    v50, v237, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v230, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v238, v238                   \n"
"  v_add3_u32    v50, v238, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v239, v239                   \n"
"  v_add3_u32    v50, v239, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v231, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v240, v240                   \n"
"  v_add3_u32    v50, v240, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v241, v241                   \n"
"  v_add3_u32    v50, v241, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v232, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v242, v242                   \n"
"  v_add3_u32    v50, v242, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v243, v243                   \n"
"  v_add3_u32    v50, v243, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v233, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v244, v244                   \n"
"  v_add3_u32    v50, v244, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v245, v245                   \n"
"  v_add3_u32    v50, v245, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v234, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v246, v246                   \n"
"  v_add3_u32    v50, v246, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v247, v247                   \n"
"  v_add3_u32    v50, v247, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v235, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v248, v248                   \n"
"  v_add3_u32    v50, v248, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v249, v249                   \n"
"  v_add3_u32    v50, v249, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v236, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v250, v250                   \n"
"  v_add3_u32    v50, v250, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v251, v251                   \n"
"  v_add3_u32    v50, v251, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v237, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v252, v252                   \n"
"  v_add3_u32    v50, v252, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v253, v253                   \n"
"  v_add3_u32    v50, v253, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v238, v55, v54, s52                    \n"
"  v_cmp_u_f32   s[48:49], v254, v254                   \n"
"  v_add3_u32    v50, v254, v53, 1                      \n"
"  v_cndmask_b32  v54, v50, v52, s[48:49]               \n"
"  v_cmp_u_f32   s[48:49], v255, v255                   \n"
"  v_add3_u32    v50, v255, v53, 1                      \n"
"  v_cndmask_b32  v55, v50, v52, s[48:49]               \n"
"  v_perm_b32    v239, v55, v54, s52                    \n"
"  ds_write_b64  v3, v[224:225] offset:35072            \n"
"  ds_write_b64  v3, v[226:227] offset:43776            \n"
"  ds_write_b64  v3, v[228:229] offset:37248            \n"
"  ds_write_b64  v3, v[230:231] offset:45952            \n"
"  ds_write_b64  v3, v[232:233] offset:39424            \n"
"  ds_write_b64  v3, v[234:235] offset:48128            \n"
"  ds_write_b64  v3, v[236:237] offset:41600            \n"
"  ds_write_b64  v3, v[238:239] offset:50304            \n"
"  s_waitcnt     lgkmcnt(0)                             \n"
"  s_barrier                                            \n"
"  ds_read_b32   v64, v4 offset:35072                   \n"
"  ds_read_b32   v65, v4 offset:39424                   \n"
"  ds_read_b32   v66, v4 offset:35104                   \n"
"  ds_read_b32   v67, v4 offset:39456                   \n"
"  ds_read_b32   v68, v4 offset:35136                   \n"
"  ds_read_b32   v69, v4 offset:39488                   \n"
"  ds_read_b32   v70, v4 offset:35168                   \n"
"  ds_read_b32   v71, v4 offset:39520                   \n"
"  ds_read_b32   v72, v4 offset:43776                   \n"
"  ds_read_b32   v73, v4 offset:48128                   \n"
"  ds_read_b32   v74, v4 offset:43808                   \n"
"  ds_read_b32   v75, v4 offset:48160                   \n"
"  ds_read_b32   v76, v4 offset:43840                   \n"
"  ds_read_b32   v77, v4 offset:48192                   \n"
"  ds_read_b32   v78, v4 offset:43872                   \n"
"  ds_read_b32   v79, v4 offset:48224                   \n"
"  s_waitcnt     lgkmcnt(0)                             \n"
"  s_mov_b64     exec, %[s_execflag_0]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o0], v64, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_0]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o0], v65, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_1]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o1], v66, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_1]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o1], v67, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_2]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o2], v68, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_2]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o2], v69, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_3]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o3], v70, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_3]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o3], v71, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_4]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o4], v72, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_4]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o4], v73, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_5]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o5], v74, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_5]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o5], v75, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_6]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o6], v76, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_6]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o6], v77, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_7]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o7], v78, [%[s_res_o0],%[s_res_o1]] \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_mov_b64     exec, %[s_execflag_7]                         \n"
"  global_atomic_pk_add_bf16   %[v_os_o7], v79, [%[s_res_o0],%[s_res_o1]] inst_offset:256  \n"
"  s_mov_b64     exec, s[36:37]                         \n"
"  s_add_u32     %[s_res_o0], s59, %[s_res_o0]                            \n"
"  s_addc_u32    %[s_res_o1], 0, %[s_res_o1]                              \n"
"  s_addk_i32    s80, 0x0100                            \n"
"  s_cmp_lt_i32  s80, s81                               \n"
"  s_cbranch_scc0   label_end_gemm2           \n"
"  s_branch      label_startgemm2  \n" 
" label_end_gemm2: \n"
"  s_waitcnt     0x0000                                 \n"
"  s_endpgm                                             \n"
#undef _UK_MFMA_
#undef _UK_PK_CVT_
#undef _UK_ATOMIC_ADD_



