#ifndef CK_TILE_FLATMM_UK_MFMA
#define CK_TILE_FLATMM_UK_MFMA CK_TILE_FLATMM_UK_MFMA_INT8
#endif

#if CK_TILE_FLATMM_UK_MFMA == CK_TILE_FLATMM_UK_MFMA_INT8
#   define _UK_MFMA_ "v_mfma_i32_16x16x32_i8"

#   define _UK_PK_CVT_(x0_, x1_, y_)                           \
    "  v_cmp_u_f32   s[36:37], " x0_ ", " x0_ "          \n"   \
    "  v_add3_u32    v50, " x0_ ", %[v_nan_lo], 1        \n"   \
    "  v_cndmask_b32  v54, v50, %[v_nan_hi], s[36:37]    \n"   \
    "  v_cmp_u_f32   s[36:37], " x1_ ", " x1_ "          \n"   \
    "  v_add3_u32    v50, " x1_ ", %[v_nan_lo], 1        \n"   \
    "  v_cndmask_b32  v55, v50, %[v_nan_hi], s[36:37]    \n"   \
    "  v_perm_b32    " y_ ", v55, v54, s52               \n"

#   define _UK_ATOMIC_ADD_ "global_atomic_pk_add_bf16"

#elif CK_TILE_FLATMM_UK_MFMA == CK_TILE_FLATMM_UK_MFMA_FP16
#define _UK_MFMA_ "v_mfma_f32_16x16x16_f16"

#   define _UK_PK_CVT_(x0_, x1_, y_)                \
    "  v_cvt_f16_f32  v54, " x0_ "  \n"             \
    "  v_cvt_f16_f32  v55, " x1_ "  \n"             \
    "  v_pack_b32_f16 " y_ ", v54, v55  \n"

#   define _UK_ATOMIC_ADD_ "global_atomic_pk_add_f16"

#endif
" v_and_b32        v0,   0x3f,  v0             \n"
" v_lshrrev_b32    v3,    6,   v0             \n"
" v_readfirstlane_b32   s7,   v3              \n"
"  s_waitcnt     vmcnt(24)                              \n"
"  buffer_load_dwordx4  acc[0:3], %[v_os_b0], s[12:15], 0 offen\n"
"  buffer_load_dwordx4  acc[4:7], %[v_os_b0], s[12:15], 0 offen offset:1024\n"
"  v_mul_f32     v54, v128, v128                        \n"
"  v_mul_f32     v55, v129, v129                        \n"
"  v_mul_f32     v56, v130, v130                        \n"
"  v_mul_f32     v57, v131, v131                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v128                         \n"
"  v_mul_f32     v55, v55, v129                         \n"
"  v_mul_f32     v56, v56, v130                         \n"
"  v_mul_f32     v57, v57, v131                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v128, v128, v54                        \n"
"  v_mul_f32     v129, v129, v55                        \n"
"  v_mul_f32     v130, v130, v56                        \n"
"  v_mul_f32     v131, v131, v57                        \n"
"  buffer_load_dwordx4  acc[8:11], %[v_os_b0], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v132, v132                        \n"
"  v_mul_f32     v55, v133, v133                        \n"
"  v_mul_f32     v56, v134, v134                        \n"
"  v_mul_f32     v57, v135, v135                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v132                         \n"
"  v_mul_f32     v55, v55, v133                         \n"
"  v_mul_f32     v56, v56, v134                         \n"
"  v_mul_f32     v57, v57, v135                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[12:15], %[v_os_b0], s[12:15], 0 offen offset:3072\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v132, v132, v54                        \n"
"  v_mul_f32     v133, v133, v55                        \n"
"  v_mul_f32     v134, v134, v56                        \n"
"  v_mul_f32     v135, v135, v57                        \n"
"  buffer_load_dwordx4  acc[16:19], %[v_os_b1], s[12:15], 0 offen\n"
"  v_mul_f32     v54, v136, v136                        \n"
"  v_mul_f32     v55, v137, v137                        \n"
"  v_mul_f32     v56, v138, v138                        \n"
"  v_mul_f32     v57, v139, v139                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v136                         \n"
"  v_mul_f32     v55, v55, v137                         \n"
"  v_mul_f32     v56, v56, v138                         \n"
"  v_mul_f32     v57, v57, v139                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[20:23], %[v_os_b1], s[12:15], 0 offen offset:1024\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v136, v136, v54                        \n"
"  v_mul_f32     v137, v137, v55                        \n"
"  v_mul_f32     v138, v138, v56                        \n"
"  v_mul_f32     v139, v139, v57                        \n"
"  buffer_load_dwordx4  acc[24:27], %[v_os_b1], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v140, v140                        \n"
"  v_mul_f32     v55, v141, v141                        \n"
"  v_mul_f32     v56, v142, v142                        \n"
"  v_mul_f32     v57, v143, v143                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v140                         \n"
"  v_mul_f32     v55, v55, v141                         \n"
"  v_mul_f32     v56, v56, v142                         \n"
"  v_mul_f32     v57, v57, v143                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[28:31], %[v_os_b1], s[12:15], 0 offen offset:3072\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v140, v140, v54                        \n"
"  v_mul_f32     v141, v141, v55                        \n"
"  v_mul_f32     v142, v142, v56                        \n"
"  v_mul_f32     v143, v143, v57                        \n"
"  s_waitcnt     vmcnt(24)                              \n"
"  buffer_load_dwordx4  acc[32:35], %[v_os_b2], s[12:15], 0 offen\n"
"  v_mul_f32     v54, v144, v144                        \n"
"  v_mul_f32     v55, v145, v145                        \n"
"  v_mul_f32     v56, v146, v146                        \n"
"  v_mul_f32     v57, v147, v147                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v144                         \n"
"  v_mul_f32     v55, v55, v145                         \n"
"  v_mul_f32     v56, v56, v146                         \n"
"  v_mul_f32     v57, v57, v147                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[36:39], %[v_os_b2], s[12:15], 0 offen offset:1024\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v144, v144, v54                        \n"
"  v_mul_f32     v145, v145, v55                        \n"
"  v_mul_f32     v146, v146, v56                        \n"
"  v_mul_f32     v147, v147, v57                        \n"
"  buffer_load_dwordx4  acc[40:43], %[v_os_b2], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v148, v148                        \n"
"  v_mul_f32     v55, v149, v149                        \n"
"  v_mul_f32     v56, v150, v150                        \n"
"  v_mul_f32     v57, v151, v151                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v148                         \n"
"  v_mul_f32     v55, v55, v149                         \n"
"  v_mul_f32     v56, v56, v150                         \n"
"  v_mul_f32     v57, v57, v151                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[44:47], %[v_os_b2], s[12:15], 0 offen offset:3072\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v148, v148, v54                        \n"
"  v_mul_f32     v149, v149, v55                        \n"
"  v_mul_f32     v150, v150, v56                        \n"
"  v_mul_f32     v151, v151, v57                        \n"
"  buffer_load_dwordx4  acc[48:51], %[v_os_b3], s[12:15], 0 offen\n"
"  v_mul_f32     v54, v152, v152                        \n"
"  v_mul_f32     v55, v153, v153                        \n"
"  v_mul_f32     v56, v154, v154                        \n"
"  v_mul_f32     v57, v155, v155                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v152                         \n"
"  v_mul_f32     v55, v55, v153                         \n"
"  v_mul_f32     v56, v56, v154                         \n"
"  v_mul_f32     v57, v57, v155                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[52:55], %[v_os_b3], s[12:15], 0 offen offset:1024\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v152, v152, v54                        \n"
"  v_mul_f32     v153, v153, v55                        \n"
"  v_mul_f32     v154, v154, v56                        \n"
"  v_mul_f32     v155, v155, v57                        \n"
"  buffer_load_dwordx4  acc[56:59], %[v_os_b3], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v156, v156                        \n"
"  v_mul_f32     v55, v157, v157                        \n"
"  v_mul_f32     v56, v158, v158                        \n"
"  v_mul_f32     v57, v159, v159                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v156                         \n"
"  v_mul_f32     v55, v55, v157                         \n"
"  v_mul_f32     v56, v56, v158                         \n"
"  v_mul_f32     v57, v57, v159                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[60:63], %[v_os_b3], s[12:15], 0 offen offset:3072\n"
"  s_add_u32     s12, %[s_tile_os_b_half], s12                          \n"
"  s_addc_u32    s13, 0, s13                            \n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v156, v156, v54                        \n"
"  v_mul_f32     v157, v157, v55                        \n"
"  v_mul_f32     v158, v158, v56                        \n"
"  v_mul_f32     v159, v159, v57                        \n"
"  s_waitcnt     vmcnt(24)                              \n"
"  buffer_load_dwordx4  acc[64:67], %[v_os_b0], s[12:15], 0 offen\n"
"  v_mul_f32     v54, v160, v160                        \n"
"  v_mul_f32     v55, v161, v161                        \n"
"  v_mul_f32     v56, v162, v162                        \n"
"  v_mul_f32     v57, v163, v163                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v160                         \n"
"  v_mul_f32     v55, v55, v161                         \n"
"  v_mul_f32     v56, v56, v162                         \n"
"  v_mul_f32     v57, v57, v163                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[68:71], %[v_os_b0], s[12:15], 0 offen offset:1024\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v160, v160, v54                        \n"
"  v_mul_f32     v161, v161, v55                        \n"
"  v_mul_f32     v162, v162, v56                        \n"
"  v_mul_f32     v163, v163, v57                        \n"
"  buffer_load_dwordx4  acc[72:75], %[v_os_b0], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v164, v164                        \n"
"  v_mul_f32     v55, v165, v165                        \n"
"  v_mul_f32     v56, v166, v166                        \n"
"  v_mul_f32     v57, v167, v167                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v164                         \n"
"  v_mul_f32     v55, v55, v165                         \n"
"  v_mul_f32     v56, v56, v166                         \n"
"  v_mul_f32     v57, v57, v167                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[76:79], %[v_os_b0], s[12:15], 0 offen offset:3072\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v164, v164, v54                        \n"
"  v_mul_f32     v165, v165, v55                        \n"
"  v_mul_f32     v166, v166, v56                        \n"
"  v_mul_f32     v167, v167, v57                        \n"
"  buffer_load_dwordx4  acc[80:83], %[v_os_b1], s[12:15], 0 offen\n"
"  v_mul_f32     v54, v168, v168                        \n"
"  v_mul_f32     v55, v169, v169                        \n"
"  v_mul_f32     v56, v170, v170                        \n"
"  v_mul_f32     v57, v171, v171                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v168                         \n"
"  v_mul_f32     v55, v55, v169                         \n"
"  v_mul_f32     v56, v56, v170                         \n"
"  v_mul_f32     v57, v57, v171                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[84:87], %[v_os_b1], s[12:15], 0 offen offset:1024\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v168, v168, v54                        \n"
"  v_mul_f32     v169, v169, v55                        \n"
"  v_mul_f32     v170, v170, v56                        \n"
"  v_mul_f32     v171, v171, v57                        \n"
"  buffer_load_dwordx4  acc[88:91], %[v_os_b1], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v172, v172                        \n"
"  v_mul_f32     v55, v173, v173                        \n"
"  v_mul_f32     v56, v174, v174                        \n"
"  v_mul_f32     v57, v175, v175                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v172                         \n"
"  v_mul_f32     v55, v55, v173                         \n"
"  v_mul_f32     v56, v56, v174                         \n"
"  v_mul_f32     v57, v57, v175                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[92:95], %[v_os_b1], s[12:15], 0 offen offset:3072\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v172, v172, v54                        \n"
"  v_mul_f32     v173, v173, v55                        \n"
"  v_mul_f32     v174, v174, v56                        \n"
"  v_mul_f32     v175, v175, v57                        \n"
"  s_waitcnt     vmcnt(24)                              \n"
"  buffer_load_dwordx4  acc[96:99], %[v_os_b2], s[12:15], 0 offen\n"
"  v_mul_f32     v54, v176, v176                        \n"
"  v_mul_f32     v55, v177, v177                        \n"
"  v_mul_f32     v56, v178, v178                        \n"
"  v_mul_f32     v57, v179, v179                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v176                         \n"
"  v_mul_f32     v55, v55, v177                         \n"
"  v_mul_f32     v56, v56, v178                         \n"
"  v_mul_f32     v57, v57, v179                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[100:103], %[v_os_b2], s[12:15], 0 offen offset:1024\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v176, v176, v54                        \n"
"  v_mul_f32     v177, v177, v55                        \n"
"  v_mul_f32     v178, v178, v56                        \n"
"  v_mul_f32     v179, v179, v57                        \n"
"  buffer_load_dwordx4  acc[104:107], %[v_os_b2], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v180, v180                        \n"
"  v_mul_f32     v55, v181, v181                        \n"
"  v_mul_f32     v56, v182, v182                        \n"
"  v_mul_f32     v57, v183, v183                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v180                         \n"
"  v_mul_f32     v55, v55, v181                         \n"
"  v_mul_f32     v56, v56, v182                         \n"
"  v_mul_f32     v57, v57, v183                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[108:111], %[v_os_b2], s[12:15], 0 offen offset:3072\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v180, v180, v54                        \n"
"  v_mul_f32     v181, v181, v55                        \n"
"  v_mul_f32     v182, v182, v56                        \n"
"  v_mul_f32     v183, v183, v57                        \n"
"  buffer_load_dwordx4  acc[112:115], %[v_os_b3], s[12:15], 0 offen\n"
"  v_mul_f32     v54, v184, v184                        \n"
"  v_mul_f32     v55, v185, v185                        \n"
"  v_mul_f32     v56, v186, v186                        \n"
"  v_mul_f32     v57, v187, v187                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v184                         \n"
"  v_mul_f32     v55, v55, v185                         \n"
"  v_mul_f32     v56, v56, v186                         \n"
"  v_mul_f32     v57, v57, v187                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[116:119], %[v_os_b3], s[12:15], 0 offen offset:1024\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v184, v184, v54                        \n"
"  v_mul_f32     v185, v185, v55                        \n"
"  v_mul_f32     v186, v186, v56                        \n"
"  v_mul_f32     v187, v187, v57                        \n"
"  buffer_load_dwordx4  acc[120:123], %[v_os_b3], s[12:15], 0 offen offset:2048\n"
"  v_mul_f32     v54, v188, v188                        \n"
"  v_mul_f32     v55, v189, v189                        \n"
"  v_mul_f32     v56, v190, v190                        \n"
"  v_mul_f32     v57, v191, v191                        \n"
"  v_fma_f32     v54, v54, s77, v1                      \n"
"  v_fma_f32     v55, v55, s77, v1                      \n"
"  v_fma_f32     v56, v56, s77, v1                      \n"
"  v_fma_f32     v57, v57, s77, v1                      \n"
"  v_mul_f32     v54, v54, v188                         \n"
"  v_mul_f32     v55, v55, v189                         \n"
"  v_mul_f32     v56, v56, v190                         \n"
"  v_mul_f32     v57, v57, v191                         \n"
"  v_mul_f32     v54, v54, s6                           \n"
"  v_mul_f32     v55, v55, s6                           \n"
"  v_mul_f32     v56, v56, s6                           \n"
"  v_mul_f32     v57, v57, s6                           \n"
"  v_exp_f32     v54, v54                               \n"
"  v_exp_f32     v55, v55                               \n"
"  v_exp_f32     v56, v56                               \n"
"  v_exp_f32     v57, v57                               \n"
"  buffer_load_dwordx4  acc[124:127], %[v_os_b3], s[12:15], 0 offen offset:3072\n"
"  v_add_f32     v54, v54, 1.0                          \n"
"  v_add_f32     v55, v55, 1.0                          \n"
"  v_add_f32     v56, v56, 1.0                          \n"
"  v_add_f32     v57, v57, 1.0                          \n"
"  v_rcp_f32     v54, v54                               \n"
"  v_rcp_f32     v55, v55                               \n"
"  v_rcp_f32     v56, v56                               \n"
"  v_rcp_f32     v57, v57                               \n"
"  v_mul_f32     v188, v188, v54                        \n"
"  v_mul_f32     v189, v189, v55                        \n"
"  v_mul_f32     v190, v190, v56                        \n"
"  v_mul_f32     v191, v191, v57                        \n"
"  v_mul_f32     v128, %[smq_scale0], v128 row_newbcast:0         \n"
"  v_mul_f32     v129, %[smq_scale0], v129 row_newbcast:1         \n"
"  v_mul_f32     v130, %[smq_scale0], v130 row_newbcast:2         \n"
"  v_mul_f32     v131, %[smq_scale0], v131 row_newbcast:3         \n"
"  v_mul_f32     v132, %[smq_scale0], v132 row_newbcast:0         \n"
"  v_mul_f32     v133, %[smq_scale0], v133 row_newbcast:1         \n"
"  v_mul_f32     v134, %[smq_scale0], v134 row_newbcast:2         \n"
"  v_mul_f32     v135, %[smq_scale0], v135 row_newbcast:3         \n"
"  v_mul_f32     v136, %[smq_scale0], v136 row_newbcast:4         \n"
"  v_mul_f32     v137, %[smq_scale0], v137 row_newbcast:5         \n"
"  v_mul_f32     v138, %[smq_scale0], v138 row_newbcast:6         \n"
"  v_mul_f32     v139, %[smq_scale0], v139 row_newbcast:7         \n"
"  v_mul_f32     v140, %[smq_scale0], v140 row_newbcast:4         \n"
"  v_mul_f32     v141, %[smq_scale0], v141 row_newbcast:5         \n"
"  v_mul_f32     v142, %[smq_scale0], v142 row_newbcast:6         \n"
"  v_mul_f32     v143, %[smq_scale0], v143 row_newbcast:7         \n"
"  v_mul_f32     v144, %[smq_scale0], v144 row_newbcast:8         \n"
"  v_mul_f32     v145, %[smq_scale0], v145 row_newbcast:9         \n"
"  v_mul_f32     v146, %[smq_scale0], v146 row_newbcast:10        \n"
"  v_mul_f32     v147, %[smq_scale0], v147 row_newbcast:11        \n"
"  v_mul_f32     v148, %[smq_scale0], v148 row_newbcast:8         \n"
"  v_mul_f32     v149, %[smq_scale0], v149 row_newbcast:9         \n"
"  v_mul_f32     v150, %[smq_scale0], v150 row_newbcast:10        \n"
"  v_mul_f32     v151, %[smq_scale0], v151 row_newbcast:11        \n"
"  v_mul_f32     v152, %[smq_scale0], v152 row_newbcast:12        \n"
"  v_mul_f32     v153, %[smq_scale0], v153 row_newbcast:13        \n"
"  v_mul_f32     v154, %[smq_scale0], v154 row_newbcast:14        \n"
"  v_mul_f32     v155, %[smq_scale0], v155 row_newbcast:15        \n"
"  v_mul_f32     v156, %[smq_scale0], v156 row_newbcast:12        \n"
"  v_mul_f32     v157, %[smq_scale0], v157 row_newbcast:13        \n"
"  v_mul_f32     v158, %[smq_scale0], v158 row_newbcast:14        \n"
"  v_mul_f32     v159, %[smq_scale0], v159 row_newbcast:15        \n"
"  v_mul_f32     v160, %[smq_scale1], v160 row_newbcast:0         \n"
"  v_mul_f32     v161, %[smq_scale1], v161 row_newbcast:1         \n"
"  v_mul_f32     v162, %[smq_scale1], v162 row_newbcast:2         \n"
"  v_mul_f32     v163, %[smq_scale1], v163 row_newbcast:3         \n"
"  v_mul_f32     v164, %[smq_scale1], v164 row_newbcast:0         \n"
"  v_mul_f32     v165, %[smq_scale1], v165 row_newbcast:1         \n"
"  v_mul_f32     v166, %[smq_scale1], v166 row_newbcast:2         \n"
"  v_mul_f32     v167, %[smq_scale1], v167 row_newbcast:3         \n"
"  v_mul_f32     v168, %[smq_scale1], v168 row_newbcast:4         \n"
"  v_mul_f32     v169, %[smq_scale1], v169 row_newbcast:5         \n"
"  v_mul_f32     v170, %[smq_scale1], v170 row_newbcast:6         \n"
"  v_mul_f32     v171, %[smq_scale1], v171 row_newbcast:7         \n"
"  v_mul_f32     v172, %[smq_scale1], v172 row_newbcast:4         \n"
"  v_mul_f32     v173, %[smq_scale1], v173 row_newbcast:5         \n"
"  v_mul_f32     v174, %[smq_scale1], v174 row_newbcast:6         \n"
"  v_mul_f32     v175, %[smq_scale1], v175 row_newbcast:7         \n"
"  v_mul_f32     v176, %[smq_scale1], v176 row_newbcast:8         \n"
"  v_mul_f32     v177, %[smq_scale1], v177 row_newbcast:9         \n"
"  v_mul_f32     v178, %[smq_scale1], v178 row_newbcast:10        \n"
"  v_mul_f32     v179, %[smq_scale1], v179 row_newbcast:11        \n"
"  v_mul_f32     v180, %[smq_scale1], v180 row_newbcast:8         \n"
"  v_mul_f32     v181, %[smq_scale1], v181 row_newbcast:9         \n"
"  v_mul_f32     v182, %[smq_scale1], v182 row_newbcast:10        \n"
"  v_mul_f32     v183, %[smq_scale1], v183 row_newbcast:11        \n"
"  v_mul_f32     v184, %[smq_scale1], v184 row_newbcast:12        \n"
"  v_mul_f32     v185, %[smq_scale1], v185 row_newbcast:13        \n"
"  v_mul_f32     v186, %[smq_scale1], v186 row_newbcast:14        \n"
"  v_mul_f32     v187, %[smq_scale1], v187 row_newbcast:15        \n"
"  v_mul_f32     v188, %[smq_scale1], v188 row_newbcast:12        \n"
"  v_mul_f32     v189, %[smq_scale1], v189 row_newbcast:13        \n"
"  v_mul_f32     v190, %[smq_scale1], v190 row_newbcast:14        \n"
"  v_mul_f32     v191, %[smq_scale1], v191 row_newbcast:15        \n"
"  buffer_load_dword  v12, %[v_os_dq], s[16:19], 0 offen        \n"
"  v_mov_b32     v22, 0x358637bd                        \n"
"  v_mov_b32     v23, 0x358637bd                        \n"
"  v_max3_f32    v22, abs(v128), abs(v129), v22         \n"
"  v_max3_f32    v22, abs(v130), abs(v131), v22         \n"
"  v_max3_f32    v23, abs(v132), abs(v133), v23         \n"
"  v_max3_f32    v23, abs(v134), abs(v135), v23         \n"
"  v_max3_f32    v22, abs(v136), abs(v137), v22         \n"
"  v_max3_f32    v22, abs(v138), abs(v139), v22         \n"
"  v_max3_f32    v23, abs(v140), abs(v141), v23         \n"
"  v_max3_f32    v23, abs(v142), abs(v143), v23         \n"
"  v_max3_f32    v22, abs(v144), abs(v145), v22         \n"
"  v_max3_f32    v22, abs(v146), abs(v147), v22         \n"
"  v_max3_f32    v23, abs(v148), abs(v149), v23         \n"
"  v_max3_f32    v23, abs(v150), abs(v151), v23         \n"
"  v_max3_f32    v22, abs(v152), abs(v153), v22         \n"
"  v_max3_f32    v22, abs(v154), abs(v155), v22         \n"
"  v_max3_f32    v23, abs(v156), abs(v157), v23         \n"
"  v_max3_f32    v23, abs(v158), abs(v159), v23         \n"
"  v_max3_f32    v22, abs(v160), abs(v161), v22         \n"
"  v_max3_f32    v22, abs(v162), abs(v163), v22         \n"
"  v_max3_f32    v23, abs(v164), abs(v165), v23         \n"
"  v_max3_f32    v23, abs(v166), abs(v167), v23         \n"
"  v_max3_f32    v22, abs(v168), abs(v169), v22         \n"
"  v_max3_f32    v22, abs(v170), abs(v171), v22         \n"
"  v_max3_f32    v23, abs(v172), abs(v173), v23         \n"
"  v_max3_f32    v23, abs(v174), abs(v175), v23         \n"
"  v_max3_f32    v22, abs(v176), abs(v177), v22         \n"
"  v_max3_f32    v22, abs(v178), abs(v179), v22         \n"
"  v_max3_f32    v23, abs(v180), abs(v181), v23         \n"
"  v_max3_f32    v23, abs(v182), abs(v183), v23         \n"
"  v_max3_f32    v22, abs(v184), abs(v185), v22         \n"
"  v_max3_f32    v22, abs(v186), abs(v187), v22         \n"
"  v_max3_f32    v23, abs(v188), abs(v189), v23         \n"
"  v_max3_f32    v23, abs(v190), abs(v191), v23         \n"
"  v_lshlrev_b32  v54, 3, v0                            \n"
"  s_mul_i32     s60, 0x00000200, s7                    \n"
"  v_add_u32     v54, s60, v54                          \n"
"  ds_write_b64  v54, v[22:23] offset:16640             \n"
"  s_waitcnt     lgkmcnt(0)                             \n"
"  s_barrier                                            \n"
"  v_and_b32     v54, 15, v0                            \n"
"  v_lshlrev_b32  v54, 3, v54                           \n"
"  ds_read_b64   v[96:97], v54 offset:16640             \n"
"  ds_read_b64   v[98:99], v54 offset:16768             \n"
"  ds_read_b64   v[100:101], v54 offset:16896           \n"
"  ds_read_b64   v[102:103], v54 offset:17024           \n"
"  ds_read_b64   v[104:105], v54 offset:17152           \n"
"  ds_read_b64   v[106:107], v54 offset:17280           \n"
"  ds_read_b64   v[108:109], v54 offset:17408           \n"
"  ds_read_b64   v[110:111], v54 offset:17536           \n"
"  ds_read_b64   v[112:113], v54 offset:17664           \n"
"  ds_read_b64   v[114:115], v54 offset:17792           \n"
"  ds_read_b64   v[116:117], v54 offset:17920           \n"
"  ds_read_b64   v[118:119], v54 offset:18048           \n"
"  ds_read_b64   v[120:121], v54 offset:18176           \n"
"  ds_read_b64   v[122:123], v54 offset:18304           \n"
"  ds_read_b64   v[124:125], v54 offset:18432           \n"
"  ds_read_b64   v[126:127], v54 offset:18560           \n"
"  s_waitcnt     lgkmcnt(0)                             \n"
"  v_max3_f32    v22, abs(v96), abs(v98), v22           \n"
"  v_max3_f32    v23, abs(v97), abs(v99), v23           \n"
"  v_max3_f32    v22, abs(v100), abs(v102), v22         \n"
"  v_max3_f32    v23, abs(v101), abs(v103), v23         \n"
"  v_max3_f32    v22, abs(v104), abs(v106), v22         \n"
"  v_max3_f32    v23, abs(v105), abs(v107), v23         \n"
"  v_max3_f32    v22, abs(v108), abs(v110), v22         \n"
"  v_max3_f32    v23, abs(v109), abs(v111), v23         \n"
"  v_max3_f32    v22, abs(v112), abs(v114), v22         \n"
"  v_max3_f32    v23, abs(v113), abs(v115), v23         \n"
"  v_max3_f32    v22, abs(v116), abs(v118), v22         \n"
"  v_max3_f32    v23, abs(v117), abs(v119), v23         \n"
"  v_max3_f32    v22, abs(v120), abs(v122), v22         \n"
"  v_max3_f32    v23, abs(v121), abs(v123), v23         \n"
"  v_max3_f32    v22, abs(v124), abs(v126), v22         \n"
"  v_max3_f32    v23, abs(v125), abs(v127), v23         \n"
"  v_rcp_f32     v22, v22                               \n"
"  v_rcp_f32     v23, v23                               \n"
"  v_mul_f32     v22, 0x42fe0000, v22                   \n"
"  v_mul_f32     v23, 0x42fe0000, v23                   \n"
"  v_mul_f32     v128, v22, v128                        \n"
"  v_mul_f32     v129, v22, v129                        \n"
"  v_mul_f32     v130, v22, v130                        \n"
"  v_mul_f32     v131, v22, v131                        \n"
"  v_cvt_i32_f32  v128, v128                            \n"
"  v_cvt_i32_f32  v129, v129                            \n"
"  v_cvt_i32_f32  v130, v130                            \n"
"  v_cvt_i32_f32  v131, v131                            \n"
"  v_perm_b32    v128, v129, v128, s53                  \n"
"  v_perm_b32    v128, v130, v128, s54                  \n"
"  v_perm_b32    v128, v131, v128, s55                  \n"
"  v_mul_f32     v132, v23, v132                        \n"
"  v_mul_f32     v133, v23, v133                        \n"
"  v_mul_f32     v134, v23, v134                        \n"
"  v_mul_f32     v135, v23, v135                        \n"
"  v_cvt_i32_f32  v132, v132                            \n"
"  v_cvt_i32_f32  v133, v133                            \n"
"  v_cvt_i32_f32  v134, v134                            \n"
"  v_cvt_i32_f32  v135, v135                            \n"
"  v_perm_b32    v129, v133, v132, s53                  \n"
"  v_perm_b32    v129, v134, v129, s54                  \n"
"  v_perm_b32    v129, v135, v129, s55                  \n"
"  v_mul_f32     v136, v22, v136                        \n"
"  v_mul_f32     v137, v22, v137                        \n"
"  v_mul_f32     v138, v22, v138                        \n"
"  v_mul_f32     v139, v22, v139                        \n"
"  v_cvt_i32_f32  v136, v136                            \n"
"  v_cvt_i32_f32  v137, v137                            \n"
"  v_cvt_i32_f32  v138, v138                            \n"
"  v_cvt_i32_f32  v139, v139                            \n"
"  v_perm_b32    v130, v137, v136, s53                  \n"
"  v_perm_b32    v130, v138, v130, s54                  \n"
"  v_perm_b32    v130, v139, v130, s55                  \n"
"  v_mul_f32     v140, v23, v140                        \n"
"  v_mul_f32     v141, v23, v141                        \n"
"  v_mul_f32     v142, v23, v142                        \n"
"  v_mul_f32     v143, v23, v143                        \n"
"  v_cvt_i32_f32  v140, v140                            \n"
"  v_cvt_i32_f32  v141, v141                            \n"
"  v_cvt_i32_f32  v142, v142                            \n"
"  v_cvt_i32_f32  v143, v143                            \n"
"  v_perm_b32    v131, v141, v140, s53                  \n"
"  v_perm_b32    v131, v142, v131, s54                  \n"
"  v_perm_b32    v131, v143, v131, s55                  \n"
"  v_mul_f32     v144, v22, v144                        \n"
"  v_mul_f32     v145, v22, v145                        \n"
"  v_mul_f32     v146, v22, v146                        \n"
"  v_mul_f32     v147, v22, v147                        \n"
"  v_cvt_i32_f32  v144, v144                            \n"
"  v_cvt_i32_f32  v145, v145                            \n"
"  v_cvt_i32_f32  v146, v146                            \n"
"  v_cvt_i32_f32  v147, v147                            \n"
"  v_perm_b32    v132, v145, v144, s53                  \n"
"  v_perm_b32    v132, v146, v132, s54                  \n"
"  v_perm_b32    v132, v147, v132, s55                  \n"
"  v_mul_f32     v148, v23, v148                        \n"
"  v_mul_f32     v149, v23, v149                        \n"
"  v_mul_f32     v150, v23, v150                        \n"
"  v_mul_f32     v151, v23, v151                        \n"
"  v_cvt_i32_f32  v148, v148                            \n"
"  v_cvt_i32_f32  v149, v149                            \n"
"  v_cvt_i32_f32  v150, v150                            \n"
"  v_cvt_i32_f32  v151, v151                            \n"
"  v_perm_b32    v133, v149, v148, s53                  \n"
"  v_perm_b32    v133, v150, v133, s54                  \n"
"  v_perm_b32    v133, v151, v133, s55                  \n"
"  v_mul_f32     v152, v22, v152                        \n"
"  v_mul_f32     v153, v22, v153                        \n"
"  v_mul_f32     v154, v22, v154                        \n"
"  v_mul_f32     v155, v22, v155                        \n"
"  v_cvt_i32_f32  v152, v152                            \n"
"  v_cvt_i32_f32  v153, v153                            \n"
"  v_cvt_i32_f32  v154, v154                            \n"
"  v_cvt_i32_f32  v155, v155                            \n"
"  v_perm_b32    v134, v153, v152, s53                  \n"
"  v_perm_b32    v134, v154, v134, s54                  \n"
"  v_perm_b32    v134, v155, v134, s55                  \n"
"  v_mul_f32     v156, v23, v156                        \n"
"  v_mul_f32     v157, v23, v157                        \n"
"  v_mul_f32     v158, v23, v158                        \n"
"  v_mul_f32     v159, v23, v159                        \n"
"  v_cvt_i32_f32  v156, v156                            \n"
"  v_cvt_i32_f32  v157, v157                            \n"
"  v_cvt_i32_f32  v158, v158                            \n"
"  v_cvt_i32_f32  v159, v159                            \n"
"  v_perm_b32    v135, v157, v156, s53                  \n"
"  v_perm_b32    v135, v158, v135, s54                  \n"
"  v_perm_b32    v135, v159, v135, s55                  \n"
"  v_mul_f32     v160, v22, v160                        \n"
"  v_mul_f32     v161, v22, v161                        \n"
"  v_mul_f32     v162, v22, v162                        \n"
"  v_mul_f32     v163, v22, v163                        \n"
"  v_cvt_i32_f32  v160, v160                            \n"
"  v_cvt_i32_f32  v161, v161                            \n"
"  v_cvt_i32_f32  v162, v162                            \n"
"  v_cvt_i32_f32  v163, v163                            \n"
"  v_perm_b32    v136, v161, v160, s53                  \n"
"  v_perm_b32    v136, v162, v136, s54                  \n"
"  v_perm_b32    v136, v163, v136, s55                  \n"
"  v_mul_f32     v164, v23, v164                        \n"
"  v_mul_f32     v165, v23, v165                        \n"
"  v_mul_f32     v166, v23, v166                        \n"
"  v_mul_f32     v167, v23, v167                        \n"
"  v_cvt_i32_f32  v164, v164                            \n"
"  v_cvt_i32_f32  v165, v165                            \n"
"  v_cvt_i32_f32  v166, v166                            \n"
"  v_cvt_i32_f32  v167, v167                            \n"
"  v_perm_b32    v137, v165, v164, s53                  \n"
"  v_perm_b32    v137, v166, v137, s54                  \n"
"  v_perm_b32    v137, v167, v137, s55                  \n"
"  v_mul_f32     v168, v22, v168                        \n"
"  v_mul_f32     v169, v22, v169                        \n"
"  v_mul_f32     v170, v22, v170                        \n"
"  v_mul_f32     v171, v22, v171                        \n"
"  v_cvt_i32_f32  v168, v168                            \n"
"  v_cvt_i32_f32  v169, v169                            \n"
"  v_cvt_i32_f32  v170, v170                            \n"
"  v_cvt_i32_f32  v171, v171                            \n"
"  v_perm_b32    v138, v169, v168, s53                  \n"
"  v_perm_b32    v138, v170, v138, s54                  \n"
"  v_perm_b32    v138, v171, v138, s55                  \n"
"  v_mul_f32     v172, v23, v172                        \n"
"  v_mul_f32     v173, v23, v173                        \n"
"  v_mul_f32     v174, v23, v174                        \n"
"  v_mul_f32     v175, v23, v175                        \n"
"  v_cvt_i32_f32  v172, v172                            \n"
"  v_cvt_i32_f32  v173, v173                            \n"
"  v_cvt_i32_f32  v174, v174                            \n"
"  v_cvt_i32_f32  v175, v175                            \n"
"  v_perm_b32    v139, v173, v172, s53                  \n"
"  v_perm_b32    v139, v174, v139, s54                  \n"
"  v_perm_b32    v139, v175, v139, s55                  \n"
"  v_mul_f32     v176, v22, v176                        \n"
"  v_mul_f32     v177, v22, v177                        \n"
"  v_mul_f32     v178, v22, v178                        \n"
"  v_mul_f32     v179, v22, v179                        \n"
"  v_cvt_i32_f32  v176, v176                            \n"
"  v_cvt_i32_f32  v177, v177                            \n"
"  v_cvt_i32_f32  v178, v178                            \n"
"  v_cvt_i32_f32  v179, v179                            \n"
"  v_perm_b32    v140, v177, v176, s53                  \n"
"  v_perm_b32    v140, v178, v140, s54                  \n"
"  v_perm_b32    v140, v179, v140, s55                  \n"
"  v_mul_f32     v180, v23, v180                        \n"
"  v_mul_f32     v181, v23, v181                        \n"
"  v_mul_f32     v182, v23, v182                        \n"
"  v_mul_f32     v183, v23, v183                        \n"
"  v_cvt_i32_f32  v180, v180                            \n"
"  v_cvt_i32_f32  v181, v181                            \n"
"  v_cvt_i32_f32  v182, v182                            \n"
"  v_cvt_i32_f32  v183, v183                            \n"
"  v_perm_b32    v141, v181, v180, s53                  \n"
"  v_perm_b32    v141, v182, v141, s54                  \n"
"  v_perm_b32    v141, v183, v141, s55                  \n"
"  v_mul_f32     v184, v22, v184                        \n"
"  v_mul_f32     v185, v22, v185                        \n"
"  v_mul_f32     v186, v22, v186                        \n"
"  v_mul_f32     v187, v22, v187                        \n"
"  v_cvt_i32_f32  v184, v184                            \n"
"  v_cvt_i32_f32  v185, v185                            \n"
"  v_cvt_i32_f32  v186, v186                            \n"
"  v_cvt_i32_f32  v187, v187                            \n"
"  v_perm_b32    v142, v185, v184, s53                  \n"
"  v_perm_b32    v142, v186, v142, s54                  \n"
"  v_perm_b32    v142, v187, v142, s55                  \n"
"  v_mul_f32     v188, v23, v188                        \n"
"  v_mul_f32     v189, v23, v189                        \n"
"  v_mul_f32     v190, v23, v190                        \n"
"  v_mul_f32     v191, v23, v191                        \n"
"  v_cvt_i32_f32  v188, v188                            \n"
"  v_cvt_i32_f32  v189, v189                            \n"
"  v_cvt_i32_f32  v190, v190                            \n"
"  v_cvt_i32_f32  v191, v191                            \n"
"  v_perm_b32    v143, v189, v188, s53                  \n"
"  v_perm_b32    v143, v190, v143, s54                  \n"
"  v_perm_b32    v143, v191, v143, s55                  \n"
"  v_rcp_f32     v24, v22                               \n"
"  v_rcp_f32     v25, v23                               \n"
"  v_lshrrev_b32  v54, 5, v0                            \n"
"  v_lshlrev_b32  v55, 5, v54                           \n"
"  v_and_b32     v54, 31, v0                            \n"
"  v_lshrrev_b32  v56, 4, v54                           \n"
"  v_add_u32     v55, v56, v55                          \n"
"  v_and_b32     v54, 15, v0                            \n"
"  v_lshlrev_b32  v54, 1, v54                           \n"
"  v_add_u32     v55, v54, v55                          \n"
"  v_lshlrev_b32  v54, 2, v55                           \n"
"  s_mul_i32     s60, 0x00000100, s7                    \n"
"  v_add_u32     v54, v54, s60                          \n"
"  ds_write_b32  v54, v128 offset:18688                 \n"
"  ds_write_b32  v54, v129 offset:26880                 \n"
"  ds_write_b32  v54, v130 offset:19712                 \n"
"  ds_write_b32  v54, v131 offset:27904                 \n"
"  ds_write_b32  v54, v132 offset:20736                 \n"
"  ds_write_b32  v54, v133 offset:28928                 \n"
"  ds_write_b32  v54, v134 offset:21760                 \n"
"  ds_write_b32  v54, v135 offset:29952                 \n"
"  ds_write_b32  v54, v136 offset:22784                 \n"
"  ds_write_b32  v54, v137 offset:30976                 \n"
"  ds_write_b32  v54, v138 offset:23808                 \n"
"  ds_write_b32  v54, v139 offset:32000                 \n"
"  ds_write_b32  v54, v140 offset:24832                 \n"
"  ds_write_b32  v54, v141 offset:33024                 \n"
"  ds_write_b32  v54, v142 offset:25856                 \n"
"  ds_write_b32  v54, v143 offset:34048                 \n"
"  s_waitcnt     lgkmcnt(0)                             \n"
"  s_barrier                                            \n"
"  v_lshrrev_b32  v54, 4, v0                            \n"
"  v_lshlrev_b32  v55, 6, v54                           \n"
"  v_and_b32     v54, 15, v0                            \n"
"  v_lshlrev_b32  v54, 1, v54                           \n"
"  v_add_u32     v55, v54, v55                          \n"
"  v_lshlrev_b32  v54, 2, v55                           \n"
"  ds_read_b64   v[128:129], v54 offset:18688           \n"
"  ds_read_b64   v[130:131], v54 offset:18816           \n"
"  ds_read_b64   v[132:133], v54 offset:19712           \n"
"  ds_read_b64   v[134:135], v54 offset:19840           \n"
"  ds_read_b64   v[136:137], v54 offset:20736           \n"
"  ds_read_b64   v[138:139], v54 offset:20864           \n"
"  ds_read_b64   v[140:141], v54 offset:21760           \n"
"  ds_read_b64   v[142:143], v54 offset:21888           \n"
"  ds_read_b64   v[144:145], v54 offset:22784           \n"
"  ds_read_b64   v[146:147], v54 offset:22912           \n"
"  ds_read_b64   v[148:149], v54 offset:23808           \n"
"  ds_read_b64   v[150:151], v54 offset:23936           \n"
"  ds_read_b64   v[152:153], v54 offset:24832           \n"
"  ds_read_b64   v[154:155], v54 offset:24960           \n"
"  ds_read_b64   v[156:157], v54 offset:25856           \n"
"  ds_read_b64   v[158:159], v54 offset:25984           \n"
"  ds_read_b64   v[160:161], v54 offset:26880           \n"
"  ds_read_b64   v[162:163], v54 offset:27008           \n"
"  ds_read_b64   v[164:165], v54 offset:27904           \n"
"  ds_read_b64   v[166:167], v54 offset:28032           \n"
"  ds_read_b64   v[168:169], v54 offset:28928           \n"
"  ds_read_b64   v[170:171], v54 offset:29056           \n"
"  ds_read_b64   v[172:173], v54 offset:29952           \n"
"  ds_read_b64   v[174:175], v54 offset:30080           \n"
"  ds_read_b64   v[176:177], v54 offset:30976           \n"
"  ds_read_b64   v[178:179], v54 offset:31104           \n"
"  ds_read_b64   v[180:181], v54 offset:32000           \n"
"  ds_read_b64   v[182:183], v54 offset:32128           \n"
"  ds_read_b64   v[184:185], v54 offset:33024           \n"
"  ds_read_b64   v[186:187], v54 offset:33152           \n"
"  ds_read_b64   v[188:189], v54 offset:34048           \n"
"  ds_read_b64   v[190:191], v54 offset:34176           \n"

#undef _UK_MFMA_
#undef _UK_PK_CVT_
#undef _UK_ATOMIC_ADD_

