// SPDX-License-Identifier: MIT
// Copyright (c) 2018-2022, Advanced Micro Devices, Inc. All rights reserved.

#pragma once

#include <string>
#include <utility>
#include <unordered_map>

namespace ck {
namespace host {

enum class DataType {
    Half,
    Float,
    Int8,
    Int32
};

std::unordered_map<std::string, std::pair<const char*,const char*>> GetHeaders();

std::size_t integer_divide_ceil(std::size_t x, std::size_t y);

} // namespace host
} // namespace ck
