for para in $*
do
    if [[ $para == --profiling* ]];then
        profiling=${para#*=}
    fi
done

# Those variables need to modify
GPUS="16"                 # how many gpus to use
HOST="a121"                 # hostname
PORT="11452"                 # port id
DATA_PATH="/data/datasets/oscar-1GB_head-qwen_text_document"            # path to oscar-1GB_head-llama2_text_document
TOKENIZER_MODEL_PATH="/data/models/qwen1.5" # path to tokenizer.model
CHECKPOINT_PATH="./ckpt"      # path to ckpt

# Runs Llama2 7B model
mpirun -np ${GPUS}  --hostfile hostfile \
                    --allow-run-as-root \
                    --bind-to none \
                    --mca plm_rsh_no_tree_spawn 1 \
                    --mca plm_rsh_args "-p 11451" \
                    bash -c "
                    ./train_qwen1.5_14b_1nodes.sh \
                    ${HOST} \
                    ${PORT} \
                    --data_path=$DATA_PATH \
                    --tokenizer_path=$TOKENIZER_MODEL_PATH \
                    --checkpoint_path=$CHECKPOINT_PATH \
                    --profiling=$profiling" > ./logs/log-$((${GPUS} / 8))nodes-`date +%F-%H%M`.log 2>&1

wait