import argparse

from .feature_manager import FEATURES_LIST

_ARGS = None


def process_args(parser):
    parser.conflict_handler = 'resolve'

    for feature in FEATURES_LIST:
        feature.register_args(parser)

    return parser


def get_adaptor_args():
    global _ARGS
    if _ARGS is None:
        parser = argparse.ArgumentParser(description='Adaptor Arguments', allow_abbrev=False)
        _ARGS, _ = process_args(parser).parse_known_args()

    return _ARGS
