<div align="center">
  <img src="docs/zh_cn/_static/image/logo.svg" width="500px"/>
</div>

## 🛠️ 安装指南

下面提供了快速安装和数据集准备的步骤。

### 💻 环境搭建

建议使用 `docker` 搭建环境。

- #### 创建容器

  ```bash
  docker run --shm-size 500g --network=host --name=opencompass --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /path/to/workspace/:/path/to/workspace/ -v /opt/hyhal:/opt/hyhal:ro -it image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.10 bash
  ```

- #### 通过pip安装OpenCompass

  ```bash
  # 支持绝大多数数据集及模型
  pip install -U opencompass
  ```

- #### 基于源码安装OpenCompass

  ```bash
  # 如果希望使用 OpenCompass 的最新功能，也可以从源代码构建它：
  git clone https://github.com/open-compass/opencompass opencompass
  cd opencompass
  pip install -e .
  ```

### 📂 数据准备

#### 提前离线下载

OpenCompass支持使用本地数据集进行评测，数据集的下载和解压可以通过以下命令完成：

```bash
# 下载数据集到 data/ 处
wget https://github.com/open-compass/opencompass/releases/download/0.2.2.rc1/OpenCompassData-core-20240207.zip
unzip OpenCompassData-core-20240207.zip
```

#### 从 OpenCompass 自动下载

OpenCompass已经支持从存储服务器自动下载数据集。可以通过额外的 `--dry-run` 参数来运行评估以下载这些数据集。
目前支持的数据集列表在[这里](https://github.com/open-compass/opencompass/blob/main/opencompass/utils/datasets_info.py#L259)。更多数据集将会很快上传。

#### (可选) 使用 ModelScope 自动下载

另外，还可以使用[ModelScope](www.modelscope.cn)来加载数据集：
环境准备：

```bash
pip install modelscope
export DATASET_SOURCE=ModelScope
```

配置好环境后，无需下载全部数据，直接提交评测任务即可。目前支持的数据集有：

```bash
humaneval, triviaqa, commonsenseqa, tydiqa, strategyqa, cmmlu, lambada, piqa, ceval, math, LCSTS, Xsum, winogrande, openbookqa, AGIEval, gsm8k, nq, race, siqa, mbpp, mmlu, hellaswag, ARC, BBH, xstory_cloze, summedits, GAOKAO-BENCH, OCNLI, cmnli
```

有部分第三方功能,如 Humaneval 以及 Llama,可能需要额外步骤才能正常运行，详细步骤请参考[安装指南](https://opencompass.readthedocs.io/zh_CN/latest/get_started/installation.html)。

<p align="right"><a href="#top">🔝返回顶部</a></p>

## 🏗️ ️评测

确保按照上述步骤正确安装了 OpenCompass 并准备好了数据集之后，可以开始使用 OpenCompass 进行首次评估！

- ### 首次评测

  OpenCompass 支持通过命令行界面 (CLI) 或 Python 脚本来设置配置。对于简单的评估设置，我们推荐使用 CLI；而对于更复杂的评估，则建议使用脚本方式。你可以在examples文件夹下找到更多脚本示例。

  ```bash
  # 命令行界面 (CLI)
  opencompass --models hf_internlm2_5_1_8b_chat --datasets demo_gsm8k_chat_gen
  
  # Python 脚本
  opencompass examples/eval_chat_demo.py
  ```

  你可以在[examples](./examples) 文件夹下找到更多的脚本示例。

- ### API评测

  OpenCompass 在设计上并不区分开源模型与 API 模型。可以以相同的方式或甚至在同一设置中评估这两种类型的模型。

  ```bash
  export OPENAI_API_KEY="YOUR_OPEN_API_KEY"
  # 命令行界面 (CLI)
  opencompass --models gpt_4o_2024_05_13 --datasets demo_gsm8k_chat_gen
  
  # Python 脚本
  opencompass  examples/eval_api_demo.py
  ```

## 📖 参考资料

https://github.com/open-compass/opencompass
