# 简介
本用例用于图像分割Unet_Industrial模型在ROCM平台TensorFlow框架下的训练和推理benchmark测试，测试流程如下
# 测试流程
## 下载数据集
[DAGM2007](https://resources.mpi-inf.mpg.de/conference/dagm/2007/prizes.html)  
数据结构如下  
raw_images  
> private  
>> Class1  
>> Class2  
>> ......  
>> Class10  

> public  
>> Class1  
>> Class1_def  
>> ......  
>> Class6  
>> Class6_def  

zip_files  
> private  
>> Class1.zip  
>> Class2.zip  
>> ......  
>> Class10.zip  

> public  
>> Class1.zip  
>> Class1_def.zip  
>> ......  
>> Class6.zip  
>> Class6_def.zip  

## 运行指令
### benchmark
#### 训练性能benchmark
	./scripts/benchmarking/DGX1v_trainbench_{FP16, FP32, FP32AMP, FP32FM}_{1, 4, 8}GPU.sh <path to result repository> <path to dataset> <DAGM2007 classID (1-10)>  
示例，使用Class 1进行单卡训练  

	./scripts/DGX1v_trainbench_FP32_4GPU.sh /path/to/{save_dir} /path/to/{DAGM2007_dir} 1
多卡运行时在DGX1v_trainbench_FP32_4GPU.sh中加入mpirun命令即可  

#### 推理性能benchmark
	./scripts/benchmarking/DGX1v_evalbench_FP16_1GPU.sh <path to result repository> <path to dataset> <dagm classID (1-10)>  
### 训练
	./UNet_FP32_1GPU.sh <path to result repository> <path to dataset> <DAGM2007 classID (1-10)>  
### 推理
	./UNet_FP32_EVAL.sh <path to result repository> <path to dataset> <DAGM2007 classID (1-10)>

# 参考
[https://github.com/NVIDIA/DeepLearningExamples/tree/master/TensorFlow/Segmentation/UNet_Industrial](https://github.com/NVIDIA/DeepLearningExamples/tree/master/TensorFlow/Segmentation/UNet_Industrial)



