#!/bin/bash
export MIOPEN_DEBUG_DISABLE_FIND_DB=1
export NCCL_SOCKET_IFNAME=eno1
export HSA_USERPTR_FOR_PAGED_MEM=0
export HIP_LAUNCH_BLOCKING=1
lrank=$OMPI_COMM_WORLD_LOCAL_RANK
comm_rank=$OMPI_COMM_WORLD_RANK
comm_size=$OMPI_COMM_WORLD_SIZE
APP="python3 /work/home/hepj/torch/bert-squad/run_squad_v4.py \
  --train_file  ${HOME}/data/sq1.1/train-v1.1.json \
  --predict_file  ${HOME}/data/sq1.1/dev-v1.1.json \
  --init_checkpoint  ${HOME}/model/pytorch_bert/model.ckpt-28252.pt \
  --vocab_file  ${HOME}/model/pytorch_bert/vocab.txt \
  --output_dir  ${HOME}/outdir/torch/SQUAD4 \
  --config_file  ${HOME}/model/pytorch_bert/bert_config.json \
  --json-summary  ${HOME}/outdir/torch/SQUAD4/results.json \
  --bert_model bert-large-uncased \
  --do_train \
  --do_predict \
  --train_batch_size  4 \
  --predict_batch_size 4 \
  --gpus_per_node  2 \
  --local_rank ${comm_rank} \
  --world_size ${comm_size} \
  --use_env  \
  --dist_url tcp://${1}:34567 \
 "
case ${lrank} in
[0])
  export HIP_VISIBLE_DEVICES=0
  export UCX_NET_DEVICES=mlx5_0:1
  export UCX_IB_PCI_BW=mlx5_0:50Gbs
  echo NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=0 --membind=0 ${APP}
  NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=1
  export UCX_NET_DEVICES=mlx5_1:1
  export UCX_IB_PCI_BW=mlx5_1:50Gbs
  echo NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=1 --membind=1 ${APP}
  NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=1 --membind=1 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=2
  export UCX_NET_DEVICES=mlx5_2:1
  export UCX_IB_PCI_BW=mlx5_2:50Gbs
  echo NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=2 --membind=2 ${APP}  
  NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=2 --membind=2 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=3
  export UCX_NET_DEVICES=mlx5_3:1
  export UCX_IB_PCI_BW=mlx5_3:50Gbs
  echo NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=3 --membind=3 ${APP}  
  NCCL_SOCKET_IFNAME=eno1 numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac
