# 介绍  
[TOC]

本测试用例用于测试目标检测YOLOv3模型在ROCm平台PyTorch框架下的训练性能、推理性能和检测准确性，使用的数据集为COCO2017，其具体测试流程如下 ：

# 测试流程    
## 测试数据准备  
### 数据预处理  
使用本算例进行测试前，需要将coco数据转化为符合yolov3模型输入要求的格式，即将数据集中的annotation json文件转化为label。

操作流程如下：

下载coco-to-yolo工具和预编译的jar文件

git clone https://github.com/RTalha/COCOTOYOLO-Annotations

应用程序的参数分别为：

- COCO数据集注释JSON文件的路径
- COCO数据集图像的绝对路径，此路径将在生成的图像列表中使用。
- 要包含在输出中的类别名称的都好分隔列表。COCO有80个类，但您可以指定其中一个子集，逗号前后都不允许使用空格。如 ("person,bus,truck")

- 生成的标签文件和图像列表应输出到的路径/目录

该转换步骤应分别针对训练数据集和val数据集运行

```
java -jar cocotoyolo.jar "coco/annotations/instances_train2017.json" "/usr/home/madmax/coco/images/train2017/" "person,bicycle," "coco/yolo"

java -jar cocotoyolo.jar "coco/annotations/instances_val2017.json" "/usr/home/madmax/coco/images/val2017/" "person,bicycle" "coco/yolo"
```

然后运行最终的转换文件，将所有txt文件转换为一个注释.txt文件

- 1、通过添加上述java文件的输出路径来更新最终转换文件
- 2 、然后为图像提供final_conversion文件的路径
- 3、最后根据您的需求更新注释.txt。

如果要从所有coco图像复制自定义图像

```
ls person-dataset/ |sed 's/.txt/.jpg/' | xargs -i bash -c 'cp train2017/{} person-dataset-images/ '
```

### 下载预训练模型

下载链接 
[https://drive.google.com/drive/folders/1LezFG5g3BCW6iYaV89B2i64cqEUZD7e0](https://drive.google.com/drive/folders/1LezFG5g3BCW6iYaV89B2i64cqEUZD7e0) 
下载完成后放入weight目录

## 测试环境准备

### 环境搭建

```
conda create -n yolov3 python='3.7'`

conda activate yolov3
```

### 安装python依赖包

```
requirement.txt:

pip3 install tqdm

pip3 install opencv-contrib-python

pip3 install matplotlib

pip3 install numpy 

pip3 install pillow
```

```
pip3 install -r requirement.txt
```

### 安装Pytorch

```
pip3 install torch-1.10.0a0+giteb1c977-cp36-cp36m-linux_x86_64.whl

pip3 install torchvision-0.10.0a0+300a8a4-cp36-cp36m-linux_x86_64.whl -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

pip3 install pycocotools -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

### 环境变量设置

```
export HSA_FORCE_FINE_GRAIN_PCIE=1
export MIOPEN_FIND_MODE=3
```



## 运行示例

### 训练  
#### 单卡  

```
python3 train.py --epochs 500 --batch-size 32 --cfg cfg/yolov3.cfg --weights weights/yolov3.pt --data data/coco.data --device 0
```

运行前需确认coco2017.data中train2017.txt和val2017.txt中的数据路径，若出现No such file or directory需要修改文件中的数据路径，或者直接将COCO2017数据集放置在程序根目录当中。
#### 多卡

	python -m torch.distributed.run --nproc_per_node 2 train.py --epochs 500 --batch-size 64 --cfg cfg/yolov3.cfg --weights weights/yolov3.pt --data data/coco.data --device 0,1  
### 检测

使用detect.py文件进行测试，是yolov3模型的的实际应用，测试内容是指定一张图片，检测图片中物体，观察准确率。运行指令如下：
	python3 detect.py --cfg cfg/yolov3.cfg --weights weights/yolov3.pt  
运行完成后会生成带有检测框的图片。  

# 参考
[https://github.com/ultralytics/yolov3](https://github.com/ultralytics/yolov3)



