

# YOLOV5算力测试

[TOC]

## 1.测试前准备

### 1.1 数据集

使用COCO2017数据集

### 1.2 环境搭建

建立python3.7的环境

```
conda create -n yolov5 python=3.7

conda activate yolov5
```

安装python依赖包

```
pip3 install PyYAML>=5.3.1
pip3 install tqdm>=4.41.0
pip3 install opencv-python>=4.1.2
pip3 install pandas>=1.1.4
pip3 install requests>=2.23.0
pip3 install matplotlib>=3.2.2
pip3 install seaborn>=0.11.0
pip3 install tensorboard>=2.4.1
```

```
pip3 install torch-1.10.0a0+git450cdd1.dtk22.4-cp37-cp37m-linux_x86_64.whl -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

pip3 install torchvision-0.10.0a0_dtk22.04_300a8a4-cp37-cp37m-linux_x86_64.whl -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

pip3 install pycocotools -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

## 2. 单卡训练

```
export HSA_FORCE_FINE_GRAIN_PCIE=1
export MIOPEN_FIND_MODE=3

python3 train.py --data data/coco.yaml --cfg models/yolov5x.yaml --weights weights/yolov5x.pt --device 0 --batch-size 32 --epochs 10
```

## 3. 多卡训练

### 3.1 单节点多卡

**pytorch启动方式**

```
python3 -m torch.distributed.run --nproc_per_node 4 train.py --batch 256 --data coco.yaml --cfg 'yolov5s.yaml' --weights 'yolov5s.pt' --project 'run_origin_yolov5s/train' --hyp 'data/hyps/hyp.scratch-low.yaml' --device 0,1,2,3 --epochs 1000
```

其中--nproc_per_node参数代表卡的个数，--batch参数代表global batchsize的大小

**mpi启动方式**

```
mpirun -np $np --bind-to none `pwd`/single_process.sh localhost
```



### 3.2 多节点多卡

**pytorch启动方式**

```
python3 -m torch.distributed.launch --nproc_per_node 4 --nnodes 2 --node_rank 0 --master_addr "a03r4n01" --master_port 34567 train.py --batch 256 --data coco.yaml --weight 'yolov5s.pt' --project 'multi/train' --hyp 'data/hyps/hyp.scratch-low.yaml' --cfg 'yolov5s.yaml' --epochs 1000  2>&1 | tee  multi.log

python3 -m torch.distributed.launch --nproc_per_node 4 --nnodes 2 --node_rank 1 --master_addr "a03r4n01" --master_port 34567 train.py --batch 256 --data coco.yaml --weight 'yolov5s.pt' --project 'multi/train' --hyp 'data/hyps/hyp.scratch-low.yaml' --cfg 'yolov5s.yaml' --epochs 1000  2>&1 | tee  multi.log
```

这里需要注意的是--master_addr是你的主节点，也就是log会输出的节点，两个指令的主节点需要保持一致，同时--node_rank需要保证不同，--nnodes为使用的节点数量。

**mpi启动方式**

```
mpirun -np $np --hostfile hostfile --bind-to none `pwd`/single_process.sh $dist_url 
```

其中hostfile为所使用的多个节点名称的配置文件，具体格式示例为

```
node1 slots=4  
node2 slots=4
```

**tips：需要注意的是，在超参数的选取上，小模型使用hyp.scratch-low，例如yolov5s，而大模型需要使用hyp.scratch-high，例如yolov5m，它们的区别为，low有更快的收敛速度，而high参数收敛速度慢，但是不容易陷入局部最优。**

## 4. 推理测试

```
python3 val.py --data data/coco-v5.yaml --weights runs/train/exp12/weights/best.pt --device 0
```

## 5.画出loss和精度曲线

如果在训练一段时间后想要得到类似上述的loss及map曲线，我们提供了view_code.py文件，只需要将您训练过程中--project 指定的路径写入，之后执行python3 view_code.py即可在该路径下得到曲线的图像。

## 6. 存在的问题及解决方案

### 6.1 pycocotools输出结果特别低问题

在训练结束或者推理结束后有时候会发现pycocotools输出的结果不正确，数值会非常低，如下图所示

![pycoco错误结果](pycoco错误结果.png)

这是由于python的版本过低导致的问题，除了升级Python版本外，还可以对代码进行修改也可以解决问题，将val.py文件中的如图所示位置，注释掉红框部分的代码也可得到正确的结果。

![pycocotools](pycocotools.png)





