# MMpose算例测试

## 测试前准备
### 数据集准备
使用COCO2017数据集.
### 环境部署
```python
yum install python3
yum install libquadmath
yum install numactl
yum install openmpi3
yum install glog
yum install lmdb-libs
yum install opencv-core
yum install opencv
yum install openblas-serial
pip3 install --upgrade pip
pip3 install opencv-python
```
### 安装python依赖包
```python
pip3 install torch-1.10.0a0+git2040069.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install torchvision-0.10.0a0+e04d001.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install mmcv_full-1.6.1+gitdebbc80.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
poseval安装：
cd poseval
pip install -e .  
mmpose安装：
cd mmpose-0.28.1 
pip3 install -e .
```
注：测试不同版本的dtk，需安装对应版本的库whl包.
## ResNet50-Bottom-Up测试
### 单卡测试（单精度）
```python
./sing_test.sh configs/body/2d_kpt_sview_rgb_img/topdown_heatmap/coco/res50_coco_256x192.py
```
#### 参数说明
configs/body/2d_kpt_sview_rgb_img/res50_coco_256x192_dummy.py 中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
#### 性能关注：time

#### 单机多卡训练

1.pytorch单机多卡训练

```python
./tools/dist_train.sh configs/body/2d_kpt_sview_rgb_img/topdown_heatmap/coco/res50_coco_256x192.py $GPUS
```

#### 多机多卡训练

1.pytorch多机多卡训练

在第一台机器上:

NODES=$NNODES NODE_RANK=$NODE_RANK PORT=$PORT MASTER_ADDR=$MASTER_ADDR sh tools/dist_train.sh configs/body/2d_kpt_sview_rgb_img/res50_coco_256x192_dummy.py $GPUS

在第二台机器上:

NODES=$NNODES NODE_RANK=$NODE_RANK PORT=$PORT MASTER_ADDR=$MASTER_ADDR sh tools/dist_train.sh configs/body/2d_kpt_sview_rgb_img/res50_coco_256x192_dummy.py $GPUS

### 半精度测试

修改configs文件，添加fp16 = dict(loss_scale=512.)，单机多卡和多机多卡测试与单精度测试方法相同。

### 其他模型测试

其他模型的测试步骤和ResNet50-Bottom-Up相同，只需修改对应的config文件即可，下面列出相关模型对应的config文件列表：

| 模型               | configs                                                      |
| ------------------ | ------------------------------------------------------------ |
| ResNet50-Top-Down  | configs/body/2d_kpt_sview_rgb_img/topdown_heatmap/coco/res50_coco_256x192.py |
| HrNet-Top-Down     | configs/body/2d_kpt_sview_rgb_img/topdown_heatmap/coco/hrnet_w32_coco_256x192.py |
| ResNet50-Bottom-Up | configs/body/2d_kpt_sview_rgb_img/associative_embedding/coco/hrnet_w32_coco_512x512.py |
