TensorFlow 框架 训练 图像分类相关网络的代码,tensorflow 官方基准测试程序，使用的数据集是 imagenet。

# 测试运行

- 测试代码分为两部分，基础性能测试和大规模性能测试。

## 基础 benchmark

- 创建 TensorFlow 运行时环境后，以 resnet50 网络为例，计算其 batch_size=128 num_gpu=1 条件下不同精度的性能，分为训练和推理两部分

### fp32 train

    python3 official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --model_dir=$save_checkpoint_path --num_gpus=1   --batch_size=128 --train_epochs=90 --enable_checkpoint_and_export --use_synthetic_data=false  --dtype=fp32   --data_dir=$data_dir_path  

### fp16 train

    python3 official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --model_dir=$save_checkpoint_path --num_gpus=1   --batch_size=128 --train_epochs=90 --enable_checkpoint_and_export --use_synthetic_data=false  --dtype=fp16   --data_dir=$data_dir_path

## 大规模测试

### 单卡

    HIP_VISIBLE_DEVICES=0  python3 official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --model_dir=$save_checkpoint_path --num_gpus=1   --batch_size=128 --train_epochs=90 --enable_checkpoint_and_export --use_synthetic_data=false  --dtype=fp32   --data_dir=$data_dir_path

### 多卡

    配置多进程时，使用MultiWorkerMirroredStrategy，并在official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py文件中配置TF_CONFIG，然后启动多进程
    TF_CONFIG = '{"cluster": {"worker": ["localhost:12345", "localhost:23456"]}, "task": {"type": "worker", "index": 0} }'


# 参考资料
 [https://www.tensorflow.org/api_docs/python/tf/distribute/MultiWorkerMirroredStrategy]
 [https://github.com/tensorflow/models/tree/v2.7.0/official/vision/image_classification/resnet ]
