# 介绍
本测试用例用于图像分类ResNet50模型在ROCm平台的精度验证，测试流程如下。
# 测试流程
## 加载环境变量
下载tensorflow官方github中的[model](https://github.com/tensorflow/models)
设置python变量：

        export PYTHONPATH=$PYTHONPATH:/path/to/tensorflow/model
ROCm平台使用MIOpen进行加速，以下变量设置可以参考使用：
  
        export HSA_FORCE_FINE_GRAIN_PCIE=1
           
        export MIOPEN_DEBUG_DISABLE_FIND_DB=3

## 运行示例
可以使用单卡或多卡运行，4卡运行指令如下：

        cd official/resnet

        python3 official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=4  --use_synthetic_data=false

# 参考
[https://github.com/tensorflow/models/tree/v2.7.0](https://github.com/tensorflow/models/tree/v2.7.0/official/vision/image_classification/resnet)
