# 简介

- 目标检测程序，支持Faster-rcnn和SSD
  <br>

# 环境部署

## （1）升级 pip

```
pip3 install --upgrade pip -i http://pypi.douban.com/simple/ --trusted-host pypi.douban.com
```

## （2）pip3 install -r requirements.txt

```
protobuf
pillow
lxml
jupyter
matplotlib
Cython
contextlib2
gast
```

## （3）安装 horovod

```
git clone --recusive https://github.com/ROCmSoftwarePlatform/horovod.git
HOROVOD_WITH_TENSORFLOW=1 python3 setup.py install
```

## （4）安装 cocoapi

```
git clone https://github.com/cocodataset/cocoapi.git
cd cocoapi/PythonAPI
make
cp -r pycocotools /path/to/Objection/research
```

## （5）安装 slim

```
cd slim
python3 setup install
```

## （6）升级 pandas

```
pip3 install --upgrade pandas -i http://pypi.douban.com/simple/ --trusted-host pypi.douban.com
```

## （7）Protobuf Compilation

```
wget -O protobuf.zip https://github.com/google/protobuf/releases/download/v3.0.0/protoc-3.0.0-linux-x86_64.zip
unzip protobuf.zip
./bin/protoc /path/to/Objection/research/object_detection/protos/ *.proto --python_out=.
```

## （8）添加 PYTHONPATH

```
export LD_LIBRARY_PATH=/public/home/tianlh/tool/devtoolset7:$LD_LIBRARY_PATH
export PYTHONPATH=$PYTHONPATH:/path/to/Objection/research:/path/to/Objection/research/slim
export LD_LIBRARY_PATH=/path/to/Objection/research/slim:$LD_LIBRARY_PATH
如遇python文件调用问题，清理缓存，重新设置环境变量
rm -rf ~/.cache/ *
rm -rf {MIOPEN_USER_DB_PATH}/ *
```

# 2、创建数据集

```
wget https://github.com/tensorflow/models/blob/master/research/object_detection/dataset_tools/create_coco_tf_record.py
python3 object_detection/dataset_tools/create_coco_tf_record.py --logtostderr \
--train_image_dir="/path/to/COCO2017/images/train2017" \
--val_image_dir="/path/to/COCO2017/images/val2017" \
--train_annotations_file="/path/to/COCO2017/annotations/instances_train2017.json" \
--val_annotations_file="/path/to/COCO2017/annotations/instances_val2017.json" \
--output_dir="/path/to/COCO2017-TF/"
```

# 3、下载预训练模型

```
https://github.com/tensorflow/models/blob/master/research/object_detection/g3doc/detection_model_zoo.md
wget *
tar -zxf *.tar.gz
```

# 4、确认数据集&预训练模型路径

vim samples/configs/ssd_inception_v2_coco.config
修改“PATH_TO_BE_CONFIGURED”

# 5、测试执行

## SSD

### 单卡

```
python3 legacy/train.py --pipeline_config_path=samples/configs/ssd_inception_v2_coco.config --train_dir=result/ssd_inceptionV2_1gpu --num_clones=1 --ps_tasks=0 --alsologtostderr
```

### 4 卡

```
numactl --cpunodebind=0,1,2,3 --membind=0,1,2,3 python3 legacy/train.py --pipeline_config_path=samples/configs/ssd_inception_v2_coco.config --train_dir=result/ssd_inceptionV2_4gpu --num_clones=4 --ps_tasks=1 --alsologtostderr
```

## Fastercnn

<br>

|         参数         |       解释        |                                                                                                                示例                                                                                                                 |
| :------------------: | :---------------: | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| PIPELINE_CONFIG_PATH | train config 路径 | [faster_rcnn_inception_v2_coco.config](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/blob/develop/TensorFlow/ComputeVision/Objection/models/research/object_detection/samples/configs/faster_rcnn_inception_v2_coco.config) |
|      CPKT_PATH       | 输出文件保存路径  |                                                                                                                  -                                                                                                                  |
|      NUM_CLONES      |   计算显卡数量    |                                                                                                                  -                                                                                                                  |
|       PS_TASKS       |      任务数       |                                                                                                                  -                                                                                                                  |

<br>

    WORK_DIR=`pwd`
    python3 ${WORK_DIR}/models/research/object_detection/legacy/train.py --pipeline_config_path=${PIPELINE_CONFIG_PATH} --train_dir=${CPKT_PATH} --num_clones=${NUM_CLONES} --ps_tasks=${PS_TASKS} --alsologtostderr

# 参考资料

[https://github.com/tensorflow/models/tree/master/research/object_detection](https://github.com/tensorflow/models/tree/master/research/object_detection)
