# 介绍

  该测试用例可用于ResNet50等网络的性能测试及精度验证。

# 单卡测试（单精度）

## 运行

    export PYTHONPATH=/path/to/tensorflow/model:$PYTHONPATH    
    export HIP_VISIBLE_DEVICES=0
    python3 official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=1  --use_synthetic_data=false
  
# 单卡测试 （混合精度）

## 运行 

    export PYTHONPATH=/path/to/tensorflow/model:$PYTHONPATH
    export HIP_VISIBLE_DEVICES=0
    python3 official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=1  --use_synthetic_data=false --dtype=fp16

# 多卡测试 （单精度）

## 运行
    # sed指令只需要执行一次，添加支持多卡运行的代码
    sed -i '99 r configfile' official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py
    
    export PYTHONPATH=/path/to/tensorflow/model:$PYTHONPATH
    mpirun -np $np --hostfile hostfile  -mca btl self,tcp  --bind-to none scripts-run/single_process.sh

# 多卡测试 (混合精度)

## 运行
    # sed指令只需要执行一次，添加支持多卡运行的代码
    sed -i '99 r configfile' official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py
    
    修改scripts-run/single_process.sh中的--dtype=fp16
    export PYTHONPATH=/path/to/tensorflow/model:$PYTHONPATH
    mpirun -np $np --hostfile hostfile  -mca btl self,tcp  --bind-to none scripts-run/single_process.sh

## 测试说明

   多卡测试时需要修改部分代码，具体可参考https://tensorflow.google.cn/guide/migrate/multi_worker_cpu_gpu_training?hl=en
   
   hostfile格式参考：
     node1 slots=4
     node2 slots=4

   nodefile格式参考(与hostfile文件内保持一致，用于构造TF_CONFIG)：
     node1
     node2
  
   上面多卡测试方法默认每节点4卡

# 参考
[https://github.com/tensorflow/models/tree/v2.7.0](https://github.com/tensorflow/models/tree/v2.7.0/official/vision/image_classification/resnet)

