# 介绍 
本测试用例用于图像分类ResNet50模型在ROCm平台的精度验证，测试流程如下。
# 测试流程
## 加载环境变量 
下载tensorflow官方github中的[model](https://github.com/tensorflow/models)  
设置python变量：   

	export PYTHONPATH=$PYTHONPATH:/path/to/tensorflow/model  
ROCm平台使用MIOpen进行加速，以下变量设置可以参考使用：  

	export MIOPEN_DEBUG_DISABLE_FIND_DB=1  

	export MIOPEN_USER_DB_PATH=/path/to/{miopen_save_dir}  

	export LD_LIBRARY_PATH=/path/to/devtoolset7:$LD_LIBRARY_PATH  
## 运行示例
可以使用单卡或多卡运行，4卡运行指令如下：  

	cd official/resnet  

	python3 imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=512 --num_gpus=4  
# 参考
[https://github.com/tensorflow/models/tree/r1.13.0/official/resnet](https://github.com/tensorflow/models/tree/r1.13.0/official/resnet)
