# 简介

  该测试用例可用于ResNet50/Vgg16等网络的性能测试及精度验证。 

# 单卡测试 (单精度)

## 运行
    
    export HIP_VISIBLE_DEVICES=0  
    python3 ./benchmarks-master/scripts/tf_cnn_benchmarks/tf_cnn_benchmarks.py --data_format=NCHW --batch_size=128 --model=resnet50 --optimizer=momentum --variable_update=parameter_server  --print_training_accuracy=true  --nodistortions --num_gpus=1 --num_epochs=90 --weight_decay=1e-4 --data_dir=$data_dir_path   --use_fp16=False --data_name=imagenet --train_dir=$save_checkpoint_path

# 单卡测试 (混合精度)

## 运行
    export HIP_VISIBLE_DEVICES=0    
    python3 ./benchmarks-master/scripts/tf_cnn_benchmarks/tf_cnn_benchmarks.py --data_format=NCHW --batch_size=128 --model=resnet50 --optimizer=momentum --variable_update=parameter_server  --print_training_accuracy=true  --nodistortions --num_gpus=1 --num_epochs=90 --weight_decay=1e-4 --data_dir=$data_dir_path   --use_fp16=True --data_name=imagenet --train_dir=$save_checkpoint_path

# 多卡测试 (单精度)

## 运行

    mpirun -np 4 --hostfile hostfile  -mca btl self,tcp  --bind-to none scripts-run/single_process.sh 

# 多卡测试 (混合精度)

   修改scripts-run/single_process.sh中的--use_fp16=True

## 运行
  
   mpirun -np 4 --hostfile hostfile  -mca btl self,tcp  --bind-to none scripts-run/single_process.sh 
    
# 参考资料
[https://github.com/tensorflow/benchmarks/tree/master/scripts/tf_cnn_benchmarks](https://github.com/tensorflow/benchmarks/tree/master/scripts/tf_cnn_benchmarks)

