# UNet

本测试用例源码来自于[UNet](https://github.com/zhixuhao/unet.git)

## 测试准备
### 数据集与依赖包
- 数据集：data目录下包含预处理后的小部分[isbi challenge](http://brainiac2.mit.edu/isbi_challenge/)数据集，可以直接进行训练，也可以下载全部数据集再训练。
- python版本：3.6.8
- 下载[TensorFlow2.7.0](http://10.0.50.210:8000/jenkins/rocm/yum/21.10.1/whl/tensorflow-2.7.0-cp36-cp36m-linux_x86_64.whl)
- 下载[horovod0.22.1](http://10.0.50.210:8000/jenkins/rocm/yum/21.10.1/whl/horovod-0.22.1-tf2.x-cp36-cp36m-linux_x86_64.whl)
### 安装依赖包
- `pip3 install tensorflow-2.7.0-cp36-cp36m-linux_x86_64.whl`
- `pip3 install horovod-0.22.1-tf2.x-cp36-cp36m-linux_x86_64.whl`
- `pip3 install keras`
### 环境变量配置
- `export HSA_FORCE_FINE_GRAIN_PCIE=1`
- `export MIOPEN_FIND_MODE=3`

## 测试运行
#whitout xla

` python3 main.py `

#with xla

TF_XLA_FLAGS="--tf_xla_auto_jit=2" python3 main.py



## 参数说明
main.py文件内：
- trainGenerator的第一个参数为batch_size
- steps_per_epoch和epochs可以调整训练步数和代数
- myGene可以修改训练数据集路径，testGene可以修改测试数据集路径，model_checkpoint可以修改预训练模型路径


## 性能关注
训练结束会显示每步（step）训练时间，可以根据设置的batch_size大小，将结果转换为image/sec

## 性能参考
测试环境为`dtk21.10.1`，使用`DCU2号`
batch size | (sec/step) | (img/sec)
:-:|:-:|:-:
1|96ms|10.416
4|223ms|17.937
8|390ms|20.512

