# YOLOV3算力测试（TensorFlow2.7）

## 数据集准备

数据集下载voc2012：https://pjreddie.com/projects/pascal-voc-dataset-mirror/

```
export HOME_PATH=/public/home/zhenyi/Benchmark/yolov3_tf2
wget http://host.robots.ox.ac.uk/pascal/VOC/voc2012/VOCtrainval_11-May-2012.tar -O ./data/voc2012_raw.tar
mkdir -p ./data/voc2012_raw
tar -xf ./data/voc2012_raw.tar -C ./data/voc2012_raw
```

## 构建测试环境

```
conda create -n yolov3-tf python=3.7
conda activate yolov3-tf
```

## 安装TensorFlow

```
pip3 install tensorflow-2.7.0-cp36-cp36m-linux_x86_64.whl
```

## 安装python依赖包

建立requirement.txt

```
opencv-python==4.2.0.32
lxml
tqdm
```

```
pip3 install -r requirement.txt
```

测试中numpy版本过低会报错，执行 pip3 install numpy==1.16将其升级，并执行pip3 install easydict tqdm，安装easydict和tqdm依赖包，环境基本搭建完成。

## 环境变量设置

```
module rm compiler/rocm/2.9
module load compiler/rocm/dtk-21.10.1
export MIOPEN_DEBUG_DISABLE_FIND_DB=1
export MIOPEN_DEBUG_CONV_WINOGRAD=0
export MIOPEN_DEBUG_CONV_IMPLICIT_GEMM=0
export MIOPEN_FIND_MODE=3
export HSA_FORCE_FINE_GRAIN_PCIE=1
export MIOPEN_SYSTEM_DB_PATH=/tmp/pytorch-miopen-2.8

export LD_LIBRARY_PATH=/public/home/zhenyi/miniconda3/envs/tf2.7.0-dtk21.10-build/lib:$LD_LIBRARY_PATH
```

## 权重文件和数据集准备

权重下载并转换:

```
# yolov3
wget https://pjreddie.com/media/files/yolov3.weights -O data/yolov3.weights
python convert.py --weights ./data/yolov3.weights --output ./checkpoints/yolov3.tf
```

数据集转换：

```
python tools/voc2012.py \   
--data_dir './data/voc2012_raw/VOCdevkit/VOC2012' \   
--split train \   
--output_file ./data/voc2012_train.tfrecord   

python tools/voc2012.py \   
--data_dir './data/voc2012_raw/VOCdevkit/VOC2012' \   
--split val \   
--output_file ./data/voc2012_val.tfrecord
```

可以利用如下方式可视化数据集：

```
python tools/visualize_dataset.py --classes=./data/voc2012.names
```

运行以上代码会得到一个带有标签的随机图像到output.jpg

## 训练

执行如下代码即可训练

```
export HIP_VISIBLE_DEVICES=0
export PYTHONPATH=/public/home/zhenyi/miniconda3/envs/tf2.7.0-dtk21.10-build/bin/
#without xla
python train.py \
 --dataset ./data/voc2012_train.tfrecord \
 --val_dataset ./data/voc2012_val.tfrecord \
 --classes ./data/voc2012.names \
 --num_classes 20 \
 --mode fit --transfer darknet \
 --batch_size 16 \
 --epochs 10 \
 --weights ./checkpoints/yolov3.tf \ 
 --weights_num_classes 80
 #with xla
TF_XLA_FLAGS="--tf_xla_auto_jit=2" python train.py \
 --dataset ./data/voc2012_train.tfrecord \
 --val_dataset ./data/voc2012_val.tfrecord \
 --classes ./data/voc2012.names \
 --num_classes 20 \
 --mode fit --transfer darknet \
 --batch_size 16 \
 --epochs 10 \
 --weights ./checkpoints/yolov3.tf \ 
 --weights_num_classes 80
```

