# MMsegmentation算例测试

## 测试前准备

使用cityscapes数据集.链接：https://pan.baidu.com/s/1kxqTJxoyqcIGTCPOMbzB_g  提取码：asie

### 环境部署

```python
yum install python3
yum install libquadmath
yum install numactl
yum install openmpi3
yum install glog
yum install lmdb-libs
yum install opencv-core
yum install opencv
yum install openblas-serial
pip3 install --upgrade pip
pip3 install opencv-python
```

### 安装python依赖包

```python
pip3 install torch-1.10.0a0+gitcc7c9c7-cp36-cp36m-linux_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install torchvision-0.10.0a0+300a8a4-cp36-cp36m-linux_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install mmcv_full-1.3.16-cp36-cp36m-linux_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
mmpose安装：
cd mmsegmentation
pip3 install -e .
```

注：测试不同版本的dtk，需安装对应版本的库whl包，dtk22.04.1使用python3.7，dtk21.10.1使用python3.6,如果测试优化后的版本，需要设置export HIP_UPSAMPLE_OPTIMIZE=1

## PSPNet R50测试

### 单卡测试（单精度）

```python
./sing_test.sh configs/pspnet/pspnet_r50-d8_512x1024_40k_cityscapes.py
```

若使用dtk22.04.1测试，需设置 `export MIOPEN_FIND_MODE=1，export MIOPEN_USE_APPROXIMATE_PERFORMANCE=0`以下测试均相同.

#### 参数说明

configs/_base_/datasets/cityscapes.py中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659172384601](image/train/1659172384601.png)

#### 性能关注：time

### 多卡测试（单精度）

```python
./multi_test.sh configs/pspnet/pspnet_r50-d8_512x1024_40k_cityscapes.py
```

## DeepLabV3 R50测试

### 单卡测试（单精度）

```python
./sing_test.sh configs/deeplabv3/deeplabv3_r50-d8_512x1024_40k_cityscapes.py
```

#### 参数说明

configs/_base_/datasets/cityscapes.py中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659172468356](image/train/1659172468356.png)

#### 性能关注：time

### 多卡测试（单精度）

```python
./multi_test.sh configs/deeplabv3/deeplabv3_r50-d8_512x1024_40k_cityscapes.py
```

## FCN R50测试

### 单卡测试（单精度）

```python
./sing_test.sh configs/fcn/fcn_r50-d8_512x1024_40k_cityscapes.py
```

#### 参数说明

configs/_base_/datasets/cityscapes.py中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659172530175](image/train/1659172530175.png)

#### 性能关注：time

### 多卡测试（单精度）

```python
./multi_test.sh configs/fcn/fcn_r50-d8_512x1024_40k_cityscapes.py
```

## UperNet R50测试

### 单卡测试（单精度）

```python
./sing_test.sh configs/upernet/upernet_r50_512x1024_40k_cityscapes.py
```

#### 参数说明

configs/_base_/datasets/cityscapes.py中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659172631957](image/train/1659172631957.png)

#### 性能关注：time

### 多卡测试（单精度）

```python
./multi_test.sh configs/upernet/upernet_r50_512x1024_40k_cityscapes.py
```

## DeepLabV3plus_R50测试

### 单卡测试（单精度）

```python
./sing_test.sh configs/deeplabv3plus/deeplabv3plus_r50-d8_512x1024_40k_cityscapes.py
```

#### 参数说明

configs/_base_/datasets/cityscapes.py中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659172696867](image/train/1659172696867.png)

#### 性能关注：time

### 多卡测试（单精度）

```python
./multi_test.sh configs/deeplabv3plus/deeplabv3plus_r50-d8_512x1024_40k_cityscapes.py
```
