# MMpose算例测试

## 测试前准备
### 数据集准备
使用dummy数据集.
### 环境部署
```python
yum install python3
yum install libquadmath
yum install numactl
yum install openmpi3
yum install glog
yum install lmdb-libs
yum install opencv-core
yum install opencv
yum install openblas-serial
pip3 install --upgrade pip
pip3 install opencv-python
```
### 安装python依赖包
```python
pip3 install torch-1.10.0a0+gitcc7c9c7-cp36-cp36m-linux_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install torchvision-0.10.0a0+300a8a4-cp36-cp36m-linux_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install mmcv_full-1.3.16-cp36-cp36m-linux_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
poseval安装：
cd poseval
pip install -e .  
mmpose安装：
cd mmpose 
pip3 install -e .
```
注：测试不同版本的dtk，需安装对应版本的库whl包，dtk22.04.1使用python3.7，dtk21.10.1使用python3.6
## ResNet50-Bottom-Up测试
### 单卡测试（单精度）
```python
./sing_test.sh configs/speed_test/bottomup_hrnet_w32_coco_512x512_dummy.py
```
若使用dtk22.04.1测试，需设置`export MIOPEN_FIND_MODE=1，export MIOPEN_USE_APPROXIMATE_PERFORMANCE=0`以下测试均相同.

#### 参数说明
configs/speed_test/bottomup_hrnet_w32_coco_512x512_dummy.py 中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659168500714](image/train/1659168500714.png)
#### 性能关注：time
### 多卡测试（单精度）
```python
./multi_test.sh configs/speed_test/bottomup_hrnet_w32_coco_512x512_dummy.py
```
### 单卡测试（半精度）
```python
./sing_test.sh configs/speed_test/bottomup_hrnet_w32_coco_512x512_fp16_dummy.py
```
### 多卡测试（半精度）
```python
./multi_test.sh configs/speed_test/bottomup_hrnet_w32_coco_512x512_fp16_dummy.py
```
## ResNet50-Top-Down测试
### 单卡测试（单精度）
```python
./sing_test.sh configs/speed_test/res50_coco_256x192_dummy.py
```
#### 参数说明
configs/speed_test/res50_coco_256x192_dummy.py 中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659169127556](image/train/1659169127556.png)
#### 性能关注：time
### 多卡测试（单精度）
```python
./multi_test.sh configs/speed_test/res50_coco_256x192_dummy.py
```
### 单卡测试（半精度）
```python
./sing_test.sh configs/speed_test/res50_coco_256x192_fp16_dummy.py
```
### 多卡测试（半精度）
```python
./multi_test.sh configs/speed_test/res50_coco_256x192_fp16_dummy.py
```
## HrNet-Top-Down测试
### 单卡测试（单精度）
```python
./sing_test.sh configs/speed_test/hrnet_w32_coco_256x192_dummy.py
```
#### 参数说明
configs/speed_test/hrnet_w32_coco_256x192_dummy.py 中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time
![1659169253165](image/train/1659169253165.png)
#### 性能关注：time
### 多卡测试（单精度）
```python
./multi_test.sh configs/speed_test/hrnet_w32_coco_256x192_dummy.py
```
### 单卡测试（半精度）
```python
./sing_test.sh configs/speed_test/hrnet_w32_coco_256x192_fp16_dummy.py
```
### 多卡测试（半精度）
```python
./multi_test.sh configs/speed_test/hrnet_w32_coco_256x192_fp16_dummy.py
```
