# MMsegmentation算例测试

## 测试前准备

使用cityscapes数据集.链接：https://pan.baidu.com/s/1kxqTJxoyqcIGTCPOMbzB_g  提取码：asie

### 环境部署

```python
yum install python3
yum install libquadmath
yum install numactl
yum install openmpi3
yum install glog
yum install lmdb-libs
yum install opencv-core
yum install opencv
yum install openblas-serial
pip3 install --upgrade pip
pip3 install opencv-python
```

### 安装python依赖包

```python
pip3 install torch-1.10.0a0+git2040069.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install torchvision-0.10.0a0+e04d001.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install mmcv_full-1.6.1+gitdebbc80.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
mmseg 安装：
cd mmsegmentation-0.29.1
pip3 install -e .
```

注：测试不同版本的dtk，需安装对应版本的库whl包，如果测试优化后的版本，需要设置export HIP_UPSAMPLE_OPTIMIZE=1

## PSPNet R50测试

### 单卡测试（单精度）

```python
./sing_test.sh configs/pspnet/pspnet_r50-d8_512x1024_40k_cityscapes.py
```

#### 参数说明

configs/_base_/datasets/cityscapes.py中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time

#### 性能关注：time

### 多卡测试（单精度）

#### 单机多卡训练

1.pytorch单机多卡训练

```python
./multi_test.sh configs/pspnet/pspnet_r50-d8_512x1024_40k_cityscapes.py
```

#### 多机多卡训练

1.pytorch多机多卡训练 在第一台机器上: NODES=2 NODE_RANK=0 PORT=12345 MASTER_ADDR=10.1.3.56 sh tools/dist_train.sh configs/pspnet/pspnet_r50-d8_512x1024_40k_cityscapes.py 4 在第二台机器上: NODES=2 NODE_RANK=1 PORT=12345 MASTER_ADDR=10.1.3.56 sh tools/dist_train.sh configs/pspnet/pspnet_r50-d8_512x1024_40k_cityscapes.py 4

### 半精度测试

修改configs文件，添加fp16 = dict(loss_scale=512.)，单机多卡和多机多卡测试与单精度测试方法相同。

### 其他模型测试

其他模型的测试步骤和pspnet_r50相同，只需修改对应的config文件即可，下面列出相关模型对应的config文件列表：

| 模型              | configs                                                      |
| ----------------- | ------------------------------------------------------------ |
| DeepLabV3 R50     | configs/deeplabv3/deeplabv3_r50-d8_512x1024_40k_cityscapes.py |
| FCN R50           | configs/fcn/fcn_r50-d8_512x1024_40k_cityscapes.py            |
| UperNet R50       | configs/upernet/upernet_r50_512x1024_40k_cityscapes.py       |
| DeepLabV3plus_R50 | configs/deeplabv3plus/deeplabv3plus_r50-d8_512x1024_40k_cityscapes.py |

