# 简介
本用例用于推荐领域NCF模型在ROCm平台PyTorch框架下的性能测试，已在rocm3.3 pytorch1.5版本下进行验证，测试流程如下。  
# 测试流程
## 数据处理
数据集下载地址  
[https://grouplens.org/datasets/movielens](https://grouplens.org/datasets/movielens)  
数据转换格式  
ml-1m

	python3 convert.py --path /path/to/{ml-1m_dir}/ratings.dat --output dataset/ml-1m  
ml-20m

	python3 convert.py --path /path/to/{ml-20m_dir}/ratings.csv --output dataset/ml-20m  
## 运行指令

	python3 -m torch.distributed.launch --nproc_per_node=<number_of_gpus> --use_env ncf.py --data <path_to_dataset> [other_parameters]  
单卡示例

	python3 -m torch.distributed.launch --nproc_per_node=1 --use_env ncf.py --data=./dataset/ml-1m --checkpoint_dir=/path/to/{check_save_dir}  
4卡示例

	python3 -m torch.distributed.launch --nproc_per_node=4 --use_env ncf.py --data=./dataset/ml-1m --checkpoint_dir=/path/to/{check_save_dir}

# 参考
[https://github.com/NVIDIA/DeepLearningExamples/tree/92829376a126286932496ff10d7cc655cb79af05/PyTorch/Recommendation/NCF](https://github.com/NVIDIA/DeepLearningExamples/tree/92829376a126286932496ff10d7cc655cb79af05/PyTorch/Recommendation/NCF)
