# MMaction2算例测试

## 测试前准备              

### 环境部署

```python
yum install python3
yum install libquadmath
yum install numactl
yum install openmpi3
yum install glog
yum install lmdb-libs
yum install opencv-core
yum install opencv
yum install openblas-serial
pip3 install --upgrade pip
pip3 install opencv-python
```

### 安装python依赖包

```python
pip3 install torch-1.10.0a0+git2040069.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install torchvision-0.10.0a0+e04d001.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install mmcv_full-1.6.1+gitdebbc80.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
mmaction2 安装：
cd mmaction2-0.24.1
pip3 install -e .
```

注：测试不同版本的dtk，需安装对应版本的库whl包

## ST-GCN测试
### 单精度测试

### 单卡测试（单精度）

```python
export ROCBLAS_ATOMICS_MOD=1
./sing_test.sh configs/skeleton/stgcn/stgcn_80e_ntu60_xsub_keypoint.py
```
#### 参数说明

configs/skeleton/stgcn/stgcn_80e_ntu60_xsub_keypoint.py 中batch_size=videos_per_gpu*卡数,性能计算方法：batch_size/time

#### 性能关注：time

### 多卡测试（单精度）
#### 单机多卡训练

1.pytorch单机多卡训练

```python
export ROCBLAS_ATOMICS_MOD=1
./tools/dist_train.sh configs/skeleton/stgcn/stgcn_80e_ntu60_xsub_keypoint.py $GPUS
```
#### 多机多卡训练

1.pytorch多机多卡训练
在第一台机器上:
NODES=2 NODE_RANK=0 PORT=12345 MASTER_ADDR=10.1.3.56 sh tools/dist_train.sh export ROCBLAS_ATOMICS_MOD=1 $GPUS
在第二台机器上:
NODES=2 NODE_RANK=1 PORT=12345 MASTER_ADDR=10.1.3.56 sh tools/dist_train.sh export ROCBLAS_ATOMICS_MOD=1 $GPUS

