DCU深度学习样例
=====




# 介绍
基于PyTorch和TensorFlow深度学习框架在各个领域的常用测试样例

# Compute Vision
## Classification

| 框架 | 版本 | DCU | 精度 | 多DCU | 支持网络 | 代码位置
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow   | v1.15 | Yes | FP32/FP16 | Yes | ResNet50/VGG/Inception/MobileNet | [classfication](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Classification) |
| PyTorch      | v1.5 | Yes | FP32/FP16 | Yes | ResNet50/VGG/Inception/MobileNet | [classfication](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/Compute-Vision/Classification) |
| MxNet      | v1.4 | Yes | FP32/FP16 | Yes | ResNet50/VGG/Inception/MobileNet | [classfication](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/MXNet/ComputeVision/Classification/mxnet-hip_port_v1.4.x) |
| PaddlePaddle | v1.8 |Yes | FP32/FP16 | Yes | - | - |
| TensorFlow   | v1.15 |Yes | FP32/FP16 | Yes | ResNet50 | [准确性验证](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Accuracy_Validation/ResNet50_Official) |
| PyTorch   | v1.5 | Yes | FP32/FP16 | Yes | ResNet50 | [准确性验证](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/Compute-Vision/Accuracy_Validation/ResNet50) |
| PaddlePaddle | v1.8 | Yes | FP32/FP16 | Yes | ResNet50 | [准确性验证] |

<br>

## Detection

| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow   | v1.14 | Yes | FP32/FP16 | Yes | [Faster-Rcnn](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Objection/FasterRcnn_SSD) |
| TensorFlow   | v1.15 | Yes | FP32/FP16 | Yes | [YOLO-V3](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Objection/YOLOv3) |
| TensorFlow   | v1.15 | Yes | FP32/FP16 | Yes | [Mask-Rcnn](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Objection/MaskRCNN) |
| TensorFlow   | v1.14 | Yes | FP32/FP16 | Yes | [SSD](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Objection/FasterRcnn_SSD) |
| PyTorch      | v1.5 | Yes | FP32 | Yes | [Faster-Rcnn](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/Compute-Vision/Objection/Faster-rcnn) |
| PyTorch   | v1.5 | Yes | FP32/FP16 | Yes | [YOLO-V3](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/Compute-Vision/Objection/YOLOv3) |
| PyTorch      | v1.5 | Yes | FP32/FP16 | Yes | [Mask-Rcnn](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/Compute-Vision/Objection/MaskRCNN/vision) |
| PyTorch      | v1.5 | Yes | FP32/FP16 | Yes | [SSD](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/Compute-Vision/Objection/ssd) |
| PaddlePaddle | v1.0 | Yes | FP32/FP16 | Yes | - |

<br>

## Segmentation

| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow      | v1.13 | Yes | FP32/FP16 | Yes | [UNet](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Segmentation/UNet_Industrial) |
| TensorFlow      | v1.13 | Yes | FP32/FP16 | Yes | [VNet](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/ComputeVision/Segmentation/VNet) |

<br>

# NLP

| 框架 | 版本 |DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow      | v1.15 | Yes | FP32/FP16 | Yes | [Bert](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/NLP/Bert) |
| TensorFlow      | v1.15 | Yes | FP32/FP16 | Yes | [Transformer](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/TensorFlow/NLP/Transformer_mlperf) |
| TensorFlow      | v1.0 | Yes | FP32/FP16 | Yes | [Transformer-XL] |
| PyTorch      | v1.0 | Yes | FP32/FP16 | Yes | [Bert](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/NLP/BERT) |
| PyTorch      | v1.5 | Yes | FP32/FP16 | Yes | [GNMT](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/NLP/gnmt) |
| PyTorch      | v1.0 | Yes | FP32/FP16 | Yes | [Transformer] |
| PyTorch      | v1.0 | Yes | FP32/FP16 | Yes | [GPT2] |

<br>

## Speech

| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| PyTorch      | v1.x | Yes | FP32/FP16 | Yes | [FastPitch] |
| PyTorch      | v1.x | Yes | FP32/FP16 | Yes | [Tacotron2] |

<br>

## Recommendation


| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow      | v1.x | Yes | FP32/FP16 | Yes | [NCF] |
| TensorFlow      | v1.x | Yes | FP32/FP16 | Yes | [VAE-CF] |
| TensorFlow      | v1.x | Yes | FP32/FP16 | Yes | [WideAndDeep] |
| PyTorch      | v1.5 | Yes | FP32/FP16 | Yes | [NCF](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/Recommendation/NCF) |
| PyTorch      | v1.x | Yes | FP32/FP16 | Yes | [DLRM] |


<br>

## NAS
| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| PyTorch     | v1.15 | Yes | FP32/FP16 | Yes | [Darts](http://10.0.100.3/dcutoolkit/deeplearing/dlexamples/-/tree/develop/PyTorch/NAS/Darts) |



<br>

