DCU深度学习样例
=====




# 介绍
基于PyTorch和TensorFlow深度学习框架在各个领域的常用测试样例

# Compute Vision
## Classification

| 框架 | 版本 | DCU | 精度 | 多DCU | 支持网络 | 代码位置
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow   | v1.15 | Yes | FP32/FP16 | Yes | ResNet50/VGG16/Inception-V3/MobileNet-V2 | [classfication](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow/ComputeVision/Classification) |
| TensorFlow   | v2.7 | Yes | FP32/FP16 | Yes | ResNet50/VGG16/Inception-V3 | [classfication](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow2x/Classification) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | ResNet50/Vgg16/Inception-V3/MobileNet-V2 | [classfication](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Compute-Vision/Accuracy_Validation/ResNet50) |

<br>

## Detection

| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow   | v2.7 | Yes | FP32/FP16 | Yes | [YOLO-V3](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow2x/ComputeVision/Detection/YOLOv3) |
| TensorFlow   | v2.7 | Yes | FP32/FP16 | Yes | [Mask-Rcnn](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow2x/ComputeVision/Detection/MaskRCNN) |
| TensorFlow   | v2.7 | Yes | FP32/FP16 | Yes | [SSD](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow2x/ComputeVision/Detection/SSD) |
| PyTorch      | v1.10 | Yes | FP32 | Yes | [Faster-Rcnn](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Compute-Vision/Objection/Faster-rcnn) |
| PyTorch   | v1.10 | Yes | FP32/FP16 | Yes | [YOLO-V3](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Compute-Vision/Objection/YOLOv3) |
| PyTorch   | v1.10 | Yes | FP32/FP16 | Yes | [YOLO-V5](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Compute-Vision/Objection/yolov5) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [Mask-Rcnn](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Compute-Vision/Objection/MaskRCNN/vision) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [SSD](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Compute-Vision/Objection/ssd) |


<br>

## Segmentation

| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow      | v2.7 | Yes | FP32/FP16 | Yes | [UNet](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow2x/ComputeVision/Segmentation/UNet) |
| TensorFlow      | v1.15 | Yes | FP32/FP16 | Yes | [VNet](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow/ComputeVision/Segmentation/VNet) |

<br>

# NLP

| 框架 | 版本 |DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| TensorFlow      | v1.15 | Yes | FP32/FP16 | Yes | [Bert](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow/NLP/Bert) |
| TensorFlow      | v2.7 | Yes | FP32/FP16 | Yes | [Bert](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow2x/NLP/BERT/official) |
| TensorFlow      | v1.15 | Yes | FP32/FP16 | Yes | [Transformer](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow/NLP/Transformer_mlperf) |
| TensorFlow      | v1.15 | Yes | FP32/FP16 | Yes | [Transformer-XL](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/TensorFlow/NLP/transformer-xl-master) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [Bert](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/NLP/BERT) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [GNMT](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/NLP/gnmt) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [Transformer](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/NLP/Transformer) |
| PyTorch      | v1.10 | Yes | FP16 | Yes | [Conformer](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/NLP/Conformer-main) |
| Deepspeed      | v0.6.3 | Yes | FP32/FP16 | Yes | [GPT2](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/Deepspeed) |
| PyTorch      | v1.10 | Yes | FP32 | Yes | [Vision_Transformer](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/NLP/Vision_Transformer) |


<br>

## Speech

| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [FastPitch](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Speech/FastPitch) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [Tacotron2](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Speech/Tacotron2) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [FastSpeech2](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Speech/FastSpeech2) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [ECAPA-TDNN](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/PyTorch/Speech/ECAPA-TDNN) |



<br>

## Recommendation

| 框架 | 版本 | DCU | 精度 | 多DCU | 代码位置 |
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [Ncf](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/add_Recommendation/PyTorch/Recommendation/NCF) |
| PyTorch      | v1.10 | Yes | FP32/FP16 | Yes | [Dlrm](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/add_Recommendation/PyTorch/Recommendation/dlrm) |
| Tensorflow      | v1.15 | Yes | FP32/FP16 | Yes | [Vae-Cf](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/add_Recommendation/PyTorch/Recommendation/VAE-CF) |
| Tensorflow      | v2.7 | Yes | FP32/FP16 | Yes | [WideAndDeep]() |


<br>

## OpenMMlab

| 类别 | 版本 | DCU | 精度 | 多DCU | 支持网络 | 代码位置
| :----------: | :----------: | :----------: | :----------: | :----------: | :----------: | :----------: |
| mmcls   | v0.12.0 | Yes | FP32/FP16 | Yes | ResNet18/ResNet34/ResNet50/ResNet152/Vgg11/SeresNet50/ResNext50/MobileNet-v2/ShuffleNet-v1/ShuffleNet-v2 | [mmclassfication](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/openmmlab_test/mmclassification-speed-benchmark) |
| mmdet   | v2.13.0 | Yes | FP32/FP16 | Yes | Faster-Rcnn/Mask-Rcnn/Double-Heads/Cascade-Mask-Rcnn/ResNest/Dcn/RetinaNet/VfNet/Ssd/Yolov3 | [mmdetection](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/openmmlab_test/mmdetection-speed_xinpian) |
| mmpose      | v0.16.0 | Yes | FP32/FP16 | Yes | ResNet50-Top-Down/ResNet50-Bottom-Up/HrNet-Top-Down | [mmpose](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/openmmlab_test/mmpose-speed_test) |
| mmseg      | v0.21.1 | Yes | FP32/FP16 | Yes | PspNet-R50/DeepLab-V3-R50/Fcn-R50/UperNet-R50/DeepLab-V3plus-R50 | [mmsegmentation](http://10.0.50.24/dcutoolkit/deeplearing/dlexamples_new/-/tree/main/openmmlab_test/mmsegmentation) |

