# 简介

  该测试用例用于TensorFlow分类模型性能测试，使用的数据集是imagenet。

# 运行

## 单卡
    
    export PYTHONPATH=/path/to/tensorflow/model:$PYTHONPATH
    export HIP_VISIBLE_DEVICES=0
    python3 models-master/official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=128 --num_gpus=1  --use_synthetic_data=false

## 单机多卡
    
    export PYTHONPATH=/path/to/tensorflow/model:$PYTHONPATH
    export HIP_VISIBLE_DEVICES=0,1,2,3
    python3 models-master/official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py --data_dir=/path/to/{ImageNet-tensorflow_data_dir} --model_dir=/path/to/{model_save_dir} --batch_size=512 --num_gpus=4  --use_synthetic_data=false

## 分布式多卡
    
    # sed指令只需要执行一次，添加支持多卡运行的代码
    sed -i '99 r configfile' models-master/official/vision/image_classification/resnet/resnet_ctl_imagenet_main.py
    
    export PYTHONPATH=/path/to/tensorflow/model:$PYTHONPATH
    mpirun -np ${num_gpu} --hostfile hostfile  -mca btl self,tcp  --bind-to none scripts-run/single_process.sh

### 测试说明

   多卡测试时需要修改部分代码，具体可参考https://tensorflow.google.cn/guide/migrate/multi_worker_cpu_gpu_training?hl=en
   
   hostfile格式参考：
     
     node1 slots=4
     node2 slots=4

   nodefile格式参考(与hostfile文件内保持一致，用于构造TF_CONFIG)：
     
     node1
     node2

   上面分布式多卡测试方法默认每节点4卡


# 参考资料
[https://github.com/tensorflow/benchmarks/tree/master/scripts/tf_cnn_benchmarks](https://github.com/tensorflow/benchmarks/tree/master/scripts/tf_cnn_benchmarks)
