# 简介

该测试用例用于TensorFlow分类模型性能测试，使用的数据集是imagenet。

* 该脚本支持horovod等分布式通信库方式

# 运行

## 单卡

    python3 ./benchmarks-master/scripts/tf_cnn_benchmarks/tf_cnn_benchmarks.py --data_format=NCHW --batch_size=128 --model=resnet50 --optimizer=momentum --variable_update=parameter_server  --print_training_accuracy=true  --nodistortions --num_gpus=1 --num_epochs=90 --weight_decay=1e-4 --data_dir=$data_dir_path   --use_fp16=False --data_name=imagenet --train_dir=$save_checkpoint_path

## 单机多卡

    python3 ./benchmarks-master/scripts/tf_cnn_benchmarks/tf_cnn_benchmarks.py --data_format=NCHW --batch_size=128 --model=resnet50 --optimizer=momentum --variable_update=parameter_server  --print_training_accuracy=true  --nodistortions --num_gpus=4 --num_epochs=90 --weight_decay=1e-4 --data_dir=$data_dir_path   --use_fp16=False --data_name=imagenet --train_dir=$save_checkpoint_path

## 分布式多卡

    mpirun -np ${num_gpu} --hostfile hostfile --bind-to none scripts-run/single_process.sh

hostfile格式参考：

    node1 slots=4
    node2 slots=4

# 参考资料
[https://github.com/tensorflow/benchmarks/tree/master/scripts/tf_cnn_benchmarks](https://github.com/tensorflow/benchmarks/tree/master/scripts/tf_cnn_benchmarks)
