# 简介
本用例用于测试自然语言处理领域transformer模型在ROCm平台tensorflow框架下的训练性能测试和算法验证测试，已在rocm3.3 tensorflow1.14版本下进行验证，测试流程如下。  
# 测试流程
## 安装工具

    pip3 install -r reqirement.txt -i http://pypi.douban.com/simple/ --trusted-host pypi.douban.com

    pip3 install --user --upgrade numpy  -i http://pypi.douban.com/simple/ --trusted-host pypi.douban.com   
## 数据处理  
训练和验证均使用WMT数据集，它是机器翻译领域最重要的数据集，运行如下指令可以生成用于测试的数据集。  

	python3 process_data.py --raw_dir /path/to/{raw_data_save_dir} --data_dir /path/to/{processed_data_save_dir}  
运行过程中会自动下载数据集，若网速慢无法下载，可手动下载到本地后上传到测试环境。  
## 运行指令
### 训练性能测试
单卡示例

	python3 transformer/transformer_main.py --random_seed=1 --data_dir=/path/to/{processed_data_save_dir} \  
		--model_dir=model_save --params=base --bleu_threshold 0.5 \  
		--bleu_source=newstest2014.en --bleu_ref=newstest2014.de --num_cpu_cores 24 --train_epochs 10 
多卡示例

	mpirun -np 2 python3 transformer/transformer_main_hvd.py --random_seed=1 --data_dir=/path/to/{processed_data_save_dir} \  
		--model_dir=model_save_hvd --params=base --bleu_threshold 0.5 \  
		--bleu_source=newstest2014.en --bleu_ref=newstest2014.de --num_cpu_cores 24 --train_epochs 10 
### 算法精度测试
计算模型的BLEU值，比较transformer算法在ROCm平台与NV平台的精度差异。  
运行示例  
	
	python3 transformer/translate.py --data_dir=/path/to/{processed_data_save_dir} --model_dir=/path/to/{model_save_dir} --params=base --file=newstest2014.en --file_out=translation.en  

	python3 transformer/compute_bleu.py --translation=translation.en --reference=newstest2014.de
# 参考
[https://github.com/mlcommons/training/tree/master/translation/tensorflow/transformer](https://github.com/mlcommons/training/tree/master/translation/tensorflow/transformer)






