#!/bin/bash
lrank=$OMPI_COMM_WORLD_LOCAL_RANK
comm_rank=$OMPI_COMM_WORLD_RANK
comm_size=$OMPI_COMM_WORLD_SIZE
export MASTER_ADDR=${1}
 
APP="python3 tools/train.py configs/resnet/resnet18_b32x8_imagenet.py --launcher mpi"
case ${lrank} in
[0])
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])

  numactl --cpunodebind=1 --membind=1 ${APP}
  ;;
[2])
  
  numactl --cpunodebind=2 --membind=2 ${APP}
  ;;
[3])
  
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
[4])
  
  numactl --cpunodebind=4 --membind=4 ${APP}
  ;;
esac
