# ECAPA-TDNN

该文件中包换对ECAPA-TDNN的非官方重新实现，这是Voxceleb2数据集中的说话人识别。

这个文件是基于[voxceleb_trainer](https://github.com/clovaai/voxceleb_trainer)修改的。

若想查看系统的具体结构，请在[第三章 ECAPA-SYSTEM](https://arxiv.org/pdf/2111.06671.pdf)中查看。

## 环境和依赖

源程序是在DTK22.04.1下的PyTorch1.10版本环境下进行的，使用的是python3.7版本。

### 环境搭建

```
conda create --name ECAPA-TDNN python=”3.7”

conda activate ECAPA-TDNN
```

### 安装依赖

安装dtk22.04.1环境下的torch包

```
pip3 install torch-1.10.0a0+git450cdd1.dtk22.4-cp37-cp37m-linux_x86_64.whl

pip3 install torchvision-0.10.0a0_dtk22.04_e17f5ea-cp37-cp37m-linux_x86_64.whl

pip3 install torchaudio-0.10.0-cp37-cp37m-linux_x86_64.whl
```

安装其他依赖包

```
pip3 install numpy

pip3 install scipy

pip3 install scikit-learn

pip3 install tqdm

pip3 install torchvision

pip3 install soundfile
```

## 数据准备

### 数据索引和预训练模型

从如下链接中将ECAPA-TDNN_data.zip文件解压至程序根目录，解压完成后根目录中应包括exps文件夹、train_cut.txt、train_list.txt和veri_test2.txt文件。

链接：https://pan.baidu.com/s/11TWAUSwROOjvKOcx36bqFQ 
提取码：uaia 

### 数据集下载

**VoxCeleb1**

**VoxCeleb2**

(voxceleb1：

链接：https://pan.baidu.com/s/1iASZ01mUny7udnjChJIbOg 

提取码：k7v0 

voxceleb2：

链接：https://pan.baidu.com/s/1tBbdq2tm5KX7znM89o9LHg 

提取码：6hzs)

**MUSAN**(https://www.openslr.org/resources/17/musan.tar.gz)

**RIR**(https://openslr.org/resources/28/rirs_noises.zip)

### 数据预处理

需要进行预处理的有voxceleb2和musan两个数据集，前者需要将m4a格式的音频转化为wav，而后者需要将其处理为musan_split，即拆分为可以更快进行随机读取的数据。其步骤可以参考[voxceleb_trainer](https://github.com/clovaai/voxceleb_trainer)中的Data preparation部分。

#### voxceleb2

所需的几个数据集中，VoxCeleb2中的数据需要进行转换，转换过程中需要提前安装ffmpeg，否则会导致转换失败。执行如下代码即可完成转换（注意：该转换时间至少需要24h以上）

```
python ./dataprep.py --save_path data --convert
```

#### musan

对于musan数据集的处理需要手动调用dataprep.py文件中的split_musan函数，从而完成转换。

## 模型训练

建立train_single.sh脚本

```
export HIP_VISIBLE_DEVICES=0

python3 trainECAPAModel.py --save_path exps/exp1
```

执行脚本即可进行训练

```
bash train_single.sh
```


## 参考

https://github.com/TaoRuijie/ECAPA-TDNN