#!/bin/bash
#export MIOPEN_DEBUG_DISABLE_FIND_DB=1
#export NCCL_SOCKET_IFNAME=ib0
#export HSA_USERPTR_FOR_PAGED_MEM=0
#export MIOPEN_DEBUG_DISABLE_FIND_DB=1
#export NCCL_SOCKET_IFNAME=eno1
export HSA_FORCE_FINE_GRAIN_PCIE=1
#source /public/software/apps/DeepLearning/PyTorch/pytorch-env.sh
export MIOPEN_FIND_MODE=3
#export MIOPEN_ENABLE_LOGGING_CMD=1
#export export ROCBLAS_LAYER=3
module unload compiler/rocm/2.9
#export MIOPEN_DEBUG_CONV_DIRECT_ASM_3X3U=0
#export MIOPEN_DEBUG_CONV_DIRECT_ASM_WRW3X3=0
echo "MIOPEN_FIND_MODE=$MIOPEN_FIND_MODE"
#module load apps/PyTorch/1.5.0a0/hpcx-2.4.1-gcc-7.3.1-rocm3.3
#source /public/home/aiss/Pytorch/env_rocm3.3_torch1.5.sh
lrank=$OMPI_COMM_WORLD_LOCAL_RANK
comm_rank=$OMPI_COMM_WORLD_RANK
comm_size=$OMPI_COMM_WORLD_SIZE

#下边是修改的


export HIP_VISIBLE_DEVICES=0,1,2,3
#HSA_FORCE_FINE_GRAIN_PCIE=1 numactl --cpunodebind=4,5,6,7 --membind=4,5,6,7

#module load compiler/rocm/3.9.1




APP="python3 run_squad_v4.py \
  --train_file  /public/home/hepj/data/sq1.1/train-v1.1.json \
  --predict_file  /public/home/hepj/data/sq1.1/dev-v1.1.json \
  --init_checkpoint  /public/home/hepj/model_source/pytorch_bert/model.ckpt-28252.pt \
  --vocab_file  /public/home/hepj/model_source/pytorch_bert/vocab.txt \
  --output_dir  /public/home/hepj/outdir/torch/SQuAD4 \
  --config_file  /public/home/hepj/model_source/pytorch_bert/bert_config.json \
  --json-summary  /public/home/hepj/outdir/torch/SQuAD4/results.json \
  --bert_model bert-large-uncased \
  --do_train \
  --do_predict \
  --do_eval \
  --train_batch_size  4 \
  --predict_batch_size 4 \
  --gpus_per_node  1 \
  --local_rank ${comm_rank} \
  --world_size 4 \
  --use_env  \
  --fp16 \
  --amp \
  --dist_url tcp://localhost:34567 \
  --eval_script /public/home/hepj/squad_eval/evaluate-v1.1.py
 "

case ${lrank} in
[0])
  export HIP_VISIBLE_DEVICES=0
  export UCX_NET_DEVICES=mlx5_0:1
  export UCX_IB_PCI_BW=mlx5_0:50Gbs
  echo numactl --cpunodebind=0 --membind=0 ${APP}
  numactl --cpunodebind=0 --membind=0 ${APP}

  #echo GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=0 --membind=0 ${APP} 
  #GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=1
  export UCX_NET_DEVICES=mlx5_1:1
  export UCX_IB_PCI_BW=mlx5_1:50Gbs
  echo numactl --cpunodebind=1 --membind=1 ${APP}
  numactl --cpunodebind=1 --membind=1 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=2
  export UCX_NET_DEVICES=mlx5_2:1
  export UCX_IB_PCI_BW=mlx5_2:50Gbs
  echo numactl --cpunodebind=2 --membind=2 ${APP} 
  numactl --cpunodebind=2 --membind=2 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=3
  export UCX_NET_DEVICES=mlx5_3:1
  export UCX_IB_PCI_BW=mlx5_3:50Gbs
  echo numactl --cpunodebind=3 --membind=3 ${APP}
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac
