# 简介

该测试用例可用于ResNet50/Vgg16等网络的性能测试及精度验证。

# 单卡测试（单精度）

## 运行

```
export HIP_VISIBLE_DEVICES=0
python3 main_acc.py --batch-size=64 --arch=resnet50 -j 6 --epochs=90 --save-path=/path/to/{save_model_dir} /path/to/{ImageNet_pytorch_data_dir}/
```

# 单卡测试（混合精度）

## 运行

```
export HIP_VISIBLE_DEVICES=0
python3 main_acc.py --batch-size=64 --arch=resnet50 -j 6 --epochs=90 --amp --opt-level O1 --loss-scale=dynamic --save-path=/path/to/{save_model_dir} /path/to/{ImageNet_pytorch_data_dir}/
```



# 多卡测试（单精度）

## 运行

```
#single_process.sh与main_acc.py在同级目录下
mpirun --allow-run-as-root --bind-to none -np 4 single_process.sh localhost resnet50 64
```

# 参数说明

```
--arch 设置要测试的网络，可以是 resnet50/vgg16/inception_v3/mobilenet_v2等
```

# inception_v3 测试说明

inception_v3测试时需要修改部分代码，具体可参考https://developer.hpccube.com/tool/ → AI生态包→ 技术文档 → 基于pytorch的DCU深度学习测试示例文档。

# 参考

https://github.com/pytorch/examples/tree/master/imagenet