# 简介
* YOLOv3, 目标检测网络的巅峰之作

# 测试流程

## 1）预训练模型/权重：  
<br>
使用预训练模型COCO的权重  

```
$ cd checkpoint  
$ wget https://github.com/YunYang1994/tensorflow-yolov3/releases/download/v1.0/yolov3_coco.tar.gz  

```
若网速较慢，可手动下载上传至计算环境 
``` 
$ tar -xvf yolov3_coco.tar.gz  
$ cd ..  
$ python3 convert_weight.py --train_from_coco  
```
可能会安装python包

## 2）训练：  
<br>
确认core/config.py中的参数batchsize、数据路径等 

* 单卡运行：  
`python3 train.py ` 
* 多卡运行：  
`mpirun -np 2 -H localhost:2 python3 train_hvd.py ` 
* 多机运行：  
`mpirun -np 4 -H b02r1n02:2,b02r1n04:2 python3 train_hvd.py `

## 3) 推理 
``` 
$ python3 evaluate.py  
$ cd mAP  
$ python3 main.py -na  
```

# 参考资料  
[https://github.com/YunYang1994/tensorflow-yolov3](https://github.com/YunYang1994/tensorflow-yolov3)