
# MMdetection算例测试

## 测试前准备

### 数据集准备

使用coco数据集,放在./data下.

### 环境部署

```python

yum install python3

yum install libquadmath

yum install numactl

yum install openmpi3

yum install glog

yum install lmdb-libs

yum install opencv-core

yum install opencv

yum install openblas-serial

pip3 install --upgrade pip

pip3 install opencv-python

```

### 安装python依赖包

```python
pip3 install torch-1.10.0a0+git2040069.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install torchvision-0.10.0a0+e04d001.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
pip3 install mmcv_full-1.6.1+gitdebbc80.dtk2210-cp37-cp37m-manylinux2014_x86_64.whl -i https://pypi.tuna.tsinghua.edu.cn/simple
mmcls 安装：
cd mmdetection-2.25.2
pip3 install -e .

```

注：测试不同版本的dtk，需安装对应版本的库whl包.

## Faster-Rcnn测试
### 单精度测试

### 单卡测试（单精度）

```python

./sing_test.sh configs/faster_rcnn/faster_rcnn_r50_fpn_1x_coco.py

```

#### 参数说明

configs/_base_/datasets/coco_detection.py 中batch_size=samples_per_gpu*卡数,性能计算方法：batch_size/time

#### 性能关注：time

### 多卡测试（单精度）

#### 单机多卡训练

1.pytorch单机多卡训练

```python

./tools/dist_train.sh configs/faster_rcnn/faster_rcnn_r50_fpn_1x_coco.py $GPUS

```

#### 多机多卡训练

1.pytorch多机多卡训练

在第一台机器上:

NODES=2 NODE_RANK=0 PORT=12345 MASTER_ADDR=10.1.3.56 sh tools/dist_train.sh configs/faster_rcnn/faster_rcnn_r50_fpn_1x_coco.py $GPUS

在第二台机器上:

NODES=2 NODE_RANK=1 PORT=12345 MASTER_ADDR=10.1.3.56 sh tools/dist_train.sh configs/faster_rcnn/faster_rcnn_r50_fpn_1x_coco.py $GPUS


### 半精度测试

修改configs文件，添加fp16 = dict(loss_scale=512.)，单机多卡和多机多卡测试与单精度测试方法相同。

### 其他模型测试

其他模型的测试步骤和Faster-Rcnn相同，只需修改对应的config文件即可，下面列出相关模型对应的config文件列表：

| 模型              | configs                                                      |
| ----------------- | ------------------------------------------------------------ |
| Mask-Rcnn         | configs/mask_rcnn/mask_rcnn_r50_caffe_fpn_mstrain-poly_1x_coco.py |
| Double-Heads      | configs/double_heads/dh_faster_rcnn_r50_fpn_1x_coco.py       |
| Cascade-Mask-Rcnn | configs/cascade_rcnn/cascade_mask_rcnn_r50_fpn_1x_coco.py    |
| ResNest           | configs/resnest/mask_rcnn_s50_fpn_syncbn-backbone+head_mstrain_1x_coco.py |
| Dcn               | configs/dcn/faster_rcnn_r50_fpn_mdpool_1x_coco.py            |
| RetinaNet         | configs/retinanet/retinanet_r50_caffe_fpn_1x_coco.py         |
| VfNet             | configs/vfnet/vfnet_r50_fpn_1x_coco.py                       |
| Ssd               | configs/ssd/ssd300_coco.py                                   |
| Yolov3            | configs/yolo/yolov3_d53_mstrain-416_273e_coco.py             |

