# 简介
本测试用例用于NLP bert模型在ROCm平台tensorflow框架下的fine-tune任务运行，测试流程如下
# 测试流程
## 安装工具包
这里提供调优后的python3&horovod工具，32卡分布式扩展性可以达到预期。  
注意安装完成后需设置环境变量。 
## 加载环境变量  

	export PATH={PYTHON3_install_dir}/bin:$PATH

	export LD_LIBRARY_PATH={PYTHON3_install_dir}/lib:$LD_LIBRARY_PATH
## 下载数据集  
GLUE_MNLI数据集  
[https://gluebenchmark.com/tasks](https://gluebenchmark.com/tasks)  
SQuAD 2.0数据集  
[https://rajpurkar.github.io/SQuAD-explorer/dataset/train-v2.0.json](https://rajpurkar.github.io/SQuAD-explorer/dataset/train-v2.0.json)   
[https://rajpurkar.github.io/SQuAD-explorer/dataset/dev-v2.0.json](https://rajpurkar.github.io/SQuAD-explorer/dataset/dev-v2.0.json)   
[https://worksheets.codalab.org/rest/bundles/0x6b567e1cf2e041ec80d7098f031c5c9e/contents/blob/](https://worksheets.codalab.org/rest/bundles/0x6b567e1cf2e041ec80d7098f031c5c9e/contents/blob/)   
## 下载预训练模型  
bert_base模型  
[uncased_L-12_H-768_A-12](https://storage.googleapis.com/bert_models/2018_10_18/uncased_L-12_H-768_A-12.zip)   
bert_large模型  
[uncased_L-24_H-1024_A-16](https://storage.googleapis.com/bert_models/2019_05_30/wwm_uncased_L-24_H-1024_A-16.zip)  
# 运行指令
## 训练
### 分类任务训练
以MNLI分类为例，单卡运行指令： 
```
python3 run_classifier.py \
--task_name=MNLI \
--do_train=true \
--do_eval=true \
--data_dir=/path/to/MNLI \
--vocab_file=/path/to/uncased_L-12_H-768_A-12/vocab.txt \
--bert_config_file=/path/to/uncased_L-12_H-768_A-12/bert_config.json \
--init_checkpoint=/path/to/uncased_L-12_H-768_A-12/bert_model.ckpt \
--max_seq_length=32 \
--train_batch_size=320 \
--learning_rate=2e-5 \
--num_train_epochs=3.0 \
--output_dir=/path/to/output  
```  
多卡运行指令： 
```
mpirun --allow-run-as-root -np 4 -H localhost:4 \
python3 run_classifier_hvd.py \
--task_name=MNLI \
--do_train=true \
--do_eval=true \
--data_dir=/path/to/MNLI \
--vocab_file=/path/to/uncased_L-12_H-768_A-12/vocab.txt \
--bert_config_file=/path/to/uncased_L-12_H-768_A-12/bert_config.json \
--init_checkpoint=/path/to/uncased_L-12_H-768_A-12/bert_model.ckpt \
--max_seq_length=32 \
--train_batch_size=320 \
--learning_rate=2e-5 \
--num_train_epochs=3.0 \
--output_dir=/path/to/output
```  
### 问答任务训练  
```
export BERT_ LARGE_DIR=/path/to/bert/uncased_L-12_H-768_A-12  
export SQUAD_DIR=/path/to/SQuAD 2.0  

python3 run_squad.py \
  --vocab_file=$BERT_LARGE_DIR/vocab.txt \
  --bert_config_file=$BERT_LARGE_DIR/bert_config.json \
  --init_checkpoint=$BERT_LARGE_DIR/bert_model.ckpt \
  --do_train=True \
  --train_file=$SQUAD_DIR/train-v2.0.json \
  --do_predict=True \
  --predict_file=$SQUAD_DIR/dev-v2.0.json \
  --train_batch_size=40 \
  --learning_rate=3e-5 \
  --num_train_epochs=2.0 \
  --max_seq_length=80 \
  --doc_stride=32 \
  --output_dir=gs://some_bucket/squad_large/ \
  --use_tpu=True \
  --tpu_name=$TPU_NAME \
  --version_2_with_negative=True
```
## 预测  
### 分类任务预测  
```
export BERT_BASE_DIR=/path/to/bert/uncased_L-12_H-768_A-12  
export GLUE_DIR=/path/to/MNLI  
export TRAINED_CLASSIFIER=/path/to/fine/tuned/classifier  

python run_classifier.py \
  --task_name=MNLI \
  --do_predict=true \
  --data_dir=$GLUE_DIR/MNLI \
  --vocab_file=$BERT_BASE_DIR/vocab.txt \
  --bert_config_file=$BERT_BASE_DIR/bert_config.json \
  --init_checkpoint=$TRAINED_CLASSIFIER \
  --max_seq_length=128 \
  --output_dir=/tmp/mrpc_output/
```
### 问答任务预测   
```
export BERT_ LARGE_DIR=/path/to/bert/uncased_L-12_H-768_A-12    
export SQUAD_DIR=/path/to/SQuAD 2.0    

python3 run_squad.py \
  --vocab_file=$BERT_LARGE_DIR/vocab.txt \
  --bert_config_file=$BERT_LARGE_DIR/bert_config.json \
  --init_checkpoint=$BERT_LARGE_DIR/bert_model.ckpt \
  --do_train=False \
  --train_file=$SQUAD_DIR/train-v2.0.json \
  --do_predict=True \
  --predict_file=$SQUAD_DIR/dev-v2.0.json \
  --train_batch_size=24 \
  --learning_rate=3e-5 \
  --num_train_epochs=2.0 \
  --max_seq_length=32 \
  --doc_stride=128 \
  --output_dir=gs://some_bucket/squad_large/ \
  --version_2_with_negative=True \
  --null_score_diff_threshold=$THRESH
```
# 参考
[https://github.com/google-research/bert](https://github.com/google-research/bert)
