# SSD（TensorFlow2.7）测试

## 测试前准备

### 数据集准备

训练所需的ssd_weights.h5和主干的权值可以在百度云下载。

链接: https://pan.baidu.com/s/1Ddk5UcZS5Dm4qechwGJDlA

提取码: 1k5d

VOC数据集下载地址如下，里面已经包括了训练集、测试集、验证集（与测试集一样），无需再次划分：

链接: https://pan.baidu.com/s/1YuBbBKxm2FGgTU5OfaeC5A  

提取码: uack 

### python依赖包

使用Conda配置TF2.7环境，环境中包括根据whl文件安装的Tensorflow2.7和Python3.6

构建TF2的支持文件requiresments.txt

使用命令：

```
pip3 install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/
```

requiresments.txt中包括：

```
# Python dependencies required for development

astor 

astunparse 

cached-property 

cachetools 

certifi 

charset-normalizer 

dataclasses 

devscripts

distro 

flatbuffers 

gast

google-auth 

google-auth-oauthlib

google-pasta 

grpcio 

h5py 

idna 

importlib-metadata 

keras 

Keras-Applications 

Keras-Preprocessing

libclang 

Markdown 

mock 

numpy

oauthlib 

opt-einsum

packaging

portpicker 

protobuf 

pyasn1

pyasn1-modules 

pyparsing 

requests 

requests-oauthlib 

rsa 

scikit-build 

scipy 

setuptools

six

tensorboard 

tensorboard-data-server 

tensorboard-plugin-wit 

tensorflow-estimator 

tensorflow-io-gcs-filesystem 

tensorflow-model-optimization 

termcolor 

tf-models-official 

typing-extensions

urllib3 

Werkzeug

wheel 

wrapt 

zipp 

horovod
```

### 环境变量设置

```
conda activate tensorflow2.7  
source /public/software/compiler/rocm/dtk-21.10.1/env.sh  
export LD_LIBRARY_PATH=/public/software/compiler/rocm/dtk-21.10.1/roctracer/lib/:$LD_LIBRARY_PATH  
export HSA_FORCE_FINE_GRAIN_PCIE=1  
export MIOPEN_FIND_MODE=3  
export HIP_VISIBLE_DEVICES=0 
```

## 单卡测试

```
source activate  
conda activate tensorflow2.7  
source /public/software/compiler/rocm/dtk-21.10.1/env.sh  
export LD_LIBRARY_PATH=/public/software/compiler/rocm/dtk-21.10.1/roctracer/lib/:$LD_LIBRARY_PATH  
export HSA_FORCE_FINE_GRAIN_PCIE=1  
export MIOPEN_FIND_MODE=3  
export HIP_VISIBLE_DEVICES=0  
cd /public/home/libodi/work1/ssd-tf2-master  
python3 train32.py --dtype=fp32
```

执行如下代码即可进行训练

```
python3 train32.py --dtype=fp32
```

使用ssd-tf2-master/voc_annotation.py自动生成训练集和验证集，其中训练集5717 张、验证集5823张。**具体为，修改voc_annotation.py里面的annotation_mode=2，运行voc_annotation.py生成根目录下的2007_train.txt和2007_val.txt。**

使用ssd-tf2-master/trian.py进行训练，train.py中有详细的参数配置选项，如batch_size、epoch数等。