# 简介
本用例用于图像分割VNet模型在ROCm平台的训练性能和推理性能的测试，已在rocm3.3 tensorflow1.1.5.0版本下进行验证。测试流程如下
# 测试流程
## 下载数据集
[medical segmentation decathlon(MSD)](http://medicaldecathlon.com/)  
## 安装工具包  
### 安装SimpleITK  
下载whl包  
下载地址[https://files.pythonhosted.org/packages/f8/d8/53338c34f71020725ffb3557846c80af96c29c03bc883551a2565aa68a7c/SimpleITK-1.2.4-cp36-cp36m-manylinux1_x86_64.whl](https://files.pythonhosted.org/packages/f8/d8/53338c34f71020725ffb3557846c80af96c29c03bc883551a2565aa68a7c/SimpleITK-1.2.4-cp36-cp36m-manylinux1_x86_64.whl)
## 运行指令  
### benchmark
单卡训练benchmark  
```
python3 examples/vnet_benchmark.py \
--data_dir /path/to/{MSD_Task04_Hippocampus_dir} \
--model_dir /path/to/{model_save_dir} \
--mode train \
--gpus 1 \
--batch_size 8 
```
4卡训练benchmark  
```
python3 examples/vnet_benchmark.py \
--data_dir /path/to/{MSD_Task04_Hippocampus_dir} \
--model_dir /path/to/{model_save_dir} \
--mode train \
--gpus 4 \
--batch_size 32
```
推理benchmark
```
python3 examples/vnet_benchmark.py \  
--data_dir /path/to/{MSD_Task04_Hippocampus_dir} \  
--model_dir /path/to/{model_save_dir} \ 
--mode predict \  
--gpus 1 \  
--batch_size 8  
```
### 训练示例
```
python3 examples/vnet_train.py \  
--data_dir /path/to/{MSD_Task04_Hippocampus_dir} \
--model_dir /path/to/{model_save_dir} \
--mode train \
--gpus 1 \
--batch_size 260 \
--epochs 1  
```
### 推理示例
```
python3 examples/vnet_predict.py \  
--data_dir /path/to/{MSD_Task04_Hippocampus_dir} \
--model_dir /path/to/{model_save_dir} \
--batch_size 4
```
# 参考
[https://github.com/NVIDIA/DeepLearningExamples/tree/master/TensorFlow/Segmentation/VNet](https://github.com/NVIDIA/DeepLearningExamples/tree/master/TensorFlow/Segmentation/VNet)



