

# YOLOV5算力测试

## 测试前准备

### 数据集

使用COCO2017数据集

### 环境搭建

建立python3.7的环境

```
conda create -n yolov5 python='3.7'

conda activate yolov5
```

安装python依赖包

```
pip3 install PyYAML>=5.3.1
pip3 install tqdm>=4.41.0
pip3 install opencv-python>=4.1.2
pip3 install pandas>=1.1.4
pip3 install requests>=2.23.0
pip3 install matplotlib>=3.2.2
pip3 install seaborn>=0.11.0
pip3 install tensorboard>=2.4.1
```

```
pip3 install torch-1.10.0a0+git450cdd1.dtk22.4-cp37-cp37m-linux_x86_64.whl -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

pip3 install torchvision-0.10.0a0_dtk22.04_300a8a4-cp37-cp37m-linux_x86_64.whl -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com

pip3 install pycocotools -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

## 训练

```
export HSA_FORCE_FINE_GRAIN_PCIE=1
export MIOPEN_FIND_MODE=3

python3 train.py --data data/coco.yaml --cfg models/yolov5x.yaml --weights weights/yolov5x.pt --device 0 --batch-size 32 --epochs 10
```

## 精度测试

```
python3 val.py --data data/coco-v5.yaml --weights runs/train/exp12/weights/best.pt --device 0
```

