# 介绍
本测试用例用于测试目标检测MaskRCNN模型在ROCm平台的性能，测试流程如下

# 测试流程
## 进入工作目录 
	cd references/detection  
## 数据集准备

COCO2017数据集

## 运行指令

### 单卡  
	export HIP_VISIBLE_DEVICES=0
	
	python3 train.py --dataset coco --model maskrcnn_resnet50_fpn --epochs 26 \
	     --lr-steps 16 22 --aspect-ratio-group-factor 3 \
	     --data-path /path/to/{COCO2017_data_dir}  
若报错Downloading: "https://download.pytorch.org/models/resnet50-19c8e357.pth" to .cache/torch/checkpoints/resnet50-19c8e357.pth失败，则需提前下载resnet50-19c8e357.pth，拷贝至.cache/torch/checkpoints/。  
### 多卡

	export HIP_VISIBLE_DEVICES=0,1,2,3
	export NGPUS=4
	export OMP_NUM_THREADS=1
	python3 -m torch.distributed.launch --nproc_per_node= ${NGPUS} --use_env train.py --dataset coco --model maskrcnn_resnet50_fpn --epochs 26 --lr-steps 16 22 --aspect-ratio-group-factor 3 --lr 0.005 --data-path /path/to/{COCO2017_data_dir} > train_2gpu_lr0.005.log 2>&1 &
注意：多卡运行时，学习率与卡数的对应关系为0.02/8*$NGPU，例如，lr_4gpu=0.01，lr_2gpu=0.005，lr_1gpu=0.0025。  

# 参考
[https://github.com/pytorch/vision/tree/master/references/detection](https://github.com/pytorch/vision/tree/master/references/detection)

