# 介绍  
本测试用例用于测试目标检测YOLOv3模型在ROCm平台PyTorch框架下的训练性能、推理性能和检测准确性，测试流程如下  
# 测试流程    
## 准备数据模型  
### 数据预处理  
使用本算例进行测试前，需要将coco数据转化为符合yolov3模型输入要求的格式，即将数据集中的annotation json文件转化为label。操作流程如下  
1、下载coco-to-yolo工具  
	git clone https://bitbucket.org/yymoto/coco-to-yolo.git  
	cd coco-to-yolo  
2、下载cocotoyolo.jar  
	wget http://commecica.com/wp-content/uploads/2018/07/cocotoyolo.jar  
3、转换格式  
（1） train json to label  
	java -jar cocotoyolo.jar "/path/to/{COCO2017_data_dir}/annotations/instances_train2017.json" "/path/to/{COCO2017_data_dir}/images/train2017" "all" "coco/yolo/"  
（2） val json to label  
	java -jar cocotoyolo.jar "/path/to/{COCO2017_data_dir}/annotations/instances_val2017.json" "/path/to/{COCO2017_data_dir}/images/val2017" "all" "coco/yolo/"  
4、 步骤3会生成coco/yolo/.txt文件，其中list.txt文件需重命名为train2017.txt和val2017.txt，其余txt文件为对应images/train2017&val2017图片的label。  
### 下载预训练模型  
下载链接  
[https://drive.google.com/drive/folders/1LezFG5g3BCW6iYaV89B2i64cqEUZD7e0](https://drive.google.com/drive/folders/1LezFG5g3BCW6iYaV89B2i64cqEUZD7e0)  
下载完成后放入weight目录
## 运行示例
### 训练  
#### 单卡  
	python3 train.py --cfg cfg/yolov3.cfg --weights weights/yolov3.pt --data data/coco2017.data --batch 32 --accum 2 --device 0  
运行前需确认coco2017.data中train2017.txt和val2017.txt中的数据路径  
#### 多卡
	python3 train.py --cfg cfg/yolov3.cfg --weights weights/yolov3.weights --data data/coco2017.data --batch 64 --accum 1 --device 0,1
### 推理  
	python3 test.py --cfg cfg/yolov3.cfg --weights weights/yolov3.pt --task benchmark --augment --device 1  
运行完成后会生成benchmark.txt和benchmark_yolov3.log文件，benchmark.txt文件记录了5种图片输入尺寸、2种iou阈值下的mAP@0.5...0.9和mAP@0.5值，benchmark_yolov3.log文件记录了每张图片的inference/NMS/total时间。  
### 检测  
使用detect.py文件进行测试，是yolov3模型的的实际应用，测试内容是指定一张图片，检测图片中物体，观察准确率。运行指令如下：
	python3 detect.py --cfg cfg/yolov3.cfg --weights weights/yolov3.pt  
运行完成后会生成带有检测框的图片。  
# 参考
[https://github.com/ultralytics/yolov3](https://github.com/ultralytics/yolov3)



