/******************************************************************************
 * ventoy_qt_stub.c
 *
 * Copyright (c) 2021, longpanda <admin@ventoy.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <linux/limits.h>
#include <pthread.h>

#include <ventoy_define.h>
#include <ventoy_json.h>
#include <ventoy_util.h>
#include <ventoy_disk.h>
#include <ventoy_http.h>

struct mg_context *
mg_start(const struct mg_callbacks *callbacks,
         void *user_data,
         const char **options)
{
    (void)callbacks;
    (void)user_data;
    (void)options;
    
    return NULL;
}

void mg_stop(struct mg_context *ctx)
{
    (void)ctx;
}

int mg_read(struct mg_connection *conn, void *buf, size_t len)
{
    (void)conn;
    (void)buf;
    (void)len;
    return 0;
}


const struct mg_request_info * mg_get_request_info(const struct mg_connection *conn)
{
    (void)conn;
    return NULL;
}

int mg_start_thread(mg_thread_func_t func, void *param)
{
	pthread_t thread_id;
	pthread_attr_t attr;
	int result;

	(void)pthread_attr_init(&attr);
	(void)pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

#if defined(USE_STACK_SIZE) && (USE_STACK_SIZE > 1)
	/* Compile-time option to control stack size,
	 * e.g. -DUSE_STACK_SIZE=16384 */
	(void)pthread_attr_setstacksize(&attr, USE_STACK_SIZE);
#endif /* defined(USE_STACK_SIZE) && (USE_STACK_SIZE > 1) */

	result = pthread_create(&thread_id, &attr, func, param);
	pthread_attr_destroy(&attr);

	return result;
}

int mg_printf(struct mg_connection *conn, const char *fmt, ...)
{
	(void)conn;
	(void)fmt;

	return 0;
}

static unsigned char window_icon_hexData[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52,
    0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x08, 0x06, 0x00, 0x00, 0x00, 0xAA, 0x69, 0x71,
    0xDE, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xAF, 0xC8, 0x37, 0x05, 0x8A,
    0xE9, 0x00, 0x00, 0x00, 0x20, 0x63, 0x48, 0x52, 0x4D, 0x00, 0x00, 0x7A, 0x26, 0x00, 0x00, 0x80,
    0x84, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x75, 0x30, 0x00, 0x00, 0xEA,
    0x60, 0x00, 0x00, 0x3A, 0x98, 0x00, 0x00, 0x17, 0x70, 0x9C, 0xBA, 0x51, 0x3C, 0x00, 0x00, 0x00,
    0x06, 0x62, 0x4B, 0x47, 0x44, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0xA0, 0xBD, 0xA7, 0x93, 0x00,
    0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE4, 0x03, 0x17, 0x04, 0x10, 0x05, 0xF6, 0xCE,
    0xA8, 0xC0, 0x00, 0x00, 0x1C, 0x68, 0x49, 0x44, 0x41, 0x54, 0x78, 0xDA, 0xCD, 0x9B, 0x79, 0x94,
    0x1D, 0x57, 0x7D, 0xE7, 0x3F, 0xF7, 0xDE, 0xAA, 0x7A, 0xFB, 0xEB, 0xD7, 0xBB, 0xA4, 0x56, 0xCB,
    0xDA, 0x6C, 0x59, 0xB6, 0x64, 0x83, 0x91, 0x17, 0xBC, 0xE1, 0x0D, 0x2F, 0x04, 0x1B, 0xB0, 0x43,
    0x3C, 0x40, 0x32, 0x43, 0x4E, 0x38, 0x19, 0x87, 0x43, 0x26, 0x03, 0x84, 0x98, 0xC9, 0x1C, 0x98,
    0x93, 0x70, 0x48, 0x72, 0x66, 0x58, 0x86, 0x81, 0x10, 0x0E, 0x06, 0xC6, 0x21, 0xC1, 0x83, 0xC1,
    0x36, 0x18, 0xDB, 0x6C, 0xC6, 0x60, 0xB0, 0x65, 0xBC, 0x1B, 0x5B, 0x8B, 0x6D, 0x59, 0x92, 0xB5,
    0x75, 0x5B, 0x52, 0xAB, 0xD7, 0xB7, 0x56, 0xD5, 0x5D, 0xE6, 0x8F, 0xAA, 0xF7, 0xF4, 0xBA, 0xD5,
    0xF2, 0xC2, 0x92, 0x99, 0x3A, 0xE7, 0xD7, 0xF5, 0x96, 0x7A, 0x75, 0x7F, 0xDF, 0xEF, 0x6F, 0xB9,
    0xBF, 0xFB, 0xBB, 0xD5, 0x82, 0xDF, 0xD1, 0x61, 0x8C, 0x45, 0x7D, 0x70, 0x9A, 0xFD, 0x7F, 0x57,
    0x61, 0x57, 0xD5, 0x31, 0x17, 0x39, 0x9C, 0x83, 0xD8, 0xC1, 0xEF, 0xAF, 0x1A, 0xE6, 0xC9, 0x23,
    0x13, 0x41, 0x55, 0xA3, 0xB4, 0x75, 0xD2, 0x93, 0xB8, 0xBC, 0x27, 0xCC, 0xA6, 0x7E, 0x19, 0xDD,
    0xBA, 0x5B, 0xBB, 0xBC, 0x07, 0x02, 0x28, 0x78, 0x82, 0xD1, 0xA2, 0x60, 0x6D, 0x59, 0x52, 0x8F,
    0x1D, 0xC5, 0x40, 0xFE, 0xD6, 0xF5, 0x14, 0xBF, 0xED, 0x1B, 0x3E, 0xBC, 0x67, 0x92, 0x3C, 0x9A,
    0x03, 0xAE, 0x44, 0x84, 0xC7, 0xDB, 0x56, 0xFA, 0x3C, 0x3A, 0x61, 0x7A, 0x26, 0x43, 0x96, 0x59,
    0xEB, 0xD6, 0x6A, 0xC7, 0x09, 0x16, 0x46, 0x05, 0xF4, 0x03, 0x79, 0x01, 0xBE, 0x03, 0x03, 0x34,
    0x81, 0x19, 0x21, 0x18, 0xF3, 0x05, 0x7B, 0x95, 0x10, 0xBB, 0x8A, 0x3E, 0xFB, 0xCE, 0x1B, 0x56,
    0xD3, 0x77, 0xEC, 0x89, 0x4D, 0x5E, 0x5A, 0xFA, 0x5C, 0x9D, 0x59, 0xF2, 0xAC, 0x72, 0x87, 0x39,
    0x71, 0xD5, 0x09, 0xFF, 0x7F, 0x11, 0xF0, 0xD3, 0x17, 0x67, 0xC9, 0xA1, 0x99, 0xB0, 0x39, 0xBE,
    0x19, 0xE6, 0x78, 0x5F, 0xA1, 0xD1, 0x17, 0x4B, 0xFF, 0x8C, 0x96, 0x11, 0x17, 0x59, 0xC7, 0xD9,
    0xC6, 0xB1, 0xCE, 0x41, 0x9F, 0x14, 0xE4, 0x3C, 0x89, 0x54, 0x02, 0x94, 0x48, 0x14, 0x70, 0x80,
    0x75, 0x60, 0x8E, 0x4A, 0x53, 0xC0, 0x9C, 0x27, 0xD8, 0x2D, 0x04, 0x8F, 0x67, 0x24, 0xF7, 0x07,
    0xE8, 0x47, 0x2E, 0x52, 0xDF, 0x19, 0xBF, 0x3B, 0xBC, 0xD6, 0x55, 0x44, 0xC8, 0x6E, 0xBF, 0xCC,
    0x99, 0xCD, 0x3D, 0x9C, 0xB2, 0x76, 0xD5, 0xFF, 0x5B, 0x02, 0x7E, 0xBE, 0x6B, 0x92, 0x3E, 0xD1,
    0x64, 0x8F, 0xA9, 0x70, 0xF5, 0x89, 0x05, 0xBE, 0xBF, 0xBB, 0xB1, 0xAA, 0xE5, 0xD4, 0xD5, 0x06,
    0xF1, 0x76, 0xE3, 0xC4, 0xEB, 0x8D, 0xA3, 0x22, 0x05, 0xE4, 0x3C, 0x41, 0xD1, 0x83, 0xAC, 0x27,
    0x08, 0x24, 0xC8, 0x14, 0x7C, 0x9B, 0x80, 0x36, 0x09, 0xDA, 0x41, 0x4B, 0x3B, 0xEA, 0x1A, 0x1A,
    0xDA, 0x61, 0x1C, 0x28, 0x41, 0xC3, 0x13, 0xEE, 0x79, 0x0F, 0xEE, 0xC9, 0x48, 0x73, 0xC7, 0x3A,
    0x6F, 0x66, 0xCB, 0x56, 0x3D, 0xA0, 0x4F, 0xC8, 0x69, 0xE6, 0xB4, 0xE4, 0xFC, 0x91, 0xEC, 0xBF,
    0x3D, 0x01, 0x8F, 0xFE, 0x6A, 0x2B, 0xBB, 0x4B, 0xEB, 0xA9, 0x98, 0x39, 0x76, 0xDB, 0x0A, 0xAB,
    0xBC, 0xEA, 0xB2, 0x3A, 0xFE, 0xBB, 0x0D, 0xF2, 0xDF, 0x6B, 0xCB, 0x29, 0x91, 0x75, 0x4A, 0x20,
    0xA8, 0x64, 0x04, 0xBD, 0x19, 0x41, 0xCE, 0x13, 0x2C, 0x16, 0xC1, 0xEE, 0x38, 0x8A, 0x38, 0x20,
    0x34, 0x30, 0x1B, 0x39, 0xA6, 0x42, 0x8B, 0x76, 0x90, 0x91, 0x10, 0x48, 0xF6, 0x79, 0xC2, 0xDD,
    0x9E, 0xF7, 0xF8, 0xCA, 0xE5, 0x37, 0xFB, 0xDB, 0xEF, 0x7B, 0x6F, 0xCC, 0x25, 0xA3, 0x9A, 0xA7,
    0x0E, 0x29, 0xCE, 0x58, 0x92, 0xFB, 0xB7, 0x21, 0xE0, 0x91, 0xFD, 0x73, 0x9C, 0x55, 0xAE, 0xF2,
    0x9D, 0xC3, 0x15, 0x86, 0x5D, 0x35, 0xFB, 0x12, 0xA5, 0xAB, 0x62, 0x27, 0x3F, 0xA8, 0x11, 0xE7,
    0xB6, 0x0C, 0x2A, 0x32, 0x8E, 0x9E, 0x40, 0xB0, 0xAC, 0xA0, 0x28, 0x78, 0xA2, 0x33, 0x8A, 0x7B,
    0x8D, 0xE3, 0xB4, 0x95, 0x0B, 0x8D, 0xE3, 0x50, 0xD3, 0x72, 0xA4, 0x65, 0x51, 0x42, 0x50, 0xF0,
    0xC0, 0x97, 0xE2, 0xD9, 0x8C, 0x74, 0xFF, 0x34, 0x98, 0x71, 0xDF, 0xD8, 0xDF, 0x10, 0x53, 0xEB,
    0x8A, 0x9A, 0x99, 0x58, 0x72, 0xD1, 0x8A, 0xFC, 0xEF, 0x96, 0x80, 0x7B, 0x76, 0xD6, 0xE9, 0x0F,
    0x0C, 0x4F, 0xCD, 0x78, 0xAC, 0xC8, 0x9B, 0xD1, 0xAA, 0x96, 0x1F, 0x8E, 0x91, 0xEF, 0x6D, 0x69,
    0xD7, 0x53, 0xD7, 0x09, 0xC4, 0xD1, 0xA2, 0x62, 0x28, 0x2F, 0x51, 0x42, 0xBC, 0x66, 0xD0, 0xC7,
    0x3F, 0x1C, 0xD3, 0xA1, 0x63, 0x6F, 0xD5, 0x10, 0x19, 0x47, 0xD1, 0x97, 0xE4, 0x7D, 0x11, 0x65,
    0x25, 0xDF, 0xCF, 0x7A, 0x7C, 0xE2, 0xA1, 0xC9, 0xE0, 0xC9, 0x2B, 0x07, 0x1A, 0xB4, 0x2C, 0xBC,
    0x79, 0x55, 0xF1, 0x77, 0x43, 0xC0, 0x3D, 0xCF, 0xCF, 0x90, 0x55, 0xF0, 0xAB, 0x39, 0x9F, 0x35,
    0x25, 0x77, 0x66, 0x4D, 0x8B, 0x7F, 0x88, 0x0C, 0x17, 0xD7, 0x62, 0x27, 0x1A, 0xDA, 0xE1, 0x2B,
    0xC1, 0xEA, 0x1E, 0x45, 0x7F, 0x4E, 0x26, 0xC0, 0x7F, 0x7B, 0xE8, 0x13, 0x65, 0x05, 0xD4, 0x63,
    0xC7, 0xAE, 0x19, 0x43, 0x2D, 0x76, 0xE4, 0x3D, 0x41, 0x29, 0x10, 0xE4, 0x3D, 0xB1, 0xBD, 0xA0,
    0xDC, 0xC7, 0x2E, 0xAC, 0x34, 0xEE, 0x7C, 0x6A, 0xCE, 0x37, 0xA1, 0x15, 0x5C, 0xBE, 0xA6, 0xFC,
    0xDB, 0x25, 0xE0, 0x7B, 0xCF, 0xCD, 0x90, 0x53, 0x8E, 0xB7, 0x6C, 0xAF, 0xF0, 0x8D, 0x75, 0xF5,
    0x37, 0x37, 0x0D, 0x9F, 0x69, 0x6A, 0xB7, 0xA1, 0x1A, 0x39, 0x5A, 0xC6, 0xE1, 0x29, 0xC1, 0x89,
    0x15, 0x8F, 0xFE, 0x9C, 0xE4, 0x77, 0x80, 0xBD, 0x73, 0x48, 0xA0, 0x16, 0x3B, 0x76, 0x4C, 0x6B,
    0xEA, 0xDA, 0x91, 0x51, 0x82, 0x1E, 0x5F, 0x52, 0x0A, 0xC4, 0xE1, 0x82, 0xE7, 0xFE, 0xE6, 0x94,
    0x5C, 0xFD, 0xA6, 0xFD, 0x61, 0x10, 0x87, 0x16, 0xAE, 0x5A, 0x5B, 0xF9, 0xED, 0x10, 0x70, 0xCF,
    0x73, 0x53, 0x64, 0x14, 0xFC, 0x7C, 0xAA, 0xC0, 0x86, 0x52, 0x78, 0x45, 0xC3, 0x88, 0x2F, 0xD4,
    0x22, 0xB7, 0x76, 0x2E, 0xB2, 0xC4, 0xD6, 0x81, 0x10, 0xAC, 0x2C, 0x7B, 0x8C, 0x94, 0xD4, 0xEF,
    0x08, 0xF6, 0x02, 0xA5, 0x05, 0x4C, 0xB5, 0x2C, 0x3B, 0xA6, 0x35, 0xDA, 0x3A, 0x7C, 0x29, 0x28,
    0x07, 0x92, 0xDE, 0xAC, 0x9C, 0x2B, 0x2A, 0xF7, 0xF1, 0x8D, 0xF9, 0xD9, 0x7F, 0xDC, 0xD3, 0xCA,
    0xE9, 0xD8, 0x49, 0xAE, 0x3C, 0xF1, 0xE5, 0x49, 0x78, 0x45, 0x02, 0x7E, 0xB6, 0x65, 0x0F, 0x85,
    0x5C, 0x86, 0x87, 0x66, 0x0A, 0x0C, 0xE7, 0x38, 0xAF, 0x1E, 0xBB, 0x9B, 0x6A, 0x91, 0x5D, 0x3F,
    0x1B, 0x3A, 0x62, 0xE7, 0x70, 0x40, 0x5F, 0xCE, 0x63, 0x5D, 0x9F, 0x8F, 0xFA, 0xED, 0x17, 0x6A,
    0xC7, 0x1C, 0xCE, 0xB9, 0x8E, 0xD2, 0x7B, 0xAB, 0x86, 0x03, 0x55, 0x8D, 0x00, 0x3C, 0x29, 0xE8,
    0xC9, 0x48, 0xFA, 0xB2, 0x72, 0xAA, 0xE8, 0xF1, 0x97, 0xEF, 0x28, 0xEF, 0xBB, 0xF9, 0xFE, 0xFA,
    0x52, 0x67, 0x10, 0x5C, 0xB6, 0xB6, 0xF7, 0xD7, 0x27, 0xC0, 0x39, 0xF8, 0xCA, 0xD3, 0x73, 0xF4,
    0xA8, 0xE8, 0xD4, 0xD9, 0xD8, 0xBB, 0xB9, 0x1A, 0xD9, 0x4D, 0x33, 0x2D, 0x43, 0xEC, 0x12, 0x37,
    0xF7, 0x94, 0xE0, 0xA4, 0xBE, 0x80, 0xBE, 0xAC, 0x24, 0x75, 0x86, 0xDF, 0x00, 0xDD, 0x02, 0x8D,
    0x1C, 0xB8, 0xF6, 0x24, 0xE2, 0xC0, 0x5A, 0x43, 0xD6, 0x4B, 0x94, 0x0A, 0x2D, 0x84, 0x56, 0xF2,
    0xEC, 0x64, 0x4C, 0x33, 0x76, 0x08, 0x01, 0x9E, 0x84, 0xDE, 0xAC, 0xA2, 0x3F, 0xA7, 0xC6, 0xCB,
    0x9E, 0xFD, 0x8F, 0x7B, 0x9B, 0xFE, 0xDD, 0x67, 0x97, 0xE6, 0x88, 0x1B, 0x35, 0x2E, 0x38, 0xED,
    0xC4, 0xD7, 0x4E, 0xC0, 0x37, 0x9F, 0x3C, 0x08, 0x52, 0x92, 0x51, 0xF4, 0x1F, 0x89, 0xBC, 0x2F,
    0x57, 0x43, 0x7B, 0xED, 0x54, 0xD3, 0x10, 0xA6, 0x48, 0x9D, 0x80, 0xBE, 0xAC, 0xE2, 0xA4, 0xBE,
    0x00, 0x29, 0x39, 0xFE, 0xA4, 0xFE, 0x5A, 0x80, 0x2F, 0x76, 0x0F, 0x07, 0xD6, 0x6A, 0x7A, 0x02,
    0x38, 0x7D, 0xB8, 0x40, 0x64, 0x0C, 0x4F, 0xBD, 0x54, 0x25, 0x72, 0x1E, 0xFB, 0xEB, 0x30, 0x56,
    0x35, 0x9D, 0xCB, 0x7D, 0x29, 0x18, 0xC8, 0x4B, 0x06, 0x72, 0xEA, 0xE9, 0x5E, 0xCF, 0xFC, 0x61,
    0x9D, 0xCC, 0xD6, 0xEB, 0x4F, 0x2E, 0x1C, 0xD7, 0x32, 0xC7, 0x55, 0xF5, 0xAE, 0x87, 0xB6, 0x60,
    0x72, 0x15, 0xCE, 0x29, 0x4F, 0xC9, 0x7B, 0xA6, 0x47, 0x6E, 0x9C, 0x0D, 0xED, 0xDF, 0x4E, 0x36,
    0xB4, 0xD7, 0xD0, 0xC9, 0xAF, 0x84, 0x4C, 0x7E, 0xBA, 0xB2, 0x12, 0xB0, 0xA4, 0xE8, 0xFD, 0x06,
    0x66, 0xEF, 0xC2, 0xED, 0x1C, 0xCE, 0x5A, 0x04, 0x0E, 0x87, 0x40, 0xC8, 0x34, 0xA1, 0x9A, 0x98,
    0xC1, 0xBC, 0xE4, 0x75, 0x4B, 0x0B, 0xE4, 0x14, 0x78, 0x4A, 0xB1, 0x7F, 0xA6, 0xC9, 0xD3, 0x2F,
    0x55, 0x99, 0x8C, 0x3C, 0x76, 0xCC, 0x58, 0x8C, 0x13, 0x1D, 0x40, 0x19, 0x4F, 0xB0, 0xA4, 0xE0,
    0x31, 0x90, 0x93, 0xB7, 0x0C, 0xFB, 0xD1, 0x0D, 0x4D, 0x2B, 0xAB, 0x9E, 0x89, 0xB8, 0x72, 0xE3,
    0xC8, 0x31, 0xE3, 0x1E, 0x37, 0x6A, 0xDF, 0xAA, 0x7F, 0xCA, 0x78, 0x5C, 0xE0, 0x47, 0x53, 0x43,
    0x6F, 0xAC, 0x85, 0xF6, 0xFD, 0xD3, 0xF5, 0xD8, 0xAB, 0xB6, 0x34, 0xDA, 0x18, 0x8C, 0xB5, 0x68,
    0x63, 0xC1, 0x39, 0x32, 0x0A, 0xB4, 0x71, 0xC4, 0xDA, 0xFE, 0x46, 0x12, 0x45, 0x31, 0x26, 0x0E,
    0x59, 0x5E, 0x70, 0x9C, 0x36, 0xE8, 0x51, 0x10, 0x21, 0xAD, 0x56, 0x83, 0x28, 0x6C, 0xB2, 0xB4,
    0x20, 0xD8, 0xB4, 0xAC, 0x40, 0xC9, 0x97, 0x6C, 0xDD, 0x77, 0x80, 0x7D, 0x13, 0x47, 0x58, 0x51,
    0xC9, 0xB1, 0x7E, 0x30, 0x4F, 0xC6, 0x85, 0x48, 0x13, 0xA1, 0xB5, 0xC6, 0x18, 0x83, 0x36, 0x86,
    0x46, 0xA8, 0x99, 0xA8, 0x45, 0xCC, 0xB6, 0xEC, 0x3B, 0x26, 0x63, 0x75, 0xFD, 0x77, 0xF4, 0x00,
    0x81, 0x6D, 0xBD, 0x7A, 0x0F, 0xF8, 0xC1, 0x63, 0xDB, 0x99, 0xB2, 0x25, 0xF2, 0x52, 0x17, 0xC7,
    0xE3, 0xDC, 0x57, 0x26, 0x6B, 0xFA, 0xFA, 0x89, 0xBA, 0x26, 0xC6, 0x21, 0xA4, 0x44, 0xC8, 0xA4,
    0xC0, 0xC9, 0xF9, 0x92, 0x93, 0x07, 0x32, 0x04, 0xF2, 0x37, 0x5B, 0x52, 0x58, 0x6B, 0xC8, 0x49,
    0xCD, 0xE9, 0x4B, 0x72, 0xAC, 0xEA, 0xCB, 0xE3, 0x49, 0xC1, 0x74, 0x23, 0xE2, 0xA9, 0x03, 0xD3,
    0x14, 0x32, 0x3E, 0xA7, 0x8F, 0x54, 0x08, 0x54, 0xB2, 0x72, 0x98, 0x6B, 0xB6, 0x70, 0xCE, 0x51,
    0x29, 0xE4, 0x70, 0x08, 0xB6, 0x1F, 0x9C, 0xE5, 0xB6, 0x2D, 0x87, 0x99, 0x8C, 0x33, 0x48, 0xCF,
    0x4F, 0x6D, 0xEA, 0xF0, 0x84, 0x60, 0xB0, 0xE0, 0x31, 0x52, 0xF2, 0x7F, 0x35, 0xE0, 0xC7, 0xD7,
    0xC5, 0x4E, 0xEE, 0x56, 0x71, 0x9D, 0xB7, 0x6F, 0x5A, 0xFD, 0xCA, 0x1E, 0x30, 0x68, 0x27, 0x19,
    0x0B, 0xB3, 0x4C, 0x84, 0xEA, 0xD2, 0x6A, 0x53, 0xBF, 0x65, 0xAA, 0x1E, 0xD2, 0x8C, 0x35, 0xDA,
    0xD8, 0x84, 0x65, 0x9D, 0x88, 0xB3, 0x16, 0x63, 0x1D, 0x91, 0xB1, 0xBF, 0xB6, 0xB4, 0xA2, 0x88,
    0x2C, 0x11, 0x67, 0x2E, 0xCD, 0xB1, 0xBA, 0x37, 0x07, 0xCE, 0x11, 0x6B, 0x43, 0x29, 0x50, 0x9C,
    0x73, 0x42, 0x1F, 0xA7, 0x2D, 0x2D, 0xA3, 0x70, 0x98, 0x74, 0xEC, 0x42, 0xE0, 0x53, 0xCA, 0x66,
    0x98, 0xAB, 0x37, 0xA9, 0x37, 0x5B, 0x9C, 0x3C, 0x54, 0xE2, 0xCC, 0x65, 0x79, 0x6C, 0x73, 0x96,
    0x38, 0x0C, 0xD1, 0x5A, 0xA3, 0xB5, 0x25, 0x8C, 0x0D, 0x93, 0xF5, 0x88, 0x99, 0xA6, 0x3E, 0xBD,
    0xAA, 0xE5, 0xBB, 0xAF, 0x7D, 0xF6, 0x1A, 0xA1, 0xCC, 0xB1, 0x5E, 0x70, 0x8C, 0xE9, 0xA6, 0x1B,
    0x31, 0xF7, 0x3E, 0x77, 0x84, 0xDE, 0x9C, 0x2A, 0x6E, 0x3B, 0x14, 0x7E, 0xFD, 0xE0, 0x5C, 0xF4,
    0x8E, 0x89, 0x5A, 0x8C, 0x41, 0x20, 0x94, 0x48, 0x62, 0x5F, 0x08, 0x1C, 0x82, 0x52, 0x46, 0x72,
    0x62, 0x7F, 0x8E, 0x5F, 0xCF, 0x01, 0x1C, 0xC6, 0x68, 0x7A, 0x7C, 0xC3, 0x79, 0x2B, 0x4A, 0x8C,
    0xF4, 0xE4, 0xB0, 0xCE, 0xE1, 0x52, 0xE9, 0x56, 0x31, 0x36, 0x1A, 0x29, 0x25, 0x9E, 0x94, 0x38,
    0xE7, 0x90, 0x52, 0x72, 0x60, 0x72, 0x8A, 0x17, 0xC6, 0x0E, 0x72, 0xEE, 0x29, 0xEB, 0x90, 0x42,
    0xF0, 0xBD, 0xAD, 0xE3, 0xDC, 0xFF, 0x62, 0x1D, 0x82, 0x22, 0x88, 0xA4, 0x1E, 0x51, 0x02, 0x06,
    0x0B, 0x3E, 0x2B, 0x2B, 0xC1, 0xF6, 0x01, 0x3F, 0xBE, 0x26, 0x76, 0x62, 0x97, 0x98, 0x1D, 0xE3,
    0x0F, 0x2E, 0x3D, 0xFB, 0xF8, 0x1E, 0xD0, 0x9B, 0xBF, 0x86, 0xC3, 0x35, 0xCD, 0x4B, 0x35, 0x73,
    0x66, 0xB5, 0x19, 0x5F, 0x38, 0x53, 0x0D, 0x09, 0x23, 0xDD, 0xB1, 0xBA, 0xD6, 0x36, 0x15, 0x43,
    0x14, 0x1B, 0xC2, 0x58, 0x13, 0xC5, 0xE6, 0x35, 0x8A, 0xA6, 0x15, 0x86, 0xE4, 0x08, 0x39, 0x67,
    0x24, 0xCF, 0xD2, 0x72, 0x06, 0x6D, 0x0C, 0xD6, 0xDA, 0x8E, 0x98, 0xF4, 0xBD, 0xB3, 0x06, 0x09,
    0x34, 0x5A, 0x2D, 0x9A, 0x61, 0x88, 0x73, 0x0E, 0xA3, 0x35, 0x4B, 0x2A, 0x3D, 0xAC, 0x18, 0x1A,
    0x24, 0xD6, 0x1A, 0xE1, 0x2C, 0x67, 0x8E, 0x56, 0x28, 0xAA, 0x98, 0x28, 0x6C, 0xA5, 0x5E, 0x60,
    0x08, 0x63, 0xC3, 0x54, 0x3D, 0x64, 0xBA, 0x19, 0xAF, 0x6B, 0x38, 0xEF, 0xF7, 0x0E, 0xAC, 0x18,
    0x81, 0xB0, 0x3E, 0x0F, 0xEF, 0x31, 0xA5, 0xDB, 0xE3, 0x7B, 0x9F, 0xE0, 0x6D, 0xA7, 0x0D, 0xCA,
    0x5F, 0xBC, 0x30, 0xF5, 0x81, 0xC3, 0x33, 0xAD, 0x4B, 0x27, 0x6B, 0x11, 0xB1, 0x4D, 0x0A, 0x1E,
    0xE7, 0x1C, 0xB6, 0x2D, 0xD6, 0x82, 0x75, 0x94, 0x32, 0x49, 0xCC, 0x69, 0x6B, 0x31, 0xAF, 0x52,
    0xE2, 0x58, 0x93, 0x17, 0x11, 0xE7, 0x9F, 0x50, 0x62, 0xB4, 0x92, 0xEF, 0x58, 0xBE, 0x9B, 0x80,
    0xB6, 0x27, 0xB4, 0xBF, 0x53, 0x42, 0xD2, 0x88, 0x22, 0xAC, 0x73, 0x28, 0x29, 0xB1, 0xC6, 0xD0,
    0x57, 0xCA, 0x03, 0x82, 0x5D, 0x07, 0x8F, 0xD0, 0x88, 0x2D, 0x4F, 0xEE, 0x9D, 0xA2, 0x6E, 0x14,
    0x4E, 0x48, 0xAC, 0x75, 0x29, 0x91, 0x16, 0x4F, 0x08, 0x59, 0x0C, 0x84, 0xBF, 0x7C, 0xF2, 0xC0,
    0x5D, 0x3A, 0xD7, 0xD7, 0x3A, 0xE3, 0xC4, 0xE5, 0xDC, 0xF7, 0x93, 0x9F, 0x00, 0x30, 0x6F, 0xFE,
    0xAA, 0xB6, 0x34, 0x77, 0x3E, 0x7D, 0x88, 0x83, 0x73, 0xE1, 0x92, 0x5A, 0x23, 0xBA, 0x64, 0xA6,
    0x16, 0xD2, 0x0A, 0x63, 0x9C, 0x92, 0x08, 0x27, 0x3B, 0x09, 0xB0, 0x3D, 0xA7, 0x5A, 0x63, 0xA9,
    0xB5, 0x62, 0x8A, 0x19, 0x85, 0x7B, 0x95, 0xC5, 0xBF, 0xB3, 0x86, 0x9C, 0x88, 0x79, 0xE3, 0xCA,
    0x32, 0x2B, 0x2A, 0x39, 0x8C, 0xB5, 0xC9, 0xE7, 0x29, 0x01, 0xC7, 0x86, 0x40, 0x5A, 0xFD, 0x09,
    0x41, 0xDE, 0x0F, 0x68, 0xE9, 0x98, 0x50, 0x08, 0x02, 0x25, 0xA9, 0xB7, 0x22, 0xB6, 0x1F, 0x38,
    0x48, 0x23, 0x76, 0x6C, 0xDE, 0x35, 0xC9, 0x44, 0xCD, 0x21, 0xB2, 0x60, 0xB5, 0x49, 0xA2, 0xDB,
    0x81, 0xC1, 0x31, 0x5D, 0x83, 0x5A, 0x5E, 0xBD, 0x3E, 0xEF, 0xAB, 0x0D, 0xDA, 0x8A, 0x07, 0x97,
    0xAE, 0xDF, 0xD4, 0xB9, 0xF7, 0x3C, 0x02, 0x4A, 0xD9, 0xA5, 0x7C, 0xFE, 0xBE, 0x47, 0x30, 0xC6,
    0x9E, 0x36, 0x5B, 0x0F, 0xD7, 0xD4, 0x1A, 0x21, 0x51, 0x6C, 0x91, 0x4E, 0x21, 0x9C, 0x03, 0xE9,
    0xD2, 0xF9, 0xBF, 0xDD, 0xC7, 0x11, 0xCC, 0xD4, 0x05, 0x81, 0x08, 0x5E, 0xD5, 0xE2, 0xC7, 0x59,
    0x43, 0x40, 0xC4, 0xD9, 0xAB, 0x4B, 0xAC, 0xEE, 0xCF, 0x77, 0x80, 0xB5, 0xDD, 0x5F, 0x00, 0xDA,
    0x18, 0x62, 0xAD, 0xF1, 0x3D, 0x6F, 0x1E, 0x78, 0x21, 0x04, 0xCE, 0x19, 0x7C, 0x21, 0xF0, 0x94,
    0x62, 0xA6, 0xD1, 0xE4, 0xC1, 0x67, 0x77, 0xD3, 0x34, 0x8A, 0xC7, 0xF6, 0xCE, 0xF2, 0x52, 0x1D,
    0xBC, 0x6C, 0x19, 0x61, 0x00, 0x6B, 0x8E, 0xA6, 0x37, 0xE7, 0xA8, 0x3A, 0xCB, 0x6C, 0xC3, 0xEF,
    0xAB, 0x54, 0x32, 0xE7, 0xE9, 0x33, 0x56, 0x3E, 0x68, 0x6F, 0x7F, 0x72, 0x71, 0x02, 0x76, 0x1E,
    0xDE, 0xC3, 0xDA, 0xB5, 0x9F, 0xE6, 0x33, 0xDF, 0x7E, 0xD7, 0x59, 0xD5, 0x7A, 0x58, 0x6A, 0x34,
    0x23, 0x34, 0x02, 0x89, 0x43, 0x38, 0x09, 0x52, 0x22, 0x84, 0x9C, 0xD7, 0xE0, 0x98, 0xAE, 0x59,
    0x8A, 0xBE, 0x40, 0xBD, 0x42, 0x26, 0x74, 0xD6, 0xA2, 0x6C, 0xC4, 0xA6, 0x55, 0x45, 0x4E, 0x19,
    0x2E, 0xE2, 0xAC, 0xE5, 0x70, 0xB5, 0xCE, 0xC1, 0xA9, 0x19, 0x96, 0x0F, 0xF6, 0x91, 0xF5, 0x3C,
    0xF6, 0x1F, 0x99, 0x62, 0xC7, 0xD8, 0x21, 0xF2, 0x19, 0x9F, 0xB3, 0xD7, 0xAD, 0x86, 0x2E, 0xF0,
    0x6D, 0x32, 0xA4, 0x94, 0x60, 0x0C, 0xB3, 0xF5, 0x26, 0xFB, 0xA7, 0x1A, 0xEC, 0x98, 0x74, 0x1C,
    0x6A, 0x2A, 0x94, 0x9F, 0xC7, 0x38, 0x0F, 0x8C, 0x65, 0xDE, 0x5A, 0xD4, 0x39, 0x9A, 0x06, 0x66,
    0x1A, 0xA1, 0x18, 0xCA, 0x8B, 0xB3, 0x46, 0x1E, 0xFE, 0x65, 0xBE, 0xB6, 0x6C, 0x6D, 0x63, 0xD1,
    0x24, 0xB8, 0xEB, 0x50, 0x95, 0xDD, 0xBB, 0x3F, 0x9C, 0x0B, 0xC3, 0xF8, 0xB4, 0x6A, 0xAD, 0x45,
    0x2B, 0x8C, 0x3A, 0x09, 0x25, 0x8E, 0x0D, 0x3A, 0xD6, 0xC9, 0xFB, 0x38, 0x11, 0x13, 0x6B, 0xAA,
    0x8D, 0x88, 0xC9, 0x6A, 0x8B, 0x28, 0xD6, 0x84, 0xD1, 0xF1, 0x24, 0x26, 0x6C, 0x35, 0xD8, 0x30,
    0xE4, 0xF3, 0xFA, 0x91, 0x12, 0xCE, 0x59, 0xB4, 0xB5, 0xFC, 0xEC, 0x99, 0xE7, 0xF8, 0x97, 0xFB,
    0x1F, 0xE7, 0xB1, 0x1D, 0xFB, 0x88, 0xB4, 0xE6, 0xBE, 0x67, 0x76, 0x72, 0xFF, 0x73, 0x63, 0x84,
    0x5A, 0xE0, 0x8C, 0xC1, 0xA6, 0x9E, 0x91, 0xE8, 0xA0, 0x3B, 0x7A, 0x5A, 0x6B, 0x29, 0xE7, 0x72,
    0x28, 0x95, 0xE1, 0x70, 0x55, 0x63, 0x45, 0x06, 0xE3, 0x64, 0x92, 0x9C, 0xDB, 0x7A, 0xB6, 0x45,
    0x27, 0x3A, 0xCC, 0xD5, 0x43, 0x42, 0xED, 0x4E, 0xCE, 0x0D, 0xAD, 0xEE, 0x0F, 0xCA, 0x83, 0x8B,
    0x7B, 0xC0, 0xBE, 0x23, 0x75, 0xE6, 0x9A, 0x71, 0xB9, 0xDE, 0x8C, 0x56, 0xD7, 0x9B, 0x11, 0x51,
    0xAC, 0xC1, 0x3A, 0xA4, 0x73, 0x08, 0xA5, 0x40, 0x0A, 0x84, 0xB4, 0x2C, 0x9C, 0x3D, 0x27, 0xE6,
    0x42, 0x3C, 0x01, 0xFE, 0x22, 0xCB, 0x41, 0xE7, 0x1C, 0x56, 0x87, 0x6C, 0x18, 0xF6, 0x39, 0x6F,
    0x55, 0x05, 0x81, 0xC3, 0x68, 0x8B, 0x13, 0x82, 0x6C, 0x90, 0x65, 0xC3, 0xAA, 0x13, 0x58, 0xBD,
    0x64, 0x80, 0x83, 0x33, 0x55, 0x7C, 0x3F, 0xE0, 0xCC, 0xB5, 0x2B, 0x58, 0xD6, 0x57, 0xC6, 0xA4,
    0x6E, 0xEC, 0x52, 0xE0, 0x5E, 0x1A, 0x12, 0x52, 0x0A, 0x0E, 0x4C, 0x4E, 0xF3, 0xC4, 0xCE, 0xFD,
    0xBC, 0xFE, 0x84, 0x11, 0x9E, 0x3A, 0xD0, 0xE0, 0x70, 0x2B, 0x46, 0xFA, 0x92, 0x45, 0xEB, 0xBA,
    0x34, 0xA7, 0xD4, 0x9A, 0x50, 0x6F, 0xC5, 0x4B, 0xAC, 0x63, 0xD4, 0x58, 0xB7, 0x3F, 0xD2, 0x86,
    0xC0, 0x53, 0xF3, 0x09, 0x68, 0x45, 0x31, 0x51, 0x20, 0x07, 0xEA, 0xAD, 0x78, 0xB8, 0xD1, 0x8C,
    0x88, 0x63, 0x8D, 0x74, 0x0E, 0x9B, 0xDE, 0xA8, 0x93, 0x04, 0x17, 0x0C, 0xA4, 0xB5, 0xE1, 0xB0,
    0x70, 0x0C, 0x14, 0x03, 0x04, 0xDD, 0x6D, 0x30, 0x87, 0xD1, 0x11, 0xAB, 0x7A, 0x04, 0x97, 0xAC,
    0xED, 0xC5, 0x17, 0x0E, 0xAD, 0x93, 0xE5, 0xAB, 0x76, 0x50, 0xCC, 0x7A, 0x5C, 0xBC, 0x71, 0x2D,
    0x47, 0xE6, 0x6A, 0xFC, 0x62, 0xEB, 0x6E, 0xCE, 0x5D, 0xB7, 0x92, 0x91, 0x4A, 0x21, 0x99, 0x51,
    0x8C, 0xED, 0xB8, 0xBC, 0x52, 0xAA, 0x13, 0x0A, 0x5B, 0x5F, 0x1C, 0xE3, 0xD1, 0x1D, 0xBB, 0x39,
    0xFF, 0xD4, 0x93, 0x18, 0x1D, 0x2A, 0x53, 0x50, 0x86, 0x28, 0x6C, 0xE1, 0x09, 0x6F, 0x71, 0x02,
    0x70, 0x38, 0xEB, 0x68, 0x86, 0x8E, 0x46, 0x18, 0xE7, 0x6B, 0xAD, 0x68, 0xB4, 0x15, 0xE9, 0x4E,
    0xD2, 0x9E, 0x47, 0x80, 0xB3, 0x0E, 0x9C, 0x1B, 0x6C, 0x85, 0x51, 0x3E, 0x0C, 0x23, 0x74, 0x6C,
    0x69, 0xF3, 0x2A, 0x9C, 0x4A, 0x92, 0xA0, 0x68, 0xCF, 0x02, 0xF3, 0xD3, 0xDE, 0x74, 0xD5, 0x60,
    0x8D, 0xA5, 0x27, 0xE7, 0xA7, 0x39, 0xD2, 0x61, 0x4D, 0xCC, 0x70, 0xCE, 0x72, 0xF9, 0xBA, 0x61,
    0x8A, 0x3E, 0x44, 0x71, 0xDC, 0x89, 0x67, 0x84, 0xC0, 0x13, 0x82, 0xF1, 0xA9, 0x59, 0x1E, 0x7A,
    0x76, 0x37, 0x67, 0x9D, 0x74, 0x02, 0x4B, 0x7A, 0x0A, 0x84, 0x5A, 0x23, 0x21, 0x99, 0xEE, 0x94,
    0x42, 0x4A, 0x89, 0x94, 0x02, 0x63, 0x2D, 0x0F, 0x6C, 0xDD, 0xC1, 0xF6, 0x7D, 0x2F, 0x71, 0xF9,
    0x1B, 0x36, 0xB0, 0x7A, 0xA8, 0x97, 0xF1, 0xD9, 0x1A, 0x47, 0x66, 0xAB, 0x18, 0x53, 0x80, 0xD8,
    0x2C, 0xA2, 0x97, 0xE8, 0x10, 0xD0, 0xC2, 0xD2, 0x0C, 0x75, 0x50, 0x6F, 0xE9, 0xC1, 0xBD, 0x13,
    0xB5, 0xCE, 0xE2, 0x70, 0x1E, 0x01, 0x49, 0xB9, 0xE9, 0x7A, 0x1A, 0xCD, 0xD8, 0x8F, 0xA2, 0x18,
    0x6D, 0xDC, 0xD1, 0xFE, 0xBD, 0x03, 0xA4, 0x4D, 0x93, 0xE0, 0xD1, 0x59, 0xA0, 0x9B, 0xE9, 0xC9,
    0xAA, 0x49, 0xCA, 0xD8, 0xAC, 0x87, 0xB3, 0x9A, 0xA2, 0x8C, 0xB8, 0xFC, 0xA4, 0x41, 0x86, 0xF2,
    0x8A, 0x28, 0xD6, 0x1D, 0xF0, 0xD6, 0x5A, 0x02, 0xDF, 0xA3, 0x11, 0xC5, 0xDC, 0xFD, 0xE8, 0x36,
    0xAE, 0xDA, 0x74, 0x2A, 0xFD, 0xA5, 0x1C, 0x5F, 0xFA, 0xE1, 0x66, 0x7A, 0xF3, 0x19, 0xAE, 0x3D,
    0xF7, 0x74, 0x02, 0xA5, 0x10, 0x29, 0xF8, 0x7A, 0x2B, 0xE2, 0x07, 0x8F, 0x6D, 0xE1, 0xF0, 0x4C,
    0x8D, 0xB7, 0x9D, 0xFB, 0x3A, 0x46, 0xFA, 0xCA, 0xEC, 0x99, 0x98, 0xE5, 0xAB, 0x3F, 0x7D, 0x9A,
    0xF1, 0x19, 0x8D, 0xCC, 0x95, 0x70, 0xC6, 0x1C, 0xA3, 0x4F, 0x32, 0x15, 0x3A, 0x9C, 0xB3, 0xC4,
    0x56, 0xD0, 0x0A, 0x63, 0xA9, 0xB5, 0xE9, 0xFD, 0xFB, 0x3B, 0xB7, 0xF2, 0xD7, 0xD7, 0x9C, 0x7A,
    0x2C, 0x01, 0x61, 0xA4, 0xD1, 0xC6, 0x64, 0xA7, 0xE7, 0x1A, 0xAA, 0x5E, 0x6F, 0xE1, 0x94, 0x4A,
    0x3C, 0xC0, 0x81, 0xB0, 0x0E, 0x94, 0x44, 0x08, 0x97, 0x8E, 0xB3, 0xB8, 0xBB, 0x4D, 0x6A, 0x4D,
    0xA3, 0x29, 0xE8, 0xCD, 0x68, 0x2E, 0xDE, 0xD8, 0xC7, 0xEA, 0xFE, 0x0C, 0xB1, 0x8E, 0x3B, 0xD7,
    0x0B, 0x21, 0xF0, 0x3C, 0x45, 0x23, 0xB6, 0x6C, 0xD9, 0x73, 0x08, 0x27, 0x3D, 0xEA, 0x51, 0xCC,
    0xB6, 0xAD, 0xE3, 0x4C, 0xD7, 0x22, 0x7A, 0x8B, 0x05, 0x3C, 0xCF, 0x47, 0x4A, 0x81, 0x92, 0x92,
    0xC3, 0xB3, 0x55, 0x6E, 0x7F, 0xE0, 0x71, 0x10, 0x8A, 0x3F, 0xB8, 0xF0, 0x0D, 0xF4, 0x17, 0xF3,
    0x3C, 0xB1, 0x73, 0x8C, 0xAF, 0xFD, 0xF4, 0x57, 0xEC, 0x99, 0x15, 0xF8, 0x85, 0x41, 0x9C, 0x93,
    0xA0, 0xCD, 0x22, 0x3A, 0x25, 0x5D, 0x1B, 0xE7, 0x2C, 0x42, 0xC0, 0x6C, 0x3D, 0xA4, 0x15, 0xE9,
    0x7C, 0xF4, 0xF5, 0x2F, 0xE3, 0xBE, 0x7A, 0xFD, 0xB1, 0x04, 0xE0, 0x2C, 0x38, 0x27, 0xC3, 0x48,
    0x73, 0x64, 0xA6, 0x4E, 0xA1, 0x90, 0x21, 0x48, 0xEF, 0x23, 0xAC, 0x43, 0xD8, 0xA4, 0x18, 0x7A,
    0xB9, 0xB6, 0x8F, 0x73, 0x96, 0xA8, 0xDE, 0xE4, 0xE2, 0x0D, 0x15, 0x36, 0xAD, 0x28, 0xA7, 0x45,
    0xCD, 0x51, 0xF0, 0x8D, 0x48, 0xF3, 0xE3, 0x87, 0xB7, 0x70, 0x70, 0xAE, 0xC5, 0x29, 0x2B, 0x47,
    0x58, 0xB3, 0x74, 0x80, 0x6A, 0xA3, 0xC9, 0x8A, 0xC1, 0x5E, 0xCE, 0x3B, 0x65, 0x35, 0xF9, 0xC0,
    0x43, 0x09, 0x90, 0x42, 0xB0, 0x63, 0xEC, 0x10, 0xB7, 0xFE, 0xEC, 0x51, 0x46, 0x06, 0xFB, 0xB8,
    0xEE, 0xFC, 0x33, 0x08, 0x3C, 0xC9, 0x77, 0x1F, 0xDE, 0xCA, 0x37, 0x1F, 0x7A, 0x9E, 0x19, 0x93,
    0xC7, 0xCF, 0xF7, 0x63, 0x44, 0x90, 0xEC, 0xA7, 0x61, 0x8E, 0xA7, 0x10, 0xCE, 0x5A, 0xEA, 0xA1,
    0xA6, 0x9A, 0xF7, 0xB0, 0xCE, 0x49, 0xD8, 0xDF, 0x89, 0x14, 0x6F, 0xE1, 0xC5, 0x02, 0x17, 0x49,
    0x9C, 0x0D, 0xC3, 0x88, 0x56, 0x6C, 0xE8, 0xED, 0x15, 0xF8, 0x90, 0x14, 0x42, 0x4E, 0x21, 0xE4,
    0xCB, 0xF4, 0xBD, 0x9C, 0xC5, 0xC4, 0x2D, 0xCE, 0x5D, 0x99, 0xE3, 0x9A, 0xD7, 0x2D, 0x45, 0x89,
    0x24, 0x61, 0x4A, 0x29, 0x13, 0xCB, 0x2B, 0xC5, 0x0B, 0x2F, 0x1D, 0xE1, 0xAE, 0x47, 0xB6, 0x93,
    0x2F, 0xF4, 0xF0, 0xEE, 0x8B, 0xCF, 0x66, 0x49, 0xC9, 0xC7, 0x51, 0x42, 0x2A, 0xD5, 0xF1, 0x5A,
    0x21, 0x24, 0x9B, 0xB7, 0xEE, 0xE0, 0xB6, 0x5F, 0x3C, 0xCE, 0xB9, 0xA7, 0x9E, 0xC4, 0x35, 0x6F,
    0x3C, 0x8D, 0xD9, 0x7A, 0x93, 0xAF, 0xFC, 0xE8, 0x49, 0xEE, 0xDD, 0x32, 0x86, 0x0E, 0xFA, 0xF0,
    0xB2, 0x3D, 0x18, 0x82, 0x14, 0xF7, 0xE2, 0xE0, 0x93, 0x54, 0xE4, 0xA8, 0x37, 0x23, 0xC2, 0x30,
    0x06, 0x5B, 0x40, 0x38, 0x17, 0x52, 0xBE, 0x36, 0x8D, 0xE9, 0x85, 0x04, 0xE0, 0x10, 0x82, 0x9A,
    0x12, 0x4E, 0x0B, 0x2C, 0xCD, 0x96, 0x66, 0x7A, 0x56, 0x50, 0x2E, 0x83, 0x9F, 0xF1, 0x93, 0x30,
    0x90, 0xB2, 0xD3, 0xA9, 0x59, 0xF8, 0x5B, 0x1D, 0x87, 0x9C, 0x3C, 0xA8, 0xF8, 0xE3, 0xF3, 0x57,
    0xD1, 0x5B, 0xCC, 0x62, 0xEC, 0xD1, 0x84, 0x24, 0x84, 0xC0, 0x5A, 0xCB, 0xCA, 0xE1, 0x01, 0xDE,
    0x79, 0xE1, 0x26, 0xF2, 0xF9, 0x1C, 0x7D, 0x85, 0x00, 0xEB, 0x1C, 0x52, 0x29, 0x84, 0x48, 0xE2,
    0x3D, 0xD2, 0x86, 0x6F, 0xDF, 0xFF, 0x4B, 0xEE, 0x7D, 0x62, 0x3B, 0xEF, 0xBA, 0xF4, 0x8D, 0x5C,
    0xF6, 0xFA, 0x93, 0xD9, 0xBA, 0x67, 0x9C, 0x2F, 0xFF, 0xF0, 0x31, 0x9E, 0x19, 0xAF, 0xA3, 0x72,
    0x03, 0x48, 0xBF, 0x84, 0xC1, 0x7B, 0x79, 0xCB, 0xA7, 0xE0, 0x9B, 0xA1, 0xA6, 0xDA, 0x08, 0xC9,
    0x28, 0xF0, 0xA4, 0x73, 0x52, 0x30, 0x77, 0xD5, 0x47, 0x2E, 0x46, 0xA4, 0x5E, 0x79, 0x8C, 0x07,
    0x38, 0xEB, 0x26, 0x03, 0x4F, 0x46, 0xCA, 0x39, 0x30, 0x9A, 0x30, 0x0C, 0x99, 0xAD, 0x42, 0xC1,
    0xE6, 0x08, 0x32, 0x3E, 0x42, 0x2A, 0x90, 0xB6, 0x8B, 0xE3, 0x24, 0x49, 0x58, 0x1D, 0x33, 0x98,
    0x33, 0xFC, 0xE9, 0xC5, 0xEB, 0x58, 0x31, 0x58, 0x46, 0x1B, 0x8B, 0x27, 0xE7, 0x13, 0x04, 0x82,
    0xA2, 0xE7, 0x71, 0xED, 0x79, 0x1B, 0xD3, 0x69, 0x2D, 0xB1, 0xB6, 0x10, 0x49, 0xBC, 0x4F, 0x57,
    0xEB, 0x7C, 0xE9, 0xCE, 0x9F, 0xF0, 0xFC, 0xFE, 0x43, 0xFC, 0xC5, 0x75, 0x57, 0xB0, 0x71, 0xF5,
    0x08, 0x77, 0x3F, 0xBC, 0x95, 0xFF, 0xFD, 0x93, 0xA7, 0x38, 0xD4, 0xF4, 0xF1, 0xF3, 0x43, 0x38,
    0x2F, 0x8F, 0x71, 0x32, 0xA9, 0xF8, 0xDC, 0xC2, 0x9A, 0x24, 0x19, 0x43, 0x08, 0xB0, 0xD6, 0xD1,
    0x8C, 0x74, 0xB2, 0x96, 0x31, 0x06, 0x25, 0x15, 0x81, 0x14, 0x71, 0xA0, 0xC4, 0x91, 0x37, 0x9D,
    0xBA, 0x94, 0xB6, 0x0D, 0xE7, 0x11, 0x90, 0xF1, 0x15, 0xD9, 0x40, 0x4D, 0xE4, 0x33, 0x6A, 0xCA,
    0x97, 0x0C, 0x38, 0xA3, 0x41, 0x0B, 0xE2, 0x50, 0x50, 0x75, 0x90, 0x33, 0x96, 0x20, 0xE3, 0x27,
    0xE5, 0x68, 0x57, 0x18, 0x58, 0x6B, 0xC8, 0x8A, 0x16, 0x7F, 0xF2, 0xA6, 0xF5, 0xBC, 0x61, 0xF5,
    0x10, 0xC6, 0x3A, 0x3C, 0x71, 0x14, 0xBD, 0x58, 0x10, 0x32, 0xF3, 0xE6, 0x76, 0x40, 0x29, 0xC5,
    0xCE, 0x03, 0x07, 0xF9, 0xEC, 0xAD, 0xF7, 0x20, 0xA4, 0xC7, 0x27, 0xDE, 0xF7, 0x4E, 0x0A, 0x19,
    0x9F, 0xCF, 0xDE, 0xFE, 0x33, 0xBE, 0xF7, 0xD8, 0x6E, 0x22, 0x59, 0xC6, 0xCB, 0x55, 0x30, 0x22,
    0x9B, 0xD4, 0xFA, 0x2F, 0x63, 0x75, 0x00, 0xE3, 0x1C, 0xAD, 0xC8, 0x10, 0xC7, 0x1A, 0x67, 0x1D,
    0xCE, 0x1A, 0x3C, 0x5F, 0x90, 0xF3, 0x65, 0xAB, 0xB7, 0x10, 0x8C, 0x6B, 0x63, 0x16, 0xAF, 0x03,
    0x86, 0x2B, 0x39, 0x56, 0x0E, 0xF7, 0xCC, 0x94, 0x72, 0xC1, 0xBE, 0x8C, 0x2F, 0x4F, 0x12, 0x46,
    0xE3, 0x84, 0xC0, 0x49, 0x81, 0x89, 0x05, 0x0D, 0xE7, 0x88, 0x8D, 0x21, 0x13, 0xF8, 0x48, 0x25,
    0x93, 0xA2, 0xC7, 0x59, 0x9C, 0x6E, 0xF2, 0xCE, 0x37, 0xAD, 0xE2, 0xF7, 0x36, 0xAD, 0x4A, 0x00,
    0x09, 0xD7, 0x01, 0xBD, 0x10, 0x7C, 0x1B, 0x78, 0xFB, 0x3B, 0x01, 0x6C, 0x7E, 0xE6, 0x59, 0x3E,
    0xFF, 0xED, 0x1F, 0xB2, 0x61, 0xCD, 0x4A, 0xDE, 0x7F, 0xED, 0x9B, 0xD9, 0x77, 0x68, 0x92, 0xBF,
    0xF9, 0xFA, 0x0F, 0x79, 0x62, 0xCF, 0x0C, 0x32, 0xDB, 0x87, 0x0C, 0x4A, 0x18, 0xFC, 0xE3, 0xBA,
    0x7C, 0x77, 0x43, 0x39, 0x36, 0x96, 0x58, 0x1B, 0xAC, 0x4D, 0x57, 0x95, 0xD6, 0x82, 0x31, 0x64,
    0x94, 0x4F, 0x39, 0xE7, 0xCF, 0x64, 0x7C, 0x6F, 0x6F, 0xE0, 0x29, 0x02, 0x4F, 0x1D, 0x4B, 0xC0,
    0x89, 0xCB, 0x7A, 0xD9, 0x74, 0xE2, 0x50, 0xF5, 0x8E, 0x9F, 0xFB, 0xCF, 0x16, 0x73, 0xFE, 0x65,
    0xC2, 0x59, 0xAC, 0x8E, 0x71, 0x32, 0x5D, 0x8D, 0x09, 0x88, 0xA3, 0xA4, 0x5E, 0xF0, 0x3C, 0x85,
    0xE7, 0x49, 0x4C, 0xDC, 0xE2, 0x8A, 0x8D, 0x43, 0xFC, 0xC9, 0x65, 0x1B, 0x08, 0x3C, 0x0F, 0xEB,
    0xE6, 0x83, 0x6F, 0x2F, 0x6D, 0x93, 0x82, 0xE6, 0xA8, 0x57, 0x48, 0x29, 0x89, 0xA2, 0x98, 0xDB,
    0xEE, 0xDB, 0xCC, 0x37, 0x7E, 0xFC, 0x20, 0xD7, 0x5D, 0xFC, 0x46, 0xAE, 0xBD, 0xF8, 0x2C, 0x7E,
    0xF4, 0xE8, 0x36, 0xBE, 0xF8, 0xBD, 0x87, 0x19, 0xAB, 0x82, 0x9F, 0x1B, 0xC4, 0x79, 0x79, 0x2C,
    0xAA, 0x03, 0xFE, 0x38, 0x5D, 0x73, 0xAC, 0x75, 0xC4, 0xC6, 0xA6, 0x79, 0xC7, 0xB5, 0xC3, 0x39,
    0x69, 0xA8, 0x58, 0x4B, 0x7F, 0x31, 0xA0, 0x9C, 0x95, 0x2F, 0xCE, 0x4E, 0x8C, 0x1F, 0x6E, 0x36,
    0x8F, 0x92, 0x38, 0x8F, 0x80, 0x4D, 0x27, 0x0E, 0xF1, 0xC7, 0xFF, 0xE3, 0xFB, 0x76, 0xDD, 0x8A,
    0xFE, 0xC7, 0x2B, 0xC5, 0x6C, 0xE4, 0x09, 0x02, 0xA3, 0x35, 0x4E, 0x26, 0xE0, 0x3B, 0x2E, 0xEF,
    0x1C, 0x91, 0xB5, 0xB4, 0x9A, 0x11, 0xA7, 0x8D, 0x16, 0xF9, 0xD0, 0x3B, 0x36, 0xD1, 0x5B, 0xCC,
    0x26, 0x71, 0xDF, 0x65, 0xF1, 0x76, 0x29, 0xDB, 0x9E, 0x05, 0x3A, 0x5E, 0x20, 0x25, 0xD3, 0xB3,
    0x73, 0x7C, 0xF1, 0xB6, 0xEF, 0xF3, 0xD0, 0x96, 0x17, 0xF8, 0x8B, 0xEB, 0xDF, 0xCA, 0xC6, 0x35,
    0xA3, 0xFC, 0xCF, 0x6F, 0xDD, 0xC7, 0xB7, 0x1F, 0x7C, 0x8E, 0x96, 0x28, 0xE2, 0x65, 0x2B, 0x58,
    0x99, 0x41, 0x58, 0x12, 0x2B, 0x2E, 0x38, 0x5C, 0x97, 0x2E, 0xD6, 0xBA, 0xA3, 0xC0, 0xA1, 0x33,
    0xF7, 0x63, 0x2D, 0xCE, 0x18, 0xF2, 0x81, 0x62, 0xA4, 0xBF, 0x40, 0x3E, 0x90, 0x4F, 0x7E, 0xEB,
    0x3F, 0x9F, 0x3B, 0xBB, 0xE6, 0xDD, 0x9F, 0x5A, 0x9C, 0x80, 0xC3, 0x33, 0x4D, 0x36, 0xAE, 0x1A,
    0x64, 0xA8, 0xAF, 0xF0, 0xC4, 0x40, 0x6F, 0xE1, 0x60, 0x36, 0x50, 0x2B, 0xC2, 0x30, 0xC2, 0xC5,
    0x02, 0x8B, 0x40, 0x72, 0x74, 0x1D, 0x60, 0x75, 0x4C, 0x7F, 0xC1, 0x71, 0xE3, 0x75, 0x67, 0xB2,
    0x7A, 0xA8, 0x27, 0xA9, 0xF1, 0x3B, 0xEB, 0xF6, 0xF9, 0x56, 0x5F, 0x08, 0x7E, 0xF7, 0x81, 0x71,
    0x3E, 0xFD, 0xF5, 0x3B, 0x98, 0x6D, 0x84, 0x7C, 0xF2, 0xCF, 0xDE, 0x4D, 0x6C, 0x1C, 0x1F, 0xFA,
    0xC7, 0x3B, 0xF8, 0xE5, 0x8E, 0x09, 0x44, 0xB6, 0x17, 0x15, 0x94, 0x92, 0x29, 0xCE, 0x42, 0xFA,
    0xE7, 0x18, 0xF4, 0x36, 0x2D, 0x71, 0xAD, 0x5B, 0xE4, 0xCB, 0xB6, 0xF5, 0x8D, 0xC1, 0x17, 0x8E,
    0x25, 0x3D, 0x39, 0xFA, 0x8B, 0x99, 0x66, 0x5F, 0xB9, 0xF8, 0xD0, 0x45, 0xFF, 0xF0, 0xA4, 0xDD,
    0xF7, 0xF0, 0x77, 0x17, 0x27, 0x60, 0xB8, 0x37, 0xCF, 0x77, 0x36, 0xEF, 0x60, 0xD3, 0xFA, 0xE5,
    0xBB, 0x1F, 0xDD, 0xBA, 0xFF, 0x91, 0x4A, 0x29, 0xB7, 0x62, 0x6E, 0xAE, 0x8E, 0xD5, 0x71, 0x52,
    0x55, 0x76, 0x7A, 0x0C, 0x86, 0x40, 0x69, 0xFE, 0xFC, 0xAD, 0x67, 0x73, 0xC1, 0xA9, 0xCB, 0x89,
    0xD3, 0x15, 0x5B, 0x27, 0xE6, 0x84, 0x40, 0x76, 0xAD, 0xE1, 0x9D, 0x4B, 0xAA, 0x47, 0x29, 0x04,
    0x8F, 0x3E, 0xB3, 0x9D, 0x4F, 0xFD, 0xEB, 0x77, 0x59, 0xB3, 0x7C, 0x29, 0x1F, 0x7C, 0xCF, 0xDB,
    0xF9, 0xE5, 0xB6, 0x17, 0xF9, 0x5F, 0xDF, 0xD9, 0xCC, 0xFE, 0x19, 0x83, 0x9F, 0x1B, 0x40, 0xB4,
    0x5D, 0x7E, 0xA1, 0xD5, 0xD3, 0xAD, 0x38, 0x97, 0xEE, 0x47, 0x1E, 0xFD, 0x23, 0xBA, 0x92, 0x80,
    0xEB, 0xAC, 0xFE, 0x9C, 0xB1, 0xF8, 0xD2, 0x31, 0x50, 0xCC, 0x30, 0x50, 0xCE, 0xD0, 0x5B, 0xCC,
    0xEC, 0x2A, 0x17, 0x82, 0x47, 0x85, 0x08, 0xF1, 0x8B, 0x95, 0xC5, 0x09, 0x00, 0xB8, 0xE2, 0x0D,
    0xAB, 0xB8, 0xEA, 0xC6, 0x5B, 0x9A, 0x97, 0x9F, 0xB9, 0xE6, 0x9E, 0xE1, 0x81, 0xD2, 0x35, 0x07,
    0x0F, 0x4E, 0x66, 0x9A, 0x51, 0x04, 0xC2, 0x75, 0xDC, 0xCE, 0xC4, 0x96, 0x6B, 0x2E, 0x58, 0xC3,
    0x1F, 0x5E, 0xB2, 0x01, 0x1D, 0xC7, 0xA9, 0x15, 0x5C, 0x7B, 0x12, 0x4A, 0x9E, 0x80, 0xEA, 0x02,
    0xDF, 0xF6, 0x8A, 0x1F, 0x3C, 0xF0, 0x18, 0x37, 0xDF, 0x79, 0x2F, 0x57, 0x5C, 0x70, 0x16, 0x6F,
    0x3A, 0x63, 0x03, 0x37, 0xDD, 0xFD, 0x10, 0xB7, 0xFE, 0x7C, 0x1B, 0x4D, 0x97, 0xC7, 0xCB, 0xF6,
    0x63, 0x65, 0x16, 0x61, 0x45, 0xE2, 0xBA, 0x8B, 0xB9, 0xFC, 0xF1, 0x1E, 0x3A, 0xE8, 0x5E, 0x03,
    0xB9, 0xD4, 0xF2, 0x0A, 0xFA, 0x0B, 0x19, 0xCA, 0x59, 0x45, 0x5F, 0x29, 0x4B, 0x4F, 0x21, 0xF3,
    0x93, 0xF7, 0x5C, 0xBC, 0x7E, 0xEC, 0xB6, 0x5F, 0xEC, 0xE0, 0xCF, 0xFE, 0xDB, 0x87, 0x8E, 0x4F,
    0xC0, 0xBE, 0xC3, 0x73, 0xFC, 0xFE, 0x9B, 0x4E, 0x61, 0xA0, 0x52, 0xB8, 0x6F, 0x74, 0xB8, 0xB2,
    0xED, 0xC5, 0x3D, 0xD9, 0x33, 0x5A, 0x47, 0x5A, 0x10, 0x77, 0x0F, 0x6D, 0x38, 0x30, 0x7E, 0x88,
    0xC3, 0xD3, 0x73, 0x0C, 0x57, 0x0A, 0x49, 0xB3, 0x22, 0xB5, 0xBA, 0x50, 0x2A, 0x59, 0x09, 0x76,
    0x85, 0x41, 0x18, 0xC5, 0xDC, 0x72, 0xCF, 0x7D, 0xFC, 0xE2, 0x89, 0xAD, 0xBC, 0xFF, 0xFA, 0xAB,
    0xC9, 0x64, 0x73, 0xFC, 0xD5, 0x97, 0xEE, 0xE4, 0xE1, 0xE7, 0x0F, 0x23, 0x32, 0x15, 0x54, 0xA6,
    0x88, 0x13, 0xFE, 0xD1, 0xD8, 0x7D, 0xAD, 0x47, 0x1A, 0x07, 0x6D, 0x0F, 0xCC, 0x7A, 0x92, 0xBE,
    0x62, 0x40, 0xCE, 0x13, 0x94, 0x32, 0x1E, 0x83, 0x3D, 0xB9, 0x89, 0x4A, 0x31, 0xFB, 0x9D, 0x4F,
    0x7F, 0xFB, 0x51, 0xF3, 0xF5, 0x9F, 0x1F, 0x9C, 0xF7, 0xD3, 0x63, 0x4A, 0xBA, 0x93, 0x57, 0xF4,
    0xB3, 0x62, 0xB8, 0xC2, 0xBB, 0x2E, 0x39, 0xE5, 0xC0, 0xC8, 0x50, 0xCF, 0xAD, 0x23, 0x4B, 0x7A,
    0x6D, 0xE0, 0x49, 0x9C, 0x8E, 0xB1, 0x71, 0x8C, 0x8B, 0x23, 0x84, 0x73, 0x3C, 0xBC, 0x65, 0x2F,
    0x9F, 0xFC, 0xDA, 0xF7, 0xA9, 0x35, 0x93, 0x56, 0xB5, 0x6B, 0x2B, 0x61, 0x8F, 0x6E, 0x62, 0x00,
    0xCC, 0x56, 0x6B, 0x7C, 0xE1, 0x5F, 0xEF, 0x60, 0xE7, 0xBE, 0x71, 0x3E, 0xFA, 0xBE, 0x7F, 0xC7,
    0xD8, 0x54, 0x9D, 0x0F, 0x7C, 0xEE, 0x76, 0x36, 0x3F, 0x37, 0x89, 0xCC, 0xF6, 0x23, 0xFD, 0x12,
    0x4E, 0x78, 0x09, 0x78, 0x6B, 0xE7, 0x09, 0xAF, 0x20, 0xDD, 0xD7, 0x38, 0x63, 0xC0, 0x18, 0x8A,
    0x81, 0x64, 0xB0, 0x14, 0x90, 0x55, 0xE0, 0x0B, 0x47, 0x7F, 0x4F, 0x8E, 0x81, 0x9E, 0xFC, 0x8F,
    0xD7, 0x2C, 0xEB, 0x7D, 0x6C, 0xB0, 0x27, 0xC7, 0x27, 0xDE, 0xB3, 0x7E, 0x1E, 0xDE, 0x45, 0x9F,
    0x68, 0x78, 0xDB, 0x7B, 0x6E, 0xE0, 0xEC, 0x2B, 0xDF, 0xC3, 0x60, 0x6F, 0x71, 0xAC, 0xD6, 0x08,
    0x2F, 0x9A, 0x98, 0x9C, 0x5D, 0x5A, 0xAF, 0x37, 0xD2, 0x8D, 0xCB, 0xA4, 0x06, 0x12, 0x52, 0xF2,
    0xC2, 0x9E, 0x71, 0xB0, 0x31, 0xE7, 0x9C, 0xB6, 0x16, 0x29, 0x8E, 0xBA, 0xBC, 0x73, 0x16, 0xA5,
    0x14, 0x63, 0x87, 0x27, 0xF9, 0xD2, 0xAD, 0x77, 0xB1, 0x6C, 0x68, 0x80, 0x6B, 0x2F, 0xBF, 0x88,
    0x7F, 0xFE, 0xFE, 0xC3, 0x7C, 0xEE, 0xF6, 0xCD, 0x4C, 0xB5, 0x02, 0xFC, 0x6C, 0x2F, 0x42, 0x65,
    0x93, 0x4D, 0x0C, 0x77, 0x34, 0x7E, 0x5F, 0xB3, 0xA4, 0x44, 0x28, 0x1C, 0xBD, 0x85, 0x80, 0xDE,
    0x82, 0x8F, 0x87, 0x45, 0x3A, 0x43, 0x4F, 0x21, 0x60, 0xF5, 0x48, 0xFF, 0xC4, 0xE8, 0x70, 0xE5,
    0xBF, 0xEE, 0x1A, 0x9B, 0x7A, 0xE1, 0x5D, 0x97, 0xAC, 0xE7, 0x8C, 0x13, 0x97, 0xBD, 0xBC, 0x07,
    0x00, 0xBC, 0xEB, 0xD2, 0x53, 0x39, 0x61, 0x49, 0x85, 0xF7, 0xFF, 0xF9, 0x97, 0xF7, 0xAC, 0x1C,
    0xE9, 0xFF, 0xA7, 0x55, 0xA3, 0x43, 0xAD, 0x5C, 0xC6, 0x07, 0x13, 0xE3, 0x74, 0x84, 0x8B, 0x63,
    0x30, 0x60, 0xC8, 0x72, 0xD3, 0x9D, 0x8F, 0x70, 0xF3, 0x5D, 0x9B, 0x41, 0xC8, 0xD4, 0xF2, 0x1A,
    0x29, 0x24, 0xDB, 0x76, 0xED, 0xE5, 0x96, 0xBB, 0x7F, 0xC2, 0x65, 0xE7, 0x9E, 0xC9, 0xC6, 0x53,
    0x4E, 0xE6, 0x23, 0x9F, 0xBF, 0x9D, 0xAF, 0xFE, 0xE0, 0x57, 0x84, 0xA2, 0x8C, 0x97, 0xE9, 0x01,
    0x19, 0x24, 0xC1, 0xFB, 0x2A, 0xAD, 0x8D, 0x4D, 0x4A, 0x5F, 0xD7, 0x65, 0x7D, 0x67, 0x4C, 0xD2,
    0x66, 0xF7, 0x04, 0xC3, 0x3D, 0x59, 0x2A, 0x39, 0x0F, 0x65, 0x0D, 0xC2, 0x18, 0xB2, 0x9E, 0x60,
    0x49, 0x5F, 0x89, 0xA1, 0x4A, 0xF1, 0xD6, 0xD3, 0x4F, 0x5C, 0xFA, 0xE0, 0xE8, 0x50, 0x99, 0x07,
    0xB6, 0x8C, 0x1D, 0x83, 0xF5, 0xB8, 0xCF, 0xB4, 0x5C, 0xF1, 0xCE, 0xF7, 0x71, 0xE9, 0xA5, 0x1B,
    0x59, 0x39, 0xD2, 0xBF, 0xAB, 0xD6, 0x08, 0xD7, 0xCF, 0xCC, 0xD5, 0x4F, 0x99, 0x9B, 0xAD, 0x61,
    0x8D, 0xE9, 0x2C, 0x71, 0x85, 0x90, 0xC4, 0x16, 0x1E, 0xDF, 0xF6, 0x02, 0xA5, 0xBC, 0xCF, 0xE9,
    0x27, 0xAD, 0x40, 0x08, 0xC1, 0xA3, 0x5B, 0x9F, 0x67, 0xDB, 0xCE, 0x3D, 0x5C, 0x7D, 0xE9, 0x05,
    0x3C, 0xBB, 0x77, 0x82, 0xBF, 0xFE, 0xE2, 0x77, 0xD9, 0xB6, 0x7F, 0x0E, 0x2F, 0xD7, 0x8B, 0xF4,
    0xF2, 0x20, 0xD5, 0xC2, 0xCC, 0xB6, 0xE0, 0x38, 0x4E, 0x93, 0xBD, 0x63, 0xF9, 0x84, 0x80, 0x40,
    0x0A, 0x7A, 0x0B, 0x01, 0x7D, 0xC5, 0x0C, 0x19, 0x05, 0xC2, 0x1A, 0xB0, 0x06, 0x5F, 0x3A, 0x06,
    0x7B, 0x0B, 0xAC, 0x5A, 0x3E, 0xF0, 0xCC, 0x09, 0x4B, 0x7B, 0xFF, 0x6A, 0xEF, 0x4B, 0xD3, 0x87,
    0x8E, 0xCC, 0x35, 0xF8, 0xD3, 0xAB, 0xDF, 0x70, 0xCC, 0x2D, 0x5F, 0xB6, 0x97, 0xED, 0x9C, 0xE3,
    0x23, 0x5F, 0xF8, 0x01, 0xC3, 0xFD, 0xE5, 0x33, 0x1E, 0x7B, 0x66, 0xF7, 0x2D, 0x0F, 0x3F, 0xF1,
    0xDC, 0xBA, 0x89, 0x89, 0x69, 0xAC, 0x13, 0xA0, 0x14, 0x42, 0x79, 0x08, 0x4F, 0x62, 0x6D, 0x4C,
    0xCE, 0x0B, 0xB9, 0xE1, 0xBA, 0xF3, 0x39, 0xF3, 0x94, 0x15, 0xF8, 0x9E, 0x60, 0x74, 0x64, 0x19,
    0x37, 0xDD, 0xFE, 0x33, 0x6E, 0xB9, 0xF7, 0x49, 0x42, 0x0A, 0xA8, 0x6C, 0x19, 0x21, 0x03, 0xE8,
    0xB4, 0xD5, 0x5F, 0xE5, 0x86, 0x62, 0x17, 0x49, 0xED, 0xFA, 0xC2, 0x93, 0x82, 0x62, 0xCE, 0xA7,
    0x9C, 0x0B, 0x08, 0x94, 0x40, 0xB8, 0xC4, 0x3B, 0x84, 0xB5, 0x28, 0x61, 0xA9, 0x14, 0x73, 0xAC,
    0x5D, 0xB9, 0x64, 0x76, 0xDD, 0xCA, 0xA1, 0x1B, 0x3E, 0xFD, 0xAD, 0x27, 0xBF, 0x79, 0xEB, 0xC7,
    0xAF, 0xE2, 0xE0, 0xAC, 0xE6, 0xDA, 0x0B, 0x4F, 0x7E, 0xF5, 0x1E, 0x00, 0xB0, 0xF6, 0xDC, 0x6B,
    0x19, 0x19, 0xAC, 0x70, 0xC3, 0xF5, 0x7F, 0xFB, 0xD2, 0x75, 0xEF, 0xB9, 0x6C, 0x3A, 0x36, 0xF6,
    0x92, 0xE9, 0xE9, 0x6A, 0x36, 0x6C, 0xB6, 0xDA, 0xFD, 0xC3, 0x64, 0xEA, 0x13, 0x8A, 0xD8, 0x08,
    0x1E, 0x79, 0x66, 0x27, 0xE3, 0x47, 0xA6, 0x59, 0x35, 0x3A, 0xC2, 0xA7, 0x6E, 0xBE, 0x9B, 0xEF,
    0x6D, 0x7E, 0x0E, 0xEB, 0xF5, 0x20, 0xFD, 0x22, 0x42, 0xFA, 0xB4, 0x5B, 0x54, 0x9D, 0x95, 0xC8,
    0xAB, 0x88, 0xEF, 0x76, 0x43, 0x03, 0xE7, 0xF0, 0xA4, 0xA0, 0x94, 0xF3, 0x18, 0x28, 0x65, 0x29,
    0x67, 0x3D, 0x3C, 0xE1, 0x10, 0x2E, 0xB1, 0xBA, 0xB0, 0x06, 0xE9, 0x0C, 0xA5, 0x5C, 0xC0, 0x8A,
    0x91, 0x7E, 0xBD, 0x72, 0xD9, 0xC0, 0x67, 0x2F, 0xD9, 0xB4, 0xE6, 0x4B, 0xAF, 0x5B, 0x3B, 0x60,
    0x9A, 0x91, 0xE6, 0xBA, 0x8B, 0x4E, 0x5D, 0x14, 0xE3, 0xCB, 0x12, 0xF0, 0x82, 0x38, 0x95, 0xB7,
    0x9F, 0xBF, 0x9E, 0xF3, 0xAF, 0x3C, 0x9B, 0x2B, 0xCE, 0x3B, 0xF5, 0xB9, 0x83, 0x93, 0x73, 0x26,
    0x36, 0xF6, 0xDC, 0xD9, 0xD9, 0xAA, 0x1F, 0x85, 0x61, 0x92, 0x14, 0xD3, 0x82, 0x45, 0x08, 0x09,
    0xD2, 0x63, 0xFF, 0xA1, 0x59, 0xEE, 0x7D, 0x78, 0x3B, 0x7B, 0x0F, 0xD7, 0xF1, 0x82, 0x12, 0xB2,
    0x93, 0xE8, 0x5C, 0x32, 0x5D, 0x39, 0x9B, 0x36, 0x57, 0xEC, 0xCB, 0x82, 0x4F, 0x4A, 0x59, 0x87,
    0xC4, 0x91, 0xF5, 0x25, 0x3D, 0xF9, 0xC4, 0xD5, 0x4B, 0x59, 0x2F, 0x59, 0x66, 0xBB, 0x04, 0xB4,
    0xE8, 0x80, 0xB7, 0x14, 0xB2, 0x3E, 0xA3, 0xCB, 0xFA, 0xDD, 0xE8, 0xB2, 0xFE, 0x7F, 0x1E, 0xEA,
    0x2F, 0xFF, 0x8D, 0xD1, 0xB6, 0xFE, 0xF4, 0xCE, 0x43, 0x7C, 0xF2, 0x5F, 0x1E, 0x60, 0xE4, 0x8C,
    0xB7, 0x52, 0x5C, 0x77, 0x19, 0xB3, 0xCF, 0xFE, 0xF8, 0xD5, 0x11, 0xD0, 0x73, 0xE5, 0x27, 0x31,
    0xD6, 0x32, 0x35, 0x53, 0xE7, 0xC7, 0x8F, 0xEF, 0xE2, 0xE3, 0xFF, 0xE1, 0x02, 0xBB, 0x7D, 0xFF,
    0xF4, 0x93, 0xBE, 0x92, 0xBE, 0xC5, 0x9D, 0x3D, 0x3B, 0x57, 0xF3, 0xA2, 0x56, 0x88, 0xB3, 0xA6,
    0xCB, 0xAA, 0x02, 0x21, 0x14, 0x0E, 0x0F, 0xA9, 0x32, 0x20, 0xD2, 0x32, 0xA3, 0x03, 0xD6, 0x76,
    0x48, 0xC0, 0x76, 0xC5, 0x73, 0x97, 0xE0, 0x2C, 0x12, 0x4B, 0xA0, 0x24, 0xC5, 0xAC, 0x47, 0x6F,
    0x21, 0xA0, 0x27, 0x1F, 0x90, 0x0B, 0x54, 0x62, 0x71, 0x6B, 0xBB, 0xC0, 0x5B, 0xB0, 0x1A, 0x89,
    0xA3, 0x90, 0xF5, 0x59, 0xBE, 0xB4, 0x8F, 0xE5, 0x4B, 0xFB, 0xEF, 0x40, 0x79, 0x37, 0x7E, 0xF4,
    0x8F, 0x2E, 0x3C, 0xFC, 0xC3, 0x83, 0x23, 0xF2, 0xF1, 0xE7, 0xC7, 0xC8, 0x67, 0x7C, 0x96, 0x0F,
    0x94, 0x78, 0xF1, 0xE0, 0x2C, 0x76, 0xF4, 0x42, 0xEC, 0x9E, 0xFB, 0x5F, 0x3E, 0x07, 0x8C, 0xBC,
    0xFD, 0xBF, 0x13, 0xC6, 0x86, 0xD8, 0x58, 0x02, 0x4F, 0x89, 0x30, 0xD2, 0x38, 0x10, 0xD5, 0x47,
    0x76, 0x8A, 0xF7, 0x7F, 0xFC, 0xBA, 0x12, 0x71, 0xF4, 0xD1, 0x67, 0x77, 0xEC, 0xFB, 0x4F, 0xDB,
    0x9F, 0x7B, 0x31, 0x37, 0x3B, 0x53, 0x4D, 0x16, 0x22, 0x52, 0xA5, 0x9B, 0x27, 0x5D, 0x67, 0xA9,
    0x40, 0x76, 0x6F, 0xA9, 0xB5, 0x5B, 0xEA, 0x47, 0x37, 0x58, 0x45, 0x5A, 0x40, 0x29, 0x25, 0xF1,
    0x3D, 0x45, 0x26, 0x50, 0x64, 0x03, 0x8F, 0xC0, 0x53, 0x28, 0x99, 0x36, 0x4D, 0xD2, 0x90, 0x11,
    0x38, 0x84, 0x73, 0x08, 0x12, 0x42, 0x85, 0xB3, 0x28, 0x01, 0xC5, 0x7C, 0x86, 0x91, 0xA5, 0x03,
    0x6E, 0xC9, 0x70, 0xDF, 0x9D, 0x73, 0x4D, 0x7D, 0xE3, 0x97, 0xBF, 0x76, 0xFF, 0xDE, 0xE2, 0x09,
    0x03, 0x90, 0x2C, 0x24, 0xAC, 0x00, 0x2B, 0xA5, 0x64, 0x76, 0xAE, 0xE1, 0xCE, 0x58, 0xBF, 0x9C,
    0xFE, 0x9E, 0x1C, 0xF7, 0x7E, 0xF6, 0xBD, 0xC7, 0xF7, 0x80, 0x81, 0x8D, 0x57, 0xB2, 0xB4, 0xAF,
    0xC8, 0x4C, 0x2D, 0x14, 0xAD, 0x48, 0x0B, 0x92, 0xE9, 0xD2, 0x0B, 0x46, 0xFA, 0x82, 0xCD, 0xCF,
    0xEC, 0xC5, 0xCF, 0x66, 0x9F, 0x3A, 0x69, 0xC5, 0x60, 0x54, 0x2C, 0x64, 0x4F, 0x0B, 0xC3, 0x28,
    0x17, 0xB6, 0x42, 0x9C, 0xD1, 0x47, 0x2D, 0x6B, 0xDB, 0x96, 0xB2, 0x88, 0xD4, 0xE5, 0x85, 0x4B,
    0xF6, 0x18, 0x14, 0xC9, 0xE3, 0x6C, 0x81, 0x92, 0xE4, 0x03, 0x45, 0x21, 0xA3, 0x28, 0xE5, 0x7C,
    0xCA, 0x39, 0x9F, 0x52, 0xC6, 0x23, 0xEB, 0x2B, 0x7C, 0x49, 0xBA, 0x1F, 0x69, 0x13, 0x4B, 0xBB,
    0x64, 0x5E, 0x17, 0xCE, 0x20, 0xAC, 0xEE, 0xC4, 0x7B, 0x20, 0x05, 0xBD, 0xE5, 0x02, 0xA3, 0xCB,
    0x06, 0xA3, 0x9E, 0x4A, 0xE9, 0xDB, 0x5B, 0xF6, 0x4C, 0xFE, 0xFD, 0x6D, 0x3F, 0x7F, 0xF6, 0x48,
    0x71, 0xA0, 0x94, 0xCE, 0xB1, 0x47, 0x0D, 0x6C, 0xAD, 0x25, 0x97, 0x0B, 0xB8, 0xEA, 0x9C, 0x93,
    0x68, 0x86, 0x9A, 0x0F, 0xDF, 0xF8, 0x5F, 0xB8, 0xEB, 0xFF, 0xDC, 0xB4, 0x88, 0x07, 0x9C, 0xFF,
    0x31, 0x0A, 0xD9, 0x00, 0x29, 0x05, 0xCE, 0x39, 0x91, 0xEA, 0xAC, 0x00, 0x1F, 0xC8, 0x00, 0x39,
    0x6D, 0x6C, 0xA6, 0x98, 0xCF, 0xE4, 0x2F, 0xDA, 0xB8, 0xFC, 0x2A, 0x11, 0x87, 0x37, 0xEC, 0xDD,
    0x3B, 0xBE, 0x6A, 0x7C, 0x7C, 0x82, 0x66, 0xB3, 0x99, 0xF6, 0x03, 0x12, 0xEB, 0x0B, 0x25, 0x91,
    0x4A, 0xCD, 0x93, 0xF6, 0x66, 0x87, 0x52, 0xE9, 0x76, 0x7B, 0xBB, 0x84, 0xEE, 0xB4, 0xC8, 0x44,
    0x47, 0x73, 0x21, 0xDA, 0x0F, 0x45, 0xBA, 0xA4, 0x35, 0x8F, 0x43, 0xE0, 0x50, 0x02, 0xB2, 0xD9,
    0x80, 0x81, 0xBE, 0x1E, 0x06, 0x06, 0x7B, 0xA7, 0x5B, 0x56, 0xDE, 0xF6, 0xC0, 0xD6, 0x03, 0xDF,
    0x7A, 0x69, 0xB2, 0x36, 0xE3, 0x7B, 0x32, 0x22, 0xF9, 0xEF, 0x93, 0x56, 0x7A, 0x0E, 0x81, 0x18,
    0xD0, 0x4A, 0x0A, 0x7B, 0xCE, 0xA9, 0xA3, 0xEE, 0x47, 0x9F, 0xF9, 0xA6, 0xBB, 0xEB, 0xA1, 0xCF,
    0x72, 0xF5, 0xB9, 0x27, 0x2F, 0xE2, 0x01, 0xA3, 0x17, 0x12, 0xCF, 0x35, 0x50, 0x59, 0x5F, 0xC8,
    0x64, 0x1D, 0xAB, 0x80, 0x00, 0xC8, 0x02, 0x45, 0xA0, 0x2C, 0xA5, 0xE8, 0x8D, 0xB5, 0xED, 0xDB,
    0x31, 0x36, 0x3D, 0xE3, 0x67, 0x33, 0x2F, 0xAE, 0x1C, 0x19, 0x2C, 0xF4, 0xF5, 0x14, 0x87, 0x04,
    0x78, 0xCE, 0x18, 0x04, 0x16, 0x25, 0x93, 0xAC, 0xED, 0x49, 0x50, 0x42, 0xA0, 0x64, 0xD2, 0x29,
    0x92, 0x24, 0x22, 0x52, 0x0B, 0xCB, 0xD4, 0xA5, 0x85, 0x33, 0xF3, 0x2C, 0x9E, 0x48, 0x12, 0xE7,
    0xC2, 0x26, 0xF7, 0x94, 0x58, 0xB2, 0xBE, 0x47, 0x6F, 0xA5, 0xC8, 0xB2, 0xA5, 0x03, 0xA6, 0x50,
    0x2E, 0xBD, 0xB0, 0xF3, 0x70, 0xED, 0xF6, 0x9F, 0x3D, 0xBD, 0xEF, 0xF1, 0x5A, 0x33, 0xCA, 0x78,
    0x4A, 0x16, 0x52, 0x23, 0xB5, 0x9F, 0x96, 0x4A, 0xD8, 0x4B, 0x43, 0xC1, 0x5A, 0xE7, 0xC2, 0x48,
    0xBB, 0xBF, 0xFC, 0xE8, 0x3B, 0xF9, 0xE5, 0x96, 0xFD, 0x3C, 0x75, 0xDF, 0xAD, 0xC7, 0x12, 0x50,
    0x38, 0xF9, 0xCD, 0x54, 0x7A, 0x8B, 0x44, 0xDA, 0x08, 0x29, 0x84, 0x24, 0x59, 0x30, 0x05, 0x40,
    0x1E, 0x28, 0x03, 0xBD, 0x40, 0xBF, 0x10, 0x0C, 0x48, 0x21, 0x06, 0x0F, 0x4D, 0x37, 0xBC, 0x03,
    0x53, 0x8D, 0x03, 0x95, 0x9E, 0xE2, 0xDC, 0x8A, 0x65, 0x03, 0xA5, 0x9E, 0x52, 0xBE, 0x20, 0x85,
    0x94, 0xAE, 0xAB, 0x7A, 0x4B, 0x2C, 0x67, 0x3B, 0xC0, 0x65, 0x1A, 0xCB, 0x12, 0xDB, 0x05, 0xD6,
    0xCE, 0x07, 0x9E, 0x82, 0x97, 0x24, 0x44, 0x66, 0x03, 0x9F, 0xDE, 0x9E, 0x22, 0x4B, 0x87, 0xFB,
    0xE9, 0x1B, 0xE8, 0x9D, 0x3E, 0xDC, 0x30, 0x8F, 0x6D, 0x7E, 0xEE, 0xE0, 0x43, 0xBB, 0xC6, 0x67,
    0x66, 0x85, 0xA0, 0x24, 0x84, 0x28, 0xA4, 0x46, 0x0A, 0xBA, 0x42, 0xDB, 0x92, 0xF4, 0xD0, 0x34,
    0x60, 0x85, 0x10, 0xB6, 0x15, 0x6A, 0xFA, 0x4A, 0x39, 0xB7, 0xEB, 0xC0, 0x24, 0xFB, 0x1E, 0xBF,
    0xEB, 0x58, 0x02, 0xD6, 0x5F, 0x70, 0x1D, 0x2B, 0x86, 0x7B, 0x38, 0x3C, 0x5D, 0x97, 0x2E, 0x8D,
    0xFD, 0x94, 0xD5, 0x36, 0x01, 0x15, 0xA0, 0xAF, 0x2D, 0x52, 0x88, 0x5E, 0xAD, 0x6D, 0x79, 0x7C,
    0xAA, 0xD6, 0x3C, 0x52, 0x8B, 0x0F, 0xF6, 0xF4, 0x94, 0x1A, 0xCB, 0x96, 0xF4, 0x65, 0x06, 0x7A,
    0xCB, 0x99, 0x6C, 0x36, 0x90, 0x2A, 0xDD, 0x5D, 0x92, 0x0B, 0xAC, 0xDF, 0x26, 0xA1, 0x9D, 0xD4,
    0xDA, 0x16, 0x4E, 0xBC, 0x24, 0x79, 0x04, 0x37, 0x1B, 0xF8, 0x14, 0x8B, 0x39, 0x06, 0xFA, 0x7A,
    0x18, 0x1E, 0xEE, 0xB7, 0xA5, 0x4A, 0xCF, 0xDC, 0x74, 0xC4, 0xCE, 0x27, 0x76, 0x4F, 0x3E, 0xB3,
    0x6D, 0xEF, 0xE4, 0xC1, 0x30, 0xD2, 0x9E, 0x94, 0x22, 0x9F, 0xEA, 0x17, 0xA4, 0xBA, 0xB6, 0x9F,
    0x59, 0x35, 0xA9, 0xEB, 0x47, 0xED, 0x10, 0x20, 0xE9, 0x9C, 0xB9, 0xB1, 0x23, 0x73, 0xEE, 0xE0,
    0x74, 0x83, 0xE6, 0x0B, 0xF7, 0x1D, 0xBB, 0x1C, 0x56, 0x69, 0x5C, 0x2E, 0xD8, 0x67, 0x6C, 0x27,
    0x42, 0x95, 0x0E, 0xE2, 0xA7, 0x03, 0x06, 0x40, 0x46, 0x08, 0x32, 0x02, 0x91, 0x99, 0xA9, 0x35,
    0x79, 0xF4, 0x85, 0xE6, 0xDE, 0x52, 0x3E, 0x33, 0x31, 0x3A, 0x50, 0x1C, 0x58, 0x32, 0xB4, 0x64,
    0xC9, 0xE0, 0x12, 0xD7, 0x6F, 0xA2, 0xB0, 0xD0, 0x6A, 0xB6, 0xBC, 0x56, 0x2B, 0x24, 0x8A, 0x22,
    0x74, 0x6C, 0xB0, 0xF6, 0x68, 0x67, 0x56, 0x4A, 0x81, 0x54, 0x12, 0xDF, 0xF3, 0x08, 0x02, 0x9F,
    0x4C, 0x26, 0x20, 0x9B, 0xCD, 0x90, 0xCB, 0x65, 0x8D, 0xF4, 0xFD, 0x56, 0xD3, 0x30, 0xB3, 0x6F,
    0xA6, 0x75, 0x68, 0xCF, 0xC4, 0xF4, 0x91, 0xA9, 0xB9, 0x56, 0xDD, 0xE1, 0xAC, 0x14, 0x22, 0x07,
    0x22, 0x4E, 0xC1, 0xB5, 0x5D, 0x3D, 0xEE, 0xD2, 0xCB, 0x4B, 0xF5, 0x95, 0xA9, 0x74, 0xF2, 0x9D,
    0x36, 0x4E, 0xD8, 0x74, 0xBD, 0x7E, 0x0C, 0x01, 0xA6, 0xF3, 0x9C, 0xCE, 0xBC, 0x8F, 0xDB, 0x71,
    0xD4, 0xCD, 0x6A, 0x98, 0x4A, 0x7B, 0x5F, 0xDA, 0x09, 0x21, 0xAC, 0x00, 0xAF, 0xD6, 0x88, 0xEC,
    0xB6, 0xBD, 0x93, 0x8D, 0xE7, 0x95, 0x1C, 0xAB, 0x14, 0x32, 0xB9, 0xC1, 0x9E, 0x5C, 0xB9, 0xBF,
    0x58, 0xAE, 0x94, 0xCB, 0xB2, 0xE4, 0x4B, 0xF2, 0x9E, 0x20, 0x27, 0x70, 0x7E, 0xB2, 0xA9, 0x97,
    0xF4, 0x4B, 0xA4, 0x94, 0x0E, 0x21, 0x63, 0xED, 0x68, 0xC5, 0x96, 0x66, 0x2B, 0xB6, 0xF5, 0xF1,
    0xE9, 0x70, 0xF6, 0xD0, 0xCC, 0xDC, 0xDC, 0x74, 0xAD, 0xD5, 0x88, 0x62, 0xA3, 0x11, 0x38, 0x29,
    0x84, 0x15, 0x49, 0x73, 0xBC, 0xAD, 0x4B, 0x9C, 0xEA, 0xD1, 0xEA, 0xD2, 0xA9, 0x93, 0xF8, 0xDA,
    0xF1, 0xDF, 0x6D, 0xCE, 0xC0, 0x57, 0xAE, 0xFD, 0xF6, 0x18, 0x02, 0x76, 0x8D, 0x4F, 0x93, 0xCF,
    0xD4, 0x88, 0x8D, 0x71, 0x4A, 0xCA, 0x36, 0x70, 0x9D, 0x82, 0x6E, 0x74, 0x25, 0x19, 0xD2, 0x41,
    0x9A, 0x69, 0xEC, 0x65, 0xD3, 0xCF, 0x93, 0xC7, 0x78, 0x84, 0xF0, 0x9C, 0x73, 0x72, 0xAA, 0xDA,
    0x94, 0x47, 0xE6, 0x9A, 0x07, 0x85, 0x40, 0x7A, 0x4A, 0xAA, 0x8C, 0xEF, 0x79, 0xB9, 0x8C, 0xE7,
    0x67, 0x7D, 0x15, 0x28, 0x21, 0x54, 0xBA, 0x45, 0xE3, 0xAC, 0xC5, 0x46, 0xDA, 0xE8, 0x46, 0x18,
    0xC7, 0xAD, 0xC8, 0xC4, 0xDA, 0x58, 0x6B, 0x9D, 0xB3, 0x49, 0x57, 0x5E, 0x38, 0x29, 0x85, 0x65,
    0x7E, 0x4C, 0xEB, 0x2E, 0xBD, 0xDA, 0x04, 0x34, 0x80, 0x2A, 0x30, 0x9B, 0x9E, 0x1B, 0xE9, 0x77,
    0x6D, 0x22, 0x9C, 0xA7, 0x04, 0x6F, 0x39, 0x7B, 0x2D, 0xBB, 0xC7, 0xA6, 0xF8, 0xE9, 0x62, 0x04,
    0xD4, 0x1B, 0x21, 0xF5, 0x23, 0x73, 0xE4, 0xFA, 0x8A, 0xDD, 0x96, 0x6F, 0x03, 0x6D, 0x67, 0x56,
    0x9D, 0xBE, 0xAF, 0x02, 0xB9, 0x14, 0x7C, 0x9B, 0x98, 0xB6, 0x78, 0x80, 0x12, 0x42, 0x28, 0x95,
    0xFC, 0xC3, 0x98, 0xB4, 0xD6, 0xC9, 0x46, 0x2B, 0x16, 0xF5, 0x56, 0x24, 0xE9, 0xD8, 0xE0, 0xA8,
    0x6B, 0x0A, 0x91, 0xB4, 0xD4, 0x84, 0x48, 0xB6, 0x23, 0x94, 0xE8, 0x80, 0xEE, 0x06, 0xDF, 0x4D,
    0x40, 0xDB, 0x1B, 0x23, 0x8E, 0x4E, 0x7B, 0x0D, 0xA0, 0x96, 0xEA, 0x56, 0x4D, 0x3F, 0x8B, 0x01,
    0xE3, 0x9C, 0x73, 0xC3, 0xBD, 0x25, 0xF7, 0xBA, 0x93, 0x96, 0x52, 0xC8, 0x07, 0x8B, 0x13, 0x80,
    0x10, 0xE4, 0xFB, 0x4B, 0x48, 0x21, 0x3A, 0x2D, 0xC0, 0x54, 0xC9, 0xB0, 0x2B, 0xB9, 0x84, 0xE9,
    0x20, 0x6D, 0xCB, 0xB7, 0xE3, 0xAE, 0x1B, 0x7C, 0x3B, 0x06, 0xDB, 0x71, 0xA8, 0x20, 0x9D, 0xF2,
    0x11, 0xB2, 0xB3, 0x39, 0x37, 0x9F, 0x04, 0xD7, 0x75, 0xB6, 0x5D, 0xE7, 0xE3, 0x59, 0x7F, 0x31,
    0x12, 0x42, 0xE6, 0xD7, 0x01, 0xED, 0x24, 0x68, 0x00, 0xE7, 0xFB, 0xCA, 0x7D, 0xE0, 0xBA, 0x73,
    0x78, 0x70, 0xCB, 0x5E, 0x3E, 0xB7, 0x28, 0x01, 0x0F, 0x7E, 0x02, 0xF9, 0xE6, 0x4F, 0x2C, 0x8C,
    0x7F, 0xDD, 0xA5, 0x8C, 0x4E, 0x6F, 0xEE, 0x2F, 0x22, 0x0B, 0x81, 0x77, 0x13, 0xD0, 0x9D, 0x8C,
    0xDA, 0x49, 0xF5, 0x78, 0xC7, 0xF1, 0x08, 0x68, 0x8F, 0x6F, 0xBA, 0xA4, 0x1D, 0xEB, 0x71, 0x97,
    0x44, 0x5D, 0x9F, 0xB5, 0xAF, 0x77, 0x80, 0xDB, 0xB6, 0x65, 0x3F, 0x1B, 0xFE, 0xE8, 0xF3, 0x8C,
    0x4D, 0xCC, 0xC1, 0xA2, 0x04, 0x1C, 0xAB, 0x48, 0xFB, 0xDC, 0x4D, 0x40, 0xDC, 0x65, 0xD5, 0xC5,
    0xC0, 0x76, 0xBF, 0x6E, 0x17, 0x53, 0x62, 0x81, 0xBC, 0x12, 0x01, 0xDD, 0x63, 0x2E, 0x46, 0x84,
    0x59, 0x40, 0x48, 0x77, 0x88, 0x98, 0x45, 0xAE, 0x47, 0x08, 0xE1, 0x0A, 0x03, 0x45, 0x76, 0x8D,
    0x4D, 0x71, 0xFD, 0x25, 0x1B, 0xE7, 0xB9, 0xDE, 0x31, 0x47, 0x71, 0xBE, 0x17, 0x74, 0x5F, 0xDB,
    0x0D, 0xA0, 0xFB, 0xB5, 0x5C, 0xE4, 0xBB, 0xEE, 0xCF, 0xBA, 0x85, 0x45, 0xCE, 0x0B, 0x09, 0x5F,
    0x48, 0xC4, 0x42, 0x42, 0x16, 0x92, 0xB3, 0xF0, 0xBC, 0xF0, 0xF7, 0x9D, 0xA3, 0x76, 0xEF, 0xC7,
    0x8E, 0x01, 0xF5, 0x6A, 0x49, 0x58, 0x4C, 0xF1, 0x85, 0xC4, 0x74, 0xBF, 0x7E, 0x25, 0xC0, 0xAF,
    0x74, 0x1C, 0x8F, 0x90, 0xC5, 0xC8, 0xE1, 0x65, 0xCE, 0x8B, 0x82, 0x07, 0xF8, 0xBF, 0xBC, 0x7A,
    0x38, 0x97, 0x7C, 0xD1, 0xFC, 0xA1, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
    0x74, 0x65, 0x3A, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x32, 0x30, 0x2D, 0x30,
    0x33, 0x2D, 0x31, 0x39, 0x54, 0x31, 0x30, 0x3A, 0x35, 0x30, 0x3A, 0x35, 0x38, 0x2B, 0x30, 0x30,
    0x3A, 0x30, 0x30, 0x62, 0x40, 0x28, 0xF1, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
    0x61, 0x74, 0x65, 0x3A, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D,
    0x30, 0x31, 0x2D, 0x30, 0x38, 0x54, 0x31, 0x35, 0x3A, 0x35, 0x34, 0x3A, 0x32, 0x33, 0x2B, 0x30,
    0x30, 0x3A, 0x30, 0x30, 0x8A, 0xEF, 0xF9, 0x19, 0x00, 0x00, 0x00, 0x20, 0x74, 0x45, 0x58, 0x74,
    0x73, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F,
    0x2F, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x6D, 0x61, 0x67, 0x69, 0x63, 0x6B, 0x2E, 0x6F, 0x72, 0x67,
    0xBC, 0xCF, 0x1D, 0x9D, 0x00, 0x00, 0x00, 0x18, 0x74, 0x45, 0x58, 0x74, 0x54, 0x68, 0x75, 0x6D,
    0x62, 0x3A, 0x3A, 0x44, 0x6F, 0x63, 0x75, 0x6D, 0x65, 0x6E, 0x74, 0x3A, 0x3A, 0x50, 0x61, 0x67,
    0x65, 0x73, 0x00, 0x31, 0xA7, 0xFF, 0xBB, 0x2F, 0x00, 0x00, 0x00, 0x18, 0x74, 0x45, 0x58, 0x74,
    0x54, 0x68, 0x75, 0x6D, 0x62, 0x3A, 0x3A, 0x49, 0x6D, 0x61, 0x67, 0x65, 0x3A, 0x3A, 0x48, 0x65,
    0x69, 0x67, 0x68, 0x74, 0x00, 0x31, 0x32, 0x38, 0x43, 0x7C, 0x41, 0x80, 0x00, 0x00, 0x00, 0x17,
    0x74, 0x45, 0x58, 0x74, 0x54, 0x68, 0x75, 0x6D, 0x62, 0x3A, 0x3A, 0x49, 0x6D, 0x61, 0x67, 0x65,
    0x3A, 0x3A, 0x57, 0x69, 0x64, 0x74, 0x68, 0x00, 0x31, 0x32, 0x38, 0xD0, 0x8D, 0x11, 0xDD, 0x00,
    0x00, 0x00, 0x19, 0x74, 0x45, 0x58, 0x74, 0x54, 0x68, 0x75, 0x6D, 0x62, 0x3A, 0x3A, 0x4D, 0x69,
    0x6D, 0x65, 0x74, 0x79, 0x70, 0x65, 0x00, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x70, 0x6E, 0x67,
    0x3F, 0xB2, 0x56, 0x4E, 0x00, 0x00, 0x00, 0x17, 0x74, 0x45, 0x58, 0x74, 0x54, 0x68, 0x75, 0x6D,
    0x62, 0x3A, 0x3A, 0x4D, 0x54, 0x69, 0x6D, 0x65, 0x00, 0x31, 0x35, 0x34, 0x36, 0x39, 0x36, 0x32,
    0x38, 0x36, 0x33, 0x1F, 0x1E, 0xB3, 0x01, 0x00, 0x00, 0x00, 0x12, 0x74, 0x45, 0x58, 0x74, 0x54,
    0x68, 0x75, 0x6D, 0x62, 0x3A, 0x3A, 0x53, 0x69, 0x7A, 0x65, 0x00, 0x31, 0x39, 0x32, 0x37, 0x34,
    0x42, 0x0A, 0x19, 0xAB, 0x42, 0x00, 0x00, 0x00, 0x56, 0x74, 0x45, 0x58, 0x74, 0x54, 0x68, 0x75,
    0x6D, 0x62, 0x3A, 0x3A, 0x55, 0x52, 0x49, 0x00, 0x66, 0x69, 0x6C, 0x65, 0x3A, 0x2F, 0x2F, 0x2F,
    0x64, 0x61, 0x74, 0x61, 0x2F, 0x77, 0x77, 0x77, 0x72, 0x6F, 0x6F, 0x74, 0x2F, 0x77, 0x77, 0x77,
    0x2E, 0x65, 0x61, 0x73, 0x79, 0x69, 0x63, 0x6F, 0x6E, 0x2E, 0x6E, 0x65, 0x74, 0x2F, 0x63, 0x64,
    0x6E, 0x2D, 0x69, 0x6D, 0x67, 0x2E, 0x65, 0x61, 0x73, 0x79, 0x69, 0x63, 0x6F, 0x6E, 0x2E, 0x63,
    0x6E, 0x2F, 0x66, 0x69, 0x6C, 0x65, 0x73, 0x2F, 0x32, 0x2F, 0x32, 0x39, 0x31, 0x36, 0x35, 0x2E,
    0x70, 0x6E, 0x67, 0xBF, 0x98, 0x5F, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE,
    0x42, 0x60, 0x82 
};

void *get_window_icon_raw_data(int *len)
{
    *len = (int)sizeof(window_icon_hexData);
    return window_icon_hexData;
}

