/******************************************************************************
 * Language.c
 *
 * Copyright (c) 2020, longpanda <admin@ventoy.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */
 
#include <Windows.h>
#include "Ventoy2Disk.h"
#include "Language.h"

const TCHAR * g_Str_English[STR_ID_MAX] =
{
    TEXT("Error"),
    TEXT("Warning"),
    TEXT("Info"),
    TEXT("Please run under the correct directory!"),
    TEXT("Device"),
    TEXT("Ventoy At Local"),
    TEXT("Ventoy In Device"),
    TEXT("Status - READY"),
    TEXT("Install"),
    TEXT("Update"),
    TEXT("Upgrade operation is safe, ISO files will be unchanged.\r\nContinue?"),
    TEXT("The disk will be formatted and all the data will be lost.\r\nContinue?"),
    TEXT("The disk will be formatted and all the data will be lost.\r\nContinue? (Double Check)"),
    TEXT("Congratulations!\r\nVentoy has been successfully installed to the device."),
    TEXT("An error occurred during the installation. You can replug the USB and try again. Check log.txt for detail."),
    TEXT("Congratulations!\r\nVentoy has been successfully updated to the device."),
    TEXT("An error occurred during the update. You can replug the USB and try again. Check log.txt for detail."),

    TEXT("A thread is running, please wait..."),
};

const TCHAR * g_Str_ChineseSimple[STR_ID_MAX] =
{
    TEXT(""),
    TEXT(""),
    TEXT(""),
    TEXT("ȷĿ¼!"),
    TEXT("豸"),
    TEXT("װ Ventoy 汾"),
    TEXT("豸ڲ Ventoy 汾"),
    TEXT("״̬ - ׼"),
    TEXT("װ"),
    TEXT(""),
    TEXT("ǰȫ, ISOļᶪʧ\r\nǷ"),
    TEXT("̻ᱻʽ, ݶᶪʧ!\r\nǷ"),
    TEXT("̻ᱻʽ, ݶᶪʧ!\r\nٴȷǷ"),
    TEXT("ϲ! Ventoy Ѿɹװ豸."),
    TEXT("װ Ventoy з. °βһUȻһ, ϸϢ log.txt ļ."),
    TEXT("ϲ! °汾 Ventoy Ѿɹµ豸."),
    TEXT(" Ventoy . °βһUȻһ, ϸϢ log.txt ļ."),

    TEXT("ǰ, ȴ..."),
};

const TCHAR * GetString(enum STR_ID ID)
{
	return g_cur_lang_data->MsgString[ID];
};
