import modes.experiments as exp
import modes.simulators as sim
import modes.nodeconfig as node


# iperf TCP_multi_client test
# naming convention following host-nic-net-app
# host: gem5-timing
# nic:  cv/cb/ib
# net:  switch/dumbbell/bridge
# app: TCPm

kinds_of_host = ['gem5-timing']
kinds_of_nic = ['cv','cb','ib']
kinds_of_net = ['switch', 'dumbbell', 'bridge']
kinds_of_app = ['TCPm']

num_client = 4

experiments = []

# set network sim
for n in kinds_of_net:

    if n == 'switch':
        net_class = sim.SwitchNet
    if n == 'dumbbell':
        net_class = sim.NS3DumbbellNet
    if n == 'bridge':
        net_class = sim.NS3BridgeNet


    # set nic sim
    for c in kinds_of_nic:
        net = net_class()
        e = exp.Experiment('gt-'  + c + '-' + n + '-' + 'TCPm')
        e.add_network(net)
        e.checkpoint = True
        
        if c == 'cv':
            servers = sim.create_basic_hosts(e, 1, 'server', net, sim.CorundumVerilatorNIC, sim.Gem5Host, 
                                             node.CorundumLinuxNode, node.IperfTCPServer)
            clients = sim.create_basic_hosts(e, num_client, 'client', net, sim.CorundumVerilatorNIC, sim.Gem5Host, 
                                             node.CorundumLinuxNode, node.IperfTCPClient, ip_start = 2)

        
        if c == 'cb':
            servers = sim.create_basic_hosts(e, 1, 'server', net, sim.CorundumBMNIC, sim.Gem5Host, 
                                             node.CorundumLinuxNode, node.IperfTCPServer)
            clients = sim.create_basic_hosts(e, num_client, 'client', net, sim.CorundumBMNIC, sim.Gem5Host, 
                                             node.CorundumLinuxNode, node.IperfTCPClient, ip_start = 2)
            
        

        if c == 'ib':
            servers = sim.create_basic_hosts(e, 1, 'server', net, sim.I40eNIC, sim.Gem5Host, 
                                             node.I40eLinuxNode, node.IperfTCPServer)
            clients = sim.create_basic_hosts(e, num_client, 'client', net, sim.I40eNIC, sim.Gem5Host, 
                                             node.I40eLinuxNode, node.IperfTCPClient, ip_start = 2)
            
        
        for cl in clients:
            cl.wait = True
            cl.node_config.app.server_ip = servers[0].node_config.ip

        print(e.name)
        experiments.append(e)

