
variable "cpus" {
  type    = string
  default = "4"
}

variable "memory" {
  type    = string
  default = "4096"
}

variable "outname" {
  type    = string
  default = "base"
}

variable "base_img" {
  type    = string
  default = "unused"
}

variable "compressed" {
  type    = bool
  default = false
}

source "qemu" "autogenerated_1" {
  communicator     = "ssh"
  cpus             = "${var.cpus}"
  disk_image       = true
  disk_compression = "${var.compressed}"
  headless         = true
  http_directory   = "scripts"
  iso_checksum     = "file:https://cloud-images.ubuntu.com/minimal/releases/jammy/release/SHA256SUMS"
  iso_url          = "https://cloud-images.ubuntu.com/minimal/releases/jammy/release/ubuntu-22.04-minimal-cloudimg-amd64.img"
  memory           = "${var.memory}"
  net_device       = "virtio-net"
  output_directory = "output-${var.outname}"
  qemuargs         = [["-smbios", "type=1,serial=ds=nocloud-net;instance-id=packer;seedfrom=http://{{ .HTTPIP }}:{{ .HTTPPort }}/"],
                      ["-machine", "pc-q35-4.2,accel=kvm:tcg,usb=off,vmport=off,dump-guest-core=off"]]
  shutdown_command = "sudo shutdown --poweroff --no-wall now"
  ssh_password     = "ubuntu"
  ssh_username     = "ubuntu"
  vm_name          = "${var.outname}"
}

build {
  sources = ["source.qemu.autogenerated_1"]

  provisioner "file" {
    direction = "upload"
    source = "input-${var.outname}"
    destination = "/tmp/input"
  }

  provisioner "shell" {
    execute_command = "{{ .Vars }} sudo -S -E bash '{{ .Path }}'"
    scripts         = ["scripts/install-${var.outname}.sh", "scripts/cleanup.sh"]
  }

}
