SDXL Benchmark CI/CD
This project uses GitLab CI/CD to automate the benchmarking of the Stable Diffusion XL model on a DCU environment.

Pipeline Stages
prepare: Downloads the SDXL models and necessary libraries (rocblas, miopen). These files are cached to speed up subsequent pipelines.
install: Extracts libraries, replaces VAE weights, and installs specific Python packages. The installed packages are also cached.
test: Sets up environment variables and runs the test.py benchmark script. The output images and a results.json performance report are saved as artifacts.
How it Works
The pipeline runs on a GitLab Runner with the demos tag.
It uses a specific Docker image that contains the base PyTorch and DCU environment.
All heavy lifting (downloads, installations) is cached based on the branch name (${CI_COMMIT_REF_SLUG}).
The final test results, including generated images and performance metrics, are available for download from the CI/CD job artifacts page.
