---
name: 复现问题
about: 询问模型复现中的问题
title: ''
labels: reimplementation
assignees: ''
---

**注意**

在复现的问题中，通常有以下几种常见情况：

1. 使用提供的配置复现模型库中的模型
2. 在其他数据集（例如自定义数据集）上复现模型库中的模型
3. 实现自定义模型，但利用的都是HunyuanDiT中实现的组件
4. 使用自己实现的新模块实现自定义模型

针对不同情况需要做的事情如下：

- 对于情况 1 和 3，请按照以下部分的步骤操作，以便我们快速识别问题。
- 对于情况 2 和 4，请理解我们无法提供太多帮助，因为我们通常不了解全部代码，用户应对自己编写的代码负责。
- 针对情况 2 和 4 的一个建议是，用户应首先检查错误是否在自实现代码中或原始代码中。例如，用户可以首先确保相同的模型在支持的数据集上运行良好。如果您仍然需要帮助，请描述您所做的工作和遇到的问题，并按照以下部分的步骤尽可能清晰地描述，以便我们更好地帮助您。

**检查清单**

1. 我已搜索相关问题，但无法获得预期的帮助。
2. 最新版本中尚未修复此问题。

**描述问题**

清晰简洁地描述您遇到的问题以及您所做的工作。

**重现步骤**

1. 您运行了什么命令或脚本？

```none
命令的占位符。
```

2. 您运行的配置目录是什么？

```none
配置目录的占位符
```

3. 您是否对代码或配置进行了任何修改？您是否理解您所修改的内容？
4. 您使用了什么数据集？

**环境**

1. 请运行 python utils/collect_env.py 收集必要的环境信息并粘贴在此。

2. 您可以添加其他有助于定位问题的信息，例如
   - 您如何安装的 PyTorch \[例如，pip, conda, source\]
   - 其他可能相关的环境变量 (例如 `$PATH`, `$LD_LIBRARY_PATH`, `$PYTHONPATH` 等)

**结果**

如果适用，请在此粘贴相关结果，例如，您的预期结果和实际结果。

```none
结果比较的占位符
```

**Bug修复**

如果您已经确定了原因，可以在此提供信息。如果您愿意创建 PR 进行修复，也请在此留言，我们将不胜感激！